/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.base;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.domain.Sort;

public final class EntityViewSortUtil {
    private EntityViewSortUtil() {
    }

    private static String resolveViewAttributeSelectAlias(ManagedViewType<?> viewType, String attributePath) {
        StringBuilder aliasBuilder = new StringBuilder(viewType.getJavaType().getSimpleName());
        for (String pathElement : attributePath.split("\\.")) {
            if (viewType == null) {
                return null;
            }
            MethodAttribute attribute = viewType.getAttribute(pathElement);
            if (attribute == null) {
                return null;
            }
            aliasBuilder.append('_').append(pathElement);
            Type type = attribute instanceof com.blazebit.persistence.view.metamodel.SingularAttribute ? ((com.blazebit.persistence.view.metamodel.SingularAttribute)attribute).getType() : ((PluralAttribute)attribute).getElementType();
            viewType = type instanceof ManagedViewType ? (ManagedViewType)type : null;
        }
        return aliasBuilder.toString();
    }

    public static void applySort(EntityViewManager evm, Class<?> entityViewClass, FullQueryBuilder<?, ?> cb, Sort sort) {
        ManagedViewType viewType = evm.getMetamodel().managedViewOrError(entityViewClass);
        for (Sort.Order order : sort) {
            String entityViewAttributeAlias = EntityViewSortUtil.resolveViewAttributeSelectAlias(viewType, order.getProperty());
            if (entityViewAttributeAlias == null) {
                PathExpression pathExpression;
                try {
                    pathExpression = ((ExpressionFactory)cb.getService(ExpressionFactory.class)).createPathExpression(order.getProperty());
                }
                catch (RuntimeException ex) {
                    throw new IllegalArgumentException("Sort order [" + order.getProperty() + "] is not resolvable to a path expression.", ex);
                }
                EntityType resultType = cb.getMetamodel().entity(viewType.getEntityClass());
                for (PathElementExpression expression : pathExpression.getExpressions()) {
                    if (!(resultType instanceof ManagedType)) {
                        throw new IllegalArgumentException("Sort order [" + order.getProperty() + "] is not resolvable to a valid path expression, because the type [" + resultType.getJavaType().getName() + "] can't be de-referenced.");
                    }
                    ManagedType managedType = (ManagedType)resultType;
                    Attribute attribute = managedType.getAttribute(expression.toString());
                    if (!(attribute instanceof SingularAttribute)) {
                        throw new IllegalArgumentException("Sort order [" + order.getProperty() + "] is not resolvable to a valid path expression, because the type [" + resultType.getJavaType().getName() + "] does not contain a singular attribute named [" + expression + "].");
                    }
                    resultType = ((SingularAttribute)attribute).getType();
                }
                cb.orderBy(order.getProperty(), order.isAscending(), order.getNullHandling() == Sort.NullHandling.NULLS_FIRST);
                continue;
            }
            cb.orderBy(entityViewAttributeAlias, order.isAscending(), order.getNullHandling() == Sort.NullHandling.NULLS_FIRST);
        }
    }
}

