/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.webmvc.impl;

import com.blazebit.persistence.DefaultKeyset;
import com.blazebit.persistence.DefaultKeysetPage;
import com.blazebit.persistence.Keyset;
import com.blazebit.persistence.spring.data.repository.KeysetPageRequest;
import com.blazebit.persistence.spring.data.repository.KeysetPageable;
import com.blazebit.persistence.spring.data.webmvc.KeysetConfig;
import com.blazebit.persistence.spring.data.webmvc.KeysetPageableArgumentResolver;
import com.blazebit.persistence.spring.data.webmvc.impl.Sort;
import com.blazebit.reflection.ReflectionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class KeysetPageableHandlerMethodArgumentResolver
extends PageableHandlerMethodArgumentResolver
implements KeysetPageableArgumentResolver {
    private static final String DEFAULT_OFFSET_PARAMETER = "offset";
    private static final String DEFAULT_PREVIOUS_OFFSET_PARAMETER = "prevOffset";
    private static final String DEFAULT_PREVIOUS_PAGE_PARAMETER = "prevPage";
    private static final String DEFAULT_PREVIOUS_SIZE_PARAMETER = "prevSize";
    private static final String DEFAULT_LOWEST_PARAMETER = "lowest";
    private static final String DEFAULT_HIGHEST_PARAMETER = "highest";
    private static final String INVALID_DEFAULT_PAGE_SIZE = "Invalid default page size configured for method %s! Must not be less than one!";
    private static final String INVALID_KEYSET_DOMAIN_CLASS = "Invalid keyset domain class configured for method %s! Should be an entity type!";
    private static final KeysetPageable DEFAULT_PAGE_REQUEST;
    private static final org.springframework.data.domain.Sort UNSORTED;
    private final ConcurrentMap<PropertyCacheKey, Class<? extends Serializable>> propertyTypeCache;
    private final ObjectMapper mapper;
    private final SortHandlerMethodArgumentResolver sortResolver;
    private final ConversionService conversionService;
    private KeysetPageable fallbackPageable;
    private String offsetParameterName;
    private String previousOffsetParameterName;
    private String previousPageParameterName;
    private String previousSizeParameterName;
    private String lowestParameterName;
    private String highestParameterName;

    public KeysetPageableHandlerMethodArgumentResolver() {
        this(null);
    }

    public KeysetPageableHandlerMethodArgumentResolver(ConversionService conversionService) {
        this(null, conversionService, null);
    }

    public KeysetPageableHandlerMethodArgumentResolver(SortHandlerMethodArgumentResolver sortResolver, ConversionService conversionService, ObjectMapper objectMapper) {
        sortResolver = sortResolver == null ? new SortHandlerMethodArgumentResolver() : sortResolver;
        super(sortResolver);
        this.propertyTypeCache = new ConcurrentHashMap<PropertyCacheKey, Class<? extends Serializable>>();
        this.fallbackPageable = DEFAULT_PAGE_REQUEST;
        this.offsetParameterName = DEFAULT_OFFSET_PARAMETER;
        this.previousOffsetParameterName = DEFAULT_PREVIOUS_OFFSET_PARAMETER;
        this.previousPageParameterName = DEFAULT_PREVIOUS_PAGE_PARAMETER;
        this.previousSizeParameterName = DEFAULT_PREVIOUS_SIZE_PARAMETER;
        this.lowestParameterName = DEFAULT_LOWEST_PARAMETER;
        this.highestParameterName = DEFAULT_HIGHEST_PARAMETER;
        this.sortResolver = sortResolver;
        this.conversionService = conversionService;
        this.mapper = objectMapper == null ? new ObjectMapper() : objectMapper;
    }

    @Override
    public void setFallbackPageable(Pageable fallbackPageable) {
        this.setFallbackPageable((KeysetPageable)fallbackPageable);
    }

    @Override
    public void setFallbackPageable(KeysetPageable fallbackPageable) {
        this.fallbackPageable = fallbackPageable;
    }

    public boolean isFallbackPageable(Pageable pageable) {
        return this.fallbackPageable == null ? false : this.fallbackPageable.equals(pageable);
    }

    protected String getOffsetParameterName() {
        return this.offsetParameterName;
    }

    @Override
    public void setOffsetParameterName(String offsetParameterName) {
        this.offsetParameterName = offsetParameterName;
    }

    protected String getPreviousOffsetParameterName() {
        return this.previousOffsetParameterName;
    }

    @Override
    public void setPreviousOffsetParameterName(String previousOffsetParameterName) {
        this.previousOffsetParameterName = previousOffsetParameterName;
    }

    protected String getPreviousPageParameterName() {
        return this.previousPageParameterName;
    }

    @Override
    public void setPreviousPageParameterName(String previousPageParameterName) {
        this.previousPageParameterName = previousPageParameterName;
    }

    protected String getPreviousSizeParameterName() {
        return this.previousSizeParameterName;
    }

    @Override
    public void setPreviousSizeParameterName(String previousSizeParameterName) {
        this.previousSizeParameterName = previousSizeParameterName;
    }

    protected String getLowestParameterName() {
        return this.lowestParameterName;
    }

    @Override
    public void setLowestParameterName(String lowestParameterName) {
        this.lowestParameterName = lowestParameterName;
    }

    protected String getHighestParameterName() {
        return this.highestParameterName;
    }

    @Override
    public void setHighestParameterName(String highestParameterName) {
        this.highestParameterName = highestParameterName;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return KeysetPageable.class.equals((Object)parameter.getParameterType());
    }

    protected SortHandlerMethodArgumentResolver getSortResolver() {
        return this.sortResolver;
    }

    public KeysetPageable resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Iterator iterator;
        boolean pageAndSizeGiven;
        KeysetPageableHandlerMethodArgumentResolver.assertPageableUniqueness(methodParameter);
        KeysetPageable defaultOrFallback = this.getDefaultFromAnnotationOrFallback(methodParameter);
        String pageString = webRequest.getParameter(this.getParameterNameToUse(this.getPageParameterName(), methodParameter));
        String offsetString = webRequest.getParameter(this.getParameterNameToUse(this.getOffsetParameterName(), methodParameter));
        String pageSizeString = webRequest.getParameter(this.getParameterNameToUse(this.getSizeParameterName(), methodParameter));
        boolean bl = pageAndSizeGiven = (StringUtils.hasText((String)pageString) || StringUtils.hasText((String)offsetString)) && StringUtils.hasText((String)pageSizeString);
        if (!pageAndSizeGiven && defaultOrFallback == null) {
            return null;
        }
        int pageSize = StringUtils.hasText((String)pageSizeString) ? this.parseAndApplyBoundaries(pageSizeString, this.getMaxPageSize(), false) : defaultOrFallback.getPageSize();
        pageSize = pageSize < 1 ? defaultOrFallback.getPageSize() : pageSize;
        int n = pageSize = pageSize > this.getMaxPageSize() ? this.getMaxPageSize() : pageSize;
        int offset = StringUtils.hasText((String)offsetString) ? this.parseAndApplyBoundaries(offsetString, Integer.MAX_VALUE, false) : (StringUtils.hasText((String)pageString) ? pageSize * this.parseAndApplyBoundaries(pageString, Integer.MAX_VALUE, true) : pageSize * defaultOrFallback.getPageNumber());
        org.springframework.data.domain.Sort sort = this.sortResolver.resolveArgument(methodParameter, mavContainer, webRequest, binderFactory);
        sort = sort == UNSORTED && defaultOrFallback != null ? defaultOrFallback.getSort() : sort;
        DefaultKeysetPage keysetPage = null;
        if (sort != null && (iterator = sort.iterator()).hasNext()) {
            KeysetConfig keysetConfig = (KeysetConfig)methodParameter.getParameterAnnotation(KeysetConfig.class);
            Class<?> domainClass = keysetConfig.keysetClass();
            if (domainClass == Void.TYPE) {
                domainClass = keysetConfig.value();
            }
            if (domainClass == Void.TYPE) {
                Method annotatedMethod = methodParameter.getMethod();
                throw new IllegalStateException(String.format(INVALID_KEYSET_DOMAIN_CLASS, annotatedMethod));
            }
            String previousOffsetName = KeysetPageableHandlerMethodArgumentResolver.getParameterName(keysetConfig.previousOffsetName(), this.getParameterNameToUse(this.getPreviousOffsetParameterName(), methodParameter));
            String previousOffsetString = webRequest.getParameter(previousOffsetName);
            String previousPageName = KeysetPageableHandlerMethodArgumentResolver.getParameterName(keysetConfig.previousPageName(), this.getParameterNameToUse(this.getPreviousPageParameterName(), methodParameter));
            String previousPageString = webRequest.getParameter(previousPageName);
            if (StringUtils.hasText((String)previousOffsetString) || StringUtils.hasText((String)previousPageString)) {
                int previousOffset;
                int previousPageSize;
                String previousPageSizeName = KeysetPageableHandlerMethodArgumentResolver.getParameterName(keysetConfig.previousPageSizeName(), this.getParameterNameToUse(this.getPreviousSizeParameterName(), methodParameter));
                String previousPageSizeString = webRequest.getParameter(previousPageSizeName);
                int n2 = previousPageSize = StringUtils.hasText((String)previousPageSizeString) ? this.parseAndApplyBoundaries(previousPageSizeString, this.getMaxPageSize(), false) : pageSize;
                if (StringUtils.hasText((String)previousOffsetString)) {
                    previousOffset = this.parseAndApplyBoundaries(previousOffsetString, Integer.MAX_VALUE, false);
                } else {
                    int previousPage = this.parseAndApplyBoundaries(previousPageString, Integer.MAX_VALUE, true);
                    previousOffset = previousPage * previousPageSize;
                }
                String lowestName = KeysetPageableHandlerMethodArgumentResolver.getParameterName(keysetConfig.lowestName(), this.getParameterNameToUse(this.getLowestParameterName(), methodParameter));
                String lowestString = webRequest.getParameter(lowestName);
                String highestName = KeysetPageableHandlerMethodArgumentResolver.getParameterName(keysetConfig.highestName(), this.getParameterNameToUse(this.getHighestParameterName(), methodParameter));
                String highestString = webRequest.getParameter(highestName);
                if (StringUtils.hasText((String)lowestString) && StringUtils.hasText((String)highestString)) {
                    JsonNode highestObject;
                    JsonNode lowestObject;
                    ArrayList<Serializable> lowest = new ArrayList<Serializable>();
                    ArrayList<Serializable> highest = new ArrayList<Serializable>();
                    try {
                        lowestObject = this.mapper.readTree(lowestString);
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Invalid lowest object!", ex);
                    }
                    try {
                        highestObject = this.mapper.readTree(highestString);
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Invalid highest object!", ex);
                    }
                    while (iterator.hasNext()) {
                        Sort.Order o = (Sort.Order)iterator.next();
                        JsonNode low = lowestObject;
                        JsonNode high = highestObject;
                        String[] propertyParts = o.getProperty().split("\\.");
                        Class<? extends Serializable> propertyType = this.getPropertyType(domainClass, o.getProperty());
                        for (int i = 0; i < propertyParts.length; ++i) {
                            low = low == null ? null : low.get(propertyParts[i]);
                            high = high == null ? null : high.get(propertyParts[i]);
                        }
                        lowest.add(low == null ? null : this.convert(low, propertyType));
                        highest.add(high == null ? null : this.convert(high, propertyType));
                    }
                    keysetPage = new DefaultKeysetPage(previousOffset, previousPageSize, (Keyset)new DefaultKeyset(lowest.toArray(new Serializable[lowest.size()])), (Keyset)new DefaultKeyset(highest.toArray(new Serializable[highest.size()])));
                }
            }
        }
        return new KeysetPageRequest(keysetPage, sort, offset, pageSize);
    }

    private static String getParameterName(String name, String defaultName) {
        if (name == null || name.isEmpty()) {
            return defaultName;
        }
        return name;
    }

    private Serializable convert(JsonNode valueNode, Class<? extends Serializable> propertyType) {
        switch (valueNode.getNodeType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
                    return Boolean.valueOf(valueNode.asBoolean());
                }
                return (Serializable)this.conversionService.convert((Object)valueNode.asBoolean(), propertyType);
            }
            case NUMBER: {
                Number number = valueNode.numberValue();
                if (propertyType == Integer.class || propertyType == Integer.TYPE) {
                    return Integer.valueOf(number.intValue());
                }
                if (propertyType == Long.class || propertyType == Long.TYPE) {
                    return Long.valueOf(number.longValue());
                }
                if (propertyType == Double.class || propertyType == Double.TYPE) {
                    return Double.valueOf(number.doubleValue());
                }
                if (propertyType == Float.class || propertyType == Float.TYPE) {
                    return Float.valueOf(number.floatValue());
                }
                if (propertyType == Byte.class || propertyType == Byte.TYPE) {
                    return Byte.valueOf(number.byteValue());
                }
                if (propertyType == Short.class || propertyType == Short.TYPE) {
                    return Short.valueOf(number.shortValue());
                }
                if (propertyType == BigInteger.class) {
                    return valueNode.bigIntegerValue();
                }
                if (propertyType == BigDecimal.class) {
                    return valueNode.decimalValue();
                }
                if (this.conversionService.canConvert(number.getClass(), propertyType)) {
                    return (Serializable)this.conversionService.convert((Object)number, propertyType);
                }
                return (Serializable)this.conversionService.convert((Object)valueNode.asText(), propertyType);
            }
            case STRING: {
                if (propertyType == String.class) {
                    return valueNode.asText();
                }
                return (Serializable)this.conversionService.convert((Object)valueNode.asText(), propertyType);
            }
        }
        throw new IllegalArgumentException("Can't convert value of type '" + valueNode.getNodeType() + "' to '" + propertyType.getName() + "'");
    }

    private Class<? extends Serializable> getPropertyType(Class<?> clazz, String property) {
        PropertyCacheKey cacheKey = new PropertyCacheKey(clazz, property);
        Class<? extends Serializable> propertyType = (Class<? extends Serializable>)this.propertyTypeCache.get(cacheKey);
        if (propertyType == null) {
            propertyType = this.resolvePropertyType(clazz, property);
            this.propertyTypeCache.putIfAbsent(cacheKey, propertyType);
        }
        return propertyType;
    }

    private Class<? extends Serializable> resolvePropertyType(Class<?> baseClazz, String property) {
        Class clazz = baseClazz;
        String[] propertyParts = property.split("\\.");
        for (int i = 0; i < propertyParts.length; ++i) {
            Method getter = ReflectionUtils.getGetter(clazz, (String)propertyParts[i]);
            if (getter == null) {
                Field field = ReflectionUtils.getField(clazz, (String)propertyParts[i]);
                if (field == null) {
                    throw new IllegalArgumentException("Couldn't find property '" + propertyParts[i] + "' on type '" + clazz + "' while resolving path '" + property + "' on type '" + baseClazz + "'");
                }
                Class[] typeArguments = ReflectionUtils.getResolvedFieldTypeArguments(clazz, (Field)field);
                if (typeArguments.length == 0) {
                    clazz = ReflectionUtils.getResolvedFieldType((Class)clazz, (Field)field);
                    continue;
                }
                clazz = typeArguments[typeArguments.length - 1];
                continue;
            }
            Class[] typeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments(clazz, (Method)getter);
            clazz = typeArguments.length == 0 ? ReflectionUtils.getResolvedMethodReturnType(clazz, (Method)getter) : typeArguments[typeArguments.length - 1];
        }
        return clazz;
    }

    private KeysetPageable getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        if (methodParameter.hasParameterAnnotation(PageableDefault.class)) {
            return KeysetPageableHandlerMethodArgumentResolver.getDefaultPageRequestFrom(methodParameter);
        }
        return this.fallbackPageable;
    }

    private static KeysetPageable getDefaultPageRequestFrom(MethodParameter parameter) {
        PageableDefault defaults = (PageableDefault)parameter.getParameterAnnotation(PageableDefault.class);
        Integer defaultPageNumber = defaults.page();
        Integer defaultPageSize = (Integer)KeysetPageableHandlerMethodArgumentResolver.getSpecificPropertyOrDefaultFromValue((Annotation)defaults, "size");
        if (defaultPageSize < 1) {
            Method annotatedMethod = parameter.getMethod();
            throw new IllegalStateException(String.format(INVALID_DEFAULT_PAGE_SIZE, annotatedMethod));
        }
        if (defaults.sort().length == 0) {
            return new KeysetPageRequest(defaultPageNumber.intValue(), defaultPageSize.intValue(), null, null);
        }
        return new KeysetPageRequest(defaultPageNumber.intValue(), defaultPageSize.intValue(), null, Sort.of(defaults.direction(), defaults.sort()));
    }

    private int parseAndApplyBoundaries(String parameter, int upper, boolean shiftIndex) {
        try {
            int parsed = Integer.parseInt(parameter) - (this.isOneIndexedParameters() && shiftIndex ? 1 : 0);
            return parsed < 0 ? 0 : (parsed > upper ? upper : parsed);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static <T> T getSpecificPropertyOrDefaultFromValue(Annotation annotation, String property) {
        Object propertyValue;
        Object propertyDefaultValue = AnnotationUtils.getDefaultValue((Annotation)annotation, (String)property);
        return (T)(ObjectUtils.nullSafeEquals((Object)propertyDefaultValue, (Object)(propertyValue = AnnotationUtils.getValue((Annotation)annotation, (String)property))) ? AnnotationUtils.getValue((Annotation)annotation) : propertyValue);
    }

    private static void assertPageableUniqueness(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (KeysetPageableHandlerMethodArgumentResolver.containsMoreThanOnePageableParameter(method)) {
            Annotation[][] annotations = method.getParameterAnnotations();
            KeysetPageableHandlerMethodArgumentResolver.assertQualifiersFor(method.getParameterTypes(), annotations);
        }
    }

    private static boolean containsMoreThanOnePageableParameter(Method method) {
        boolean pageableFound = false;
        for (Class<?> type : method.getParameterTypes()) {
            if (pageableFound && type.equals(Pageable.class)) {
                return true;
            }
            if (!type.equals(Pageable.class)) continue;
            pageableFound = true;
        }
        return false;
    }

    private static void assertQualifiersFor(Class<?>[] parameterTypes, Annotation[][] annotations) {
        HashSet<String> values = new HashSet<String>();
        for (int i = 0; i < annotations.length; ++i) {
            if (!Pageable.class.equals(parameterTypes[i])) continue;
            Qualifier qualifier = KeysetPageableHandlerMethodArgumentResolver.findAnnotation(annotations[i]);
            if (null == qualifier) {
                throw new IllegalStateException("Ambiguous Pageable arguments in handler method. If you use multiple parameters of type Pageable you need to qualify them with @Qualifier");
            }
            if (values.contains(qualifier.value())) {
                throw new IllegalStateException("Values of the user Qualifiers must be unique!");
            }
            values.add(qualifier.value());
        }
    }

    private static Qualifier findAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Qualifier)) continue;
            return (Qualifier)annotation;
        }
        return null;
    }

    static {
        org.springframework.data.domain.Sort unsorted = null;
        try {
            for (Method unsortedCandidate : org.springframework.data.domain.Sort.class.getDeclaredMethods()) {
                if (!"unsorted".equals(unsortedCandidate.getName())) continue;
                unsorted = (org.springframework.data.domain.Sort)unsortedCandidate.invoke(null, new Object[0]);
                break;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        UNSORTED = unsorted;
        DEFAULT_PAGE_REQUEST = new KeysetPageRequest(null, UNSORTED, 0, 20);
    }

    private static class PropertyCacheKey {
        private final Class<?> clazz;
        private final String property;

        public PropertyCacheKey(Class<?> clazz, String property) {
            this.clazz = clazz;
            this.property = property;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyCacheKey)) {
                return false;
            }
            PropertyCacheKey that = (PropertyCacheKey)o;
            if (!this.clazz.equals(that.clazz)) {
                return false;
            }
            return this.property.equals(that.property);
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }
    }
}

