/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.webmvc.impl.json;

import com.blazebit.persistence.integration.jackson.EntityViewAwareObjectMapper;
import com.blazebit.persistence.integration.jackson.EntityViewIdValueAccessor;
import com.blazebit.persistence.view.EntityViewManager;
import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonInputMessage;

public class EntityViewAwareMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private final EntityViewAwareObjectMapper entityViewAwareObjectMapper;

    public EntityViewAwareMappingJackson2HttpMessageConverter(EntityViewManager entityViewManager, EntityViewIdValueAccessor entityViewIdValueAccessor) {
        this.entityViewAwareObjectMapper = new EntityViewAwareObjectMapper(entityViewManager, this.getObjectMapper(), entityViewIdValueAccessor);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!this.entityViewAwareObjectMapper.canRead(clazz)) {
            return false;
        }
        return super.canRead(clazz, mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        JavaType javaType = this.getJavaType(type, contextClass);
        if (!this.entityViewAwareObjectMapper.canRead(javaType)) {
            return false;
        }
        return super.canRead(type, contextClass, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Type type, Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        JavaType javaType = this.getJavaType(type, contextClass);
        return this.readJavaType(javaType, inputMessage);
    }

    private Object readJavaType(JavaType javaType, HttpInputMessage inputMessage) {
        try {
            Class deserializationView;
            if (inputMessage instanceof MappingJacksonInputMessage && (deserializationView = ((MappingJacksonInputMessage)inputMessage).getDeserializationView()) != null) {
                return this.getObjectMapper().readerWithView(deserializationView).forType(javaType).readValue(inputMessage.getBody());
            }
            return this.entityViewAwareObjectMapper.readerFor(javaType).readValue(inputMessage.getBody());
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("Could not read document: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

