/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.webmvc.impl;

import com.blazebit.persistence.integration.jackson.EntityViewIdValueAccessor;
import com.blazebit.persistence.spring.data.webmvc.KeysetPageableArgumentResolver;
import com.blazebit.persistence.spring.data.webmvc.impl.KeysetPageableHandlerMethodArgumentResolver;
import com.blazebit.persistence.spring.data.webmvc.impl.json.EntityViewAwareMappingJackson2HttpMessageConverter;
import com.blazebit.persistence.spring.data.webmvc.impl.json.EntityViewIdHandlerInterceptor;
import com.blazebit.persistence.spring.data.webmvc.impl.json.EntityViewIdValueHolder;
import com.blazebit.persistence.view.EntityViewManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class BlazePersistenceWebConfiguration
implements WebMvcConfigurer {
    protected final ObjectFactory<ConversionService> conversionService;
    protected final ObjectMapper objectMapper;
    private final EntityViewManager entityViewManager;

    public BlazePersistenceWebConfiguration(EntityViewManager entityViewManager, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService, @Autowired(required=false) ObjectMapper objectMapper) {
        this.entityViewManager = entityViewManager;
        this.conversionService = conversionService;
        this.objectMapper = objectMapper == null ? new ObjectMapper() : objectMapper.copy();
    }

    protected ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @Bean
    public KeysetPageableArgumentResolver blazeWebmvcKeysetPageableResolver() {
        return new KeysetPageableHandlerMethodArgumentResolver(this.blazeWebmvcKeysetSortResolver(), (ConversionService)this.conversionService.getObject(), this.objectMapper());
    }

    @Bean
    public SortHandlerMethodArgumentResolver blazeWebmvcKeysetSortResolver() {
        return new SortHandlerMethodArgumentResolver();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        for (int i = 0; i < argumentResolvers.size(); ++i) {
            if (!(argumentResolvers.get(i) instanceof KeysetPageableArgumentResolver)) continue;
            return;
        }
        argumentResolvers.add(0, (HandlerMethodArgumentResolver)this.blazeWebmvcKeysetPageableResolver());
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)new EntityViewAwareMappingJackson2HttpMessageConverter(this.entityViewManager, this.blazeWebmvcIdAttributeAccessor()));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new EntityViewIdHandlerInterceptor(this.entityViewManager, (EntityViewIdValueHolder)this.blazeWebmvcIdAttributeAccessor()));
    }

    @Bean
    public EntityViewIdValueAccessor blazeWebmvcIdAttributeAccessor() {
        return new EntityViewIdValueHolder((ConversionService)this.conversionService.getObject());
    }
}

