/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spring.data.webmvc.impl.json;

import com.blazebit.persistence.spring.data.webmvc.EntityViewId;
import com.blazebit.persistence.spring.data.webmvc.impl.json.EntityViewIdValueHolder;
import com.blazebit.persistence.view.EntityViewManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public class EntityViewIdHandlerInterceptor
implements HandlerInterceptor,
AsyncHandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(EntityViewIdHandlerInterceptor.class);
    private final EntityViewManager evm;
    private final EntityViewIdValueHolder entityViewIdValueHolder;

    public EntityViewIdHandlerInterceptor(EntityViewManager evm, EntityViewIdValueHolder entityViewIdValueHolder) {
        this.evm = evm;
        this.entityViewIdValueHolder = entityViewIdValueHolder;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Map uriTemplateVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            String entityViewIdPathVariableName = this.resolveEntityViewIdPathVariableName(handlerMethod);
            if (entityViewIdPathVariableName != null) {
                if (entityViewIdPathVariableName.isEmpty()) {
                    throw new ServletRequestBindingException("Failed to resolve entity view path variable name for handler method " + handlerMethod);
                }
                String pathVariableValue = (String)uriTemplateVars.get(entityViewIdPathVariableName);
                if (pathVariableValue == null) {
                    throw new ServletRequestBindingException("Missing URI template variable '" + pathVariableValue + "' for handler method " + handlerMethod);
                }
                this.entityViewIdValueHolder.value.set(pathVariableValue);
            }
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.entityViewIdValueHolder.value.remove();
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.entityViewIdValueHolder.value.remove();
    }

    private String resolveEntityViewIdPathVariableName(HandlerMethod handlerMethod) {
        String pathVariableName;
        EntityViewId entityViewId = null;
        MethodParameter entityViewIdMethodParameter = null;
        for (int i = 0; i < handlerMethod.getMethodParameters().length; ++i) {
            MethodParameter methodParameter = handlerMethod.getMethodParameters()[i];
            entityViewId = (EntityViewId)methodParameter.getParameterAnnotation(EntityViewId.class);
            if (entityViewId == null) continue;
            if (this.evm.getMetamodel().managedView(methodParameter.getParameterType()) == null) {
                LOG.warn("Handler argument " + methodParameter + " is annotated with @" + EntityViewId.class.getName() + " but its type [" + methodParameter.getNestedParameterType().getName() + "] is not an entity view.");
                break;
            }
            entityViewIdMethodParameter = handlerMethod.getMethodParameters()[i];
            break;
        }
        if (entityViewIdMethodParameter != null) {
            pathVariableName = entityViewId.name();
            if (pathVariableName.isEmpty() && (pathVariableName = entityViewIdMethodParameter.getParameterName()) == null) {
                throw new IllegalArgumentException("Entity view id path variable name for argument type [" + entityViewIdMethodParameter.getNestedParameterType().getName() + "] not available, and parameter name information not found in class file either.");
            }
        } else {
            pathVariableName = null;
        }
        return pathVariableName;
    }
}

