/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.criteria.BlazeAggregateFunctionExpression;
import com.blazebit.persistence.criteria.BlazeCollectionJoin;
import com.blazebit.persistence.criteria.BlazeCriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaDelete;
import com.blazebit.persistence.criteria.BlazeCriteriaQuery;
import com.blazebit.persistence.criteria.BlazeCriteriaUpdate;
import com.blazebit.persistence.criteria.BlazeExpression;
import com.blazebit.persistence.criteria.BlazeFunctionExpression;
import com.blazebit.persistence.criteria.BlazeJoin;
import com.blazebit.persistence.criteria.BlazeListJoin;
import com.blazebit.persistence.criteria.BlazeMapJoin;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeOrderedSetAggregateFunctionExpression;
import com.blazebit.persistence.criteria.BlazePath;
import com.blazebit.persistence.criteria.BlazeRoot;
import com.blazebit.persistence.criteria.BlazeSetJoin;
import com.blazebit.persistence.criteria.BlazeWindow;
import com.blazebit.persistence.criteria.BlazeWindowFunctionExpression;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaDeleteImpl;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaQueryImpl;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaUpdateImpl;
import com.blazebit.persistence.criteria.impl.BlazeWindowImpl;
import com.blazebit.persistence.criteria.impl.OrderImpl;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.BetweenPredicate;
import com.blazebit.persistence.criteria.impl.expression.BinaryArithmeticExpression;
import com.blazebit.persistence.criteria.impl.expression.BooleanExpressionPredicate;
import com.blazebit.persistence.criteria.impl.expression.BooleanLiteralPredicate;
import com.blazebit.persistence.criteria.impl.expression.ComparisonPredicate;
import com.blazebit.persistence.criteria.impl.expression.CompoundPredicate;
import com.blazebit.persistence.criteria.impl.expression.CompoundSelectionImpl;
import com.blazebit.persistence.criteria.impl.expression.ExistsPredicate;
import com.blazebit.persistence.criteria.impl.expression.GeneralCaseExpression;
import com.blazebit.persistence.criteria.impl.expression.InPredicate;
import com.blazebit.persistence.criteria.impl.expression.IsEmptyPredicate;
import com.blazebit.persistence.criteria.impl.expression.IsNullPredicate;
import com.blazebit.persistence.criteria.impl.expression.LikePredicate;
import com.blazebit.persistence.criteria.impl.expression.LiteralExpression;
import com.blazebit.persistence.criteria.impl.expression.MemberOfPredicate;
import com.blazebit.persistence.criteria.impl.expression.NotPredicate;
import com.blazebit.persistence.criteria.impl.expression.NullLiteralExpression;
import com.blazebit.persistence.criteria.impl.expression.ParameterExpressionImpl;
import com.blazebit.persistence.criteria.impl.expression.QuantifiableSubqueryExpression;
import com.blazebit.persistence.criteria.impl.expression.SimpleCaseExpression;
import com.blazebit.persistence.criteria.impl.expression.UnaryMinusExpression;
import com.blazebit.persistence.criteria.impl.expression.function.AggregationFunctionExpressionImpl;
import com.blazebit.persistence.criteria.impl.expression.function.CoalesceFunction;
import com.blazebit.persistence.criteria.impl.expression.function.ConcatFunction;
import com.blazebit.persistence.criteria.impl.expression.function.CurrentDateFunction;
import com.blazebit.persistence.criteria.impl.expression.function.CurrentTimeFunction;
import com.blazebit.persistence.criteria.impl.expression.function.CurrentTimestampFunction;
import com.blazebit.persistence.criteria.impl.expression.function.FunctionExpressionImpl;
import com.blazebit.persistence.criteria.impl.expression.function.LocateFunction;
import com.blazebit.persistence.criteria.impl.expression.function.NullifFunction;
import com.blazebit.persistence.criteria.impl.expression.function.OrderedSetAggregationFunction;
import com.blazebit.persistence.criteria.impl.expression.function.SizeFunction;
import com.blazebit.persistence.criteria.impl.expression.function.SubstringFunction;
import com.blazebit.persistence.criteria.impl.expression.function.TrimFunction;
import com.blazebit.persistence.criteria.impl.expression.function.WindowFunctionExpressionImpl;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.CollectionAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.ListAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.MapAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.PluralAttributePath;
import com.blazebit.persistence.criteria.impl.path.RootImpl;
import com.blazebit.persistence.criteria.impl.path.SetAttributeJoin;
import com.blazebit.persistence.criteria.impl.support.CriteriaBuilderSupport;
import com.blazebit.persistence.parser.EntityMetamodel;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CompoundSelection;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import jakarta.persistence.criteria.Subquery;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlazeCriteriaBuilderImpl
implements BlazeCriteriaBuilder,
CriteriaBuilderSupport,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityMetamodel metamodel;
    private final CriteriaBuilderFactory cbf;
    private final boolean negationWrapper;
    private final boolean valueAsParameter;

    public BlazeCriteriaBuilderImpl(CriteriaBuilderFactory cbf) {
        this.metamodel = (EntityMetamodel)cbf.getService(EntityMetamodel.class);
        this.cbf = cbf;
        String negationWrapper = cbf.getProperty("com.blazebit.persistence.criteria_negation_wrapper");
        this.negationWrapper = negationWrapper == null || negationWrapper.isEmpty() || Boolean.parseBoolean(negationWrapper);
        String valueAsParameter = cbf.getProperty("com.blazebit.persistence.criteria_value_as_parameter");
        this.valueAsParameter = valueAsParameter == null || valueAsParameter.isEmpty() || Boolean.parseBoolean(valueAsParameter);
    }

    public EntityMetamodel getEntityMetamodel() {
        return this.metamodel;
    }

    public CriteriaBuilderFactory getCriteriaBuilderFactory() {
        return this.cbf;
    }

    public <T extends AbstractPredicate> AbstractPredicate negate(T predicate) {
        if (this.negationWrapper) {
            return new NotPredicate(this, predicate);
        }
        return predicate.copyNegated();
    }

    public BlazeCriteriaQuery<Object> createQuery() {
        return new BlazeCriteriaQueryImpl<Object>(this, Object.class);
    }

    public <T> BlazeCriteriaQuery<T> createQuery(Class<T> resultClass) {
        return new BlazeCriteriaQueryImpl<T>(this, resultClass);
    }

    public BlazeCriteriaQuery<Tuple> createTupleQuery() {
        return new BlazeCriteriaQueryImpl<Tuple>(this, Tuple.class);
    }

    public <T> BlazeCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity) {
        return new BlazeCriteriaUpdateImpl<T>(this, targetEntity, null);
    }

    public <T> BlazeCriteriaUpdate<T> createCriteriaUpdate(Class<T> targetEntity, String alias) {
        return new BlazeCriteriaUpdateImpl<T>(this, targetEntity, alias);
    }

    public <T> BlazeCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity) {
        return new BlazeCriteriaDeleteImpl<T>(this, targetEntity, null);
    }

    public <T> BlazeCriteriaDelete<T> createCriteriaDelete(Class<T> targetEntity, String alias) {
        return new BlazeCriteriaDeleteImpl<T>(this, targetEntity, alias);
    }

    private List<Selection<?>> wrapSelectionItems(List<Selection<?>> selections) {
        ArrayList copy = null;
        for (int i = 0; i < selections.size(); ++i) {
            Selection<?> selection = selections.get(i);
            if (selection.isCompoundSelection()) {
                if (selection.getJavaType().isArray()) {
                    throw new IllegalArgumentException("Illegal array selection in multiselect selections");
                }
                if (Tuple.class.isAssignableFrom(selection.getJavaType())) {
                    throw new IllegalArgumentException("Illegal tuple selection in multiselect selections");
                }
            }
            Selection<?> copySelection = this.wrapSelection(selection);
            if (copy != null) {
                copy.add(copySelection);
                continue;
            }
            if (copySelection == selection) continue;
            copy = new ArrayList();
            for (int j = 0; j < i; ++j) {
                copy.add(selections.get(j));
            }
            copy.add(copySelection);
        }
        if (copy != null) {
            return copy;
        }
        return selections;
    }

    public <T> Selection<? extends T> wrapSelection(Selection<? extends T> selection) {
        if (selection instanceof Predicate) {
            return this.selectCase().when((Expression)((Predicate)selection), this.literal(true)).otherwise(this.literal(false));
        }
        return selection;
    }

    public <T> BlazeExpression<T> nullValue(Class<T> javaType) {
        if (this.valueAsParameter) {
            return new ParameterExpressionImpl<Object>(this, (Class<Object>)javaType, null);
        }
        return new NullLiteralExpression<T>(this, javaType);
    }

    public <T> BlazeExpression<T> value(T value) {
        this.checkValue(value);
        if (this.valueAsParameter) {
            return new ParameterExpressionImpl<T>(this, value);
        }
        return new LiteralExpression<T>(this, value);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.tuple(Arrays.asList(selections));
    }

    public CompoundSelection<Tuple> tuple(List<Selection<?>> selections) {
        return new CompoundSelectionImpl<Tuple>(this, Tuple.class, this.wrapSelectionItems(selections));
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.array(Arrays.asList(selections));
    }

    public CompoundSelection<Object[]> array(List<Selection<?>> selections) {
        return this.array(Object[].class, selections);
    }

    public <Y> CompoundSelection<Y> array(Class<Y> type, List<Selection<?>> selections) {
        return new CompoundSelectionImpl<Y>(this, type, this.wrapSelectionItems(selections));
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return this.construct(result, Arrays.asList(selections));
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, List<Selection<?>> selections) {
        return new CompoundSelectionImpl<Y>(this, result, this.wrapSelectionItems(selections));
    }

    public BlazeOrder asc(Expression<?> x) {
        return new OrderImpl(x, true, false);
    }

    public BlazeOrder desc(Expression<?> x) {
        return new OrderImpl(x, false, false);
    }

    public BlazeOrder asc(Expression<?> x, boolean nullsFirst) {
        return new OrderImpl(x, true, nullsFirst);
    }

    public BlazeOrder desc(Expression<?> x, boolean nullsFirst) {
        return new OrderImpl(x, false, nullsFirst);
    }

    public Predicate wrap(Expression<Boolean> expression) {
        if (expression instanceof Predicate) {
            return (Predicate)expression;
        }
        if (expression instanceof AbstractPath) {
            return this.equal((Expression<?>)expression, (Expression<?>)this.literal((T)Boolean.TRUE));
        }
        return new BooleanExpressionPredicate(this, false, expression);
    }

    public Predicate not(Expression<Boolean> expression) {
        return this.wrap(expression).not();
    }

    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND, x, y);
    }

    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR, x, y);
    }

    public Predicate and(Predicate ... restrictions) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND, (Expression<Boolean>[])restrictions);
    }

    public Predicate or(Predicate ... restrictions) {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR, (Expression<Boolean>[])restrictions);
    }

    public Predicate conjunction() {
        return new CompoundPredicate(this, Predicate.BooleanOperator.AND);
    }

    public Predicate disjunction() {
        return new CompoundPredicate(this, Predicate.BooleanOperator.OR);
    }

    public Predicate isTrue(Expression<Boolean> expression) {
        if (CompoundPredicate.class.isInstance(expression)) {
            CompoundPredicate predicate = (CompoundPredicate)expression;
            if (predicate.getExpressions().size() == 0) {
                return new BooleanLiteralPredicate(this, (Boolean)(predicate.getOperator() == Predicate.BooleanOperator.AND ? 1 : 0));
            }
            return predicate;
        }
        if (Predicate.class.isInstance(expression)) {
            return (Predicate)expression;
        }
        return this.equal((Expression<?>)expression, (Expression<?>)this.literal((T)Boolean.TRUE));
    }

    public Predicate isFalse(Expression<Boolean> expression) {
        if (CompoundPredicate.class.isInstance(expression)) {
            CompoundPredicate predicate = (CompoundPredicate)expression;
            if (predicate.getExpressions().size() == 0) {
                return new BooleanLiteralPredicate(this, (Boolean)(predicate.getOperator() == Predicate.BooleanOperator.OR ? 1 : 0));
            }
            return predicate.not();
        }
        if (Predicate.class.isInstance(expression)) {
            Predicate predicate = (Predicate)expression;
            return predicate.not();
        }
        return this.equal((Expression<?>)expression, (Expression<?>)this.literal((T)Boolean.FALSE));
    }

    public Predicate isNull(Expression<?> x) {
        return new IsNullPredicate(this, false, x);
    }

    public Predicate isNotNull(Expression<?> x) {
        return new IsNullPredicate(this, true, x);
    }

    public Predicate equal(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.EQUAL, x, y);
    }

    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.NOT_EQUAL, x, y);
    }

    public Predicate equal(Expression<?> x, Object y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.EQUAL, x, (Expression<?>)this.value(y));
    }

    public Predicate notEqual(Expression<?> x, Object y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.NOT_EQUAL, x, (Expression<?>)this.value(y));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, (Expression<?>)this.value(y));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, (Expression<?>)this.value(y));
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, (Expression<?>)this.value(y));
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, (Expression<?>)this.value(y));
    }

    public Predicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, y);
    }

    public Predicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, y);
    }

    public Predicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, y);
    }

    public Predicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, y);
    }

    public Predicate gt(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN, x, (Expression<?>)this.value(y));
    }

    public Predicate lt(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN, x, (Expression<?>)this.value(y));
    }

    public Predicate ge(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.GREATER_THAN_OR_EQUAL, x, (Expression<?>)this.value(y));
    }

    public Predicate le(Expression<? extends Number> x, Number y) {
        return new ComparisonPredicate(this, ComparisonPredicate.ComparisonOperator.LESS_THAN_OR_EQUAL, x, (Expression<?>)this.value(y));
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Y lowerBound, Y upperBound) {
        return new BetweenPredicate<Y>(this, false, expression, this.value(lowerBound), this.value(upperBound));
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> expression, Expression<? extends Y> lowerBound, Expression<? extends Y> upperBound) {
        return new BetweenPredicate<Y>(this, false, expression, lowerBound, upperBound);
    }

    public <T> CriteriaBuilder.In<T> in(Expression<? extends T> expression) {
        return new InPredicate<T>(this, expression);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern) {
        return new LikePredicate(this, false, matchExpression, pattern);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, false, matchExpression, pattern, escapeCharacter);
    }

    public Predicate like(Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        return new LikePredicate(this, false, matchExpression, pattern, (Expression<Character>)this.value(Character.valueOf(escapeCharacter)));
    }

    public Predicate like(Expression<String> matchExpression, String pattern) {
        return new LikePredicate(this, false, matchExpression, (Expression<String>)this.value(pattern));
    }

    public Predicate like(Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, false, matchExpression, (Expression<String>)this.value(pattern), escapeCharacter);
    }

    public Predicate like(Expression<String> matchExpression, String pattern, char escapeCharacter) {
        return new LikePredicate(this, false, matchExpression, (Expression<String>)this.value(pattern), (Expression<Character>)this.value(Character.valueOf(escapeCharacter)));
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern) {
        return new LikePredicate(this, true, matchExpression, pattern);
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, true, matchExpression, pattern, escapeCharacter);
    }

    public Predicate notLike(Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        return new LikePredicate(this, true, matchExpression, pattern, (Expression<Character>)this.value(Character.valueOf(escapeCharacter)));
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern) {
        return new LikePredicate(this, true, matchExpression, (Expression<String>)this.value(pattern));
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        return new LikePredicate(this, true, matchExpression, (Expression<String>)this.value(pattern), escapeCharacter);
    }

    public Predicate notLike(Expression<String> matchExpression, String pattern, char escapeCharacter) {
        return new LikePredicate(this, true, matchExpression, (Expression<String>)this.value(pattern), (Expression<Character>)this.value(Character.valueOf(escapeCharacter)));
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<Class<T>>(this, paramClass);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<String>(this, (Class<String>)paramClass, name);
    }

    public <T> AbstractExpression<T> literal(T value) {
        this.checkValue(value);
        return new LiteralExpression<T>(this, value);
    }

    public <T> AbstractExpression<T> nullLiteral(Class<T> resultClass) {
        return new NullLiteralExpression<T>(this, resultClass);
    }

    public <N extends Number> BlazeAggregateFunctionExpression<Double> avg(Expression<N> x) {
        return new AggregationFunctionExpressionImpl<Double>(this, Double.class, "AVG", false, (Expression<?>)x);
    }

    public <N extends Number> BlazeAggregateFunctionExpression<N> sum(Expression<N> x) {
        return new AggregationFunctionExpressionImpl(this, x.getJavaType(), "SUM", false, (Expression<?>)x);
    }

    public BlazeAggregateFunctionExpression<Long> sumAsLong(Expression<Integer> x) {
        return new AggregationFunctionExpressionImpl<Long>(this, Long.class, "SUM", false, (Expression<?>)x);
    }

    public BlazeAggregateFunctionExpression<Double> sumAsDouble(Expression<Float> x) {
        return new AggregationFunctionExpressionImpl<Double>(this, Double.class, "SUM", false, (Expression<?>)x);
    }

    public <N extends Number> BlazeAggregateFunctionExpression<N> max(Expression<N> x) {
        return new AggregationFunctionExpressionImpl(this, x.getJavaType(), "MAX", false, (Expression<?>)x);
    }

    public <N extends Number> BlazeAggregateFunctionExpression<N> min(Expression<N> x) {
        return new AggregationFunctionExpressionImpl(this, x.getJavaType(), "MIN", false, (Expression<?>)x);
    }

    public <X extends Comparable<? super X>> BlazeAggregateFunctionExpression<X> greatest(Expression<X> x) {
        return new AggregationFunctionExpressionImpl(this, x.getJavaType(), "MAX", false, (Expression<?>)x);
    }

    public <X extends Comparable<? super X>> BlazeAggregateFunctionExpression<X> least(Expression<X> x) {
        return new AggregationFunctionExpressionImpl(this, x.getJavaType(), "MIN", false, (Expression<?>)x);
    }

    public BlazeAggregateFunctionExpression<Long> count(Expression<?> x) {
        return new AggregationFunctionExpressionImpl<Long>(this, Long.class, "COUNT", false, x);
    }

    public BlazeAggregateFunctionExpression<Long> countDistinct(Expression<?> x) {
        return new AggregationFunctionExpressionImpl<Long>(this, Long.class, "COUNT", true, x);
    }

    public <T> BlazeFunctionExpression<T> function(String name, Class<T> returnType, Expression<?> ... arguments) {
        return new FunctionExpressionImpl<T>(this, returnType, name, arguments);
    }

    public <T> BlazeWindowFunctionExpression<T> windowFunction(String name, Class<T> type, Expression<?> ... args) {
        return new WindowFunctionExpressionImpl<T>(this, type, name, args);
    }

    public <T> BlazeWindowFunctionExpression<T> windowDistinctFunction(String name, Class<T> type, Expression<?> ... args) {
        return new AggregationFunctionExpressionImpl<T>(this, type, name, true, args);
    }

    public <T> BlazeAggregateFunctionExpression<T> aggregateFunction(String name, Class<T> type, Expression<?> ... args) {
        return new AggregationFunctionExpressionImpl<T>(this, type, name, false, args);
    }

    public <T> BlazeAggregateFunctionExpression<T> aggregateDistinctFunction(String name, Class<T> type, Expression<?> ... args) {
        return new AggregationFunctionExpressionImpl<T>(this, type, name, true, args);
    }

    public <T> BlazeOrderedSetAggregateFunctionExpression<T> orderedSetAggregateFunction(String name, Class<T> type, Expression<?> ... args) {
        return new OrderedSetAggregationFunction<T>(this, type, name, false, args);
    }

    public <T> BlazeOrderedSetAggregateFunctionExpression<T> orderedSetAggregateDistinctFunction(String name, Class<T> type, Expression<?> ... args) {
        return new OrderedSetAggregationFunction<T>(this, type, name, true, args);
    }

    public <N extends Number> Expression<N> abs(Expression<N> expression) {
        return new FunctionExpressionImpl(this, expression.getJavaType(), "ABS", expression);
    }

    public Expression<Double> sqrt(Expression<? extends Number> expression) {
        return new FunctionExpressionImpl<Double>(this, Double.class, "SQRT", expression);
    }

    public Expression<Date> currentDate() {
        return new CurrentDateFunction(this);
    }

    public Expression<Timestamp> currentTimestamp() {
        return new CurrentTimestampFunction(this);
    }

    public Expression<Time> currentTime() {
        return new CurrentTimeFunction(this);
    }

    public Expression<String> substring(Expression<String> value, Expression<Integer> start) {
        return new SubstringFunction(this, value, start);
    }

    public Expression<String> substring(Expression<String> value, int start) {
        return new SubstringFunction(this, value, (Expression<Integer>)this.value(start));
    }

    public Expression<String> substring(Expression<String> value, Expression<Integer> start, Expression<Integer> length) {
        return new SubstringFunction(this, value, start, length);
    }

    public Expression<String> substring(Expression<String> value, int start, int length) {
        return new SubstringFunction(this, value, (Expression<Integer>)this.value(start), (Expression<Integer>)this.value(length));
    }

    public Expression<String> trim(Expression<String> trimSource) {
        return new TrimFunction(this, trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, trimSource);
    }

    public Expression<String> trim(Expression<Character> trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimCharacter, trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, trimCharacter, trimSource);
    }

    public Expression<String> trim(char trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, (Expression<Character>)this.value(Character.valueOf(trimCharacter)), trimSource);
    }

    public Expression<String> trim(CriteriaBuilder.Trimspec trimspec, char trimCharacter, Expression<String> trimSource) {
        return new TrimFunction(this, trimspec, (Expression<Character>)this.value(Character.valueOf(trimCharacter)), trimSource);
    }

    public Expression<String> lower(Expression<String> value) {
        return new FunctionExpressionImpl<String>(this, String.class, "LOWER", value);
    }

    public Expression<String> upper(Expression<String> value) {
        return new FunctionExpressionImpl<String>(this, String.class, "UPPER", value);
    }

    public Expression<Integer> length(Expression<String> value) {
        return new FunctionExpressionImpl<Integer>(this, Integer.class, "LENGTH", value);
    }

    public Expression<Integer> locate(Expression<String> string, Expression<String> pattern) {
        return new LocateFunction(this, pattern, string);
    }

    public Expression<Integer> locate(Expression<String> string, Expression<String> pattern, Expression<Integer> start) {
        return new LocateFunction(this, pattern, string, start);
    }

    public Expression<Integer> locate(Expression<String> string, String pattern) {
        return new LocateFunction(this, (Expression<String>)this.value(pattern), string);
    }

    public Expression<Integer> locate(Expression<String> string, String pattern, int start) {
        return new LocateFunction(this, (Expression<String>)this.value(pattern), string, (Expression<Integer>)this.value(start));
    }

    public Expression<String> concat(Expression<String> string1, Expression<String> string2) {
        return new ConcatFunction(this, string1, string2);
    }

    public Expression<String> concat(Expression<String> string1, String string2) {
        return new ConcatFunction(this, string1, (Expression<String>)this.value(string2));
    }

    public Expression<String> concat(String string1, Expression<String> string2) {
        return new ConcatFunction(this, (Expression<String>)this.value(string1), string2);
    }

    public <N extends Number> Expression<N> neg(Expression<N> expression) {
        return new UnaryMinusExpression<N>(this, expression);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        this.checkExpression(expression1);
        this.checkExpression(expression2);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression1.getJavaType(), (Class<? extends Number>)expression2.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.ADD, expression1, expression2);
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        this.checkExpression(expression1);
        this.checkExpression(expression2);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression1.getJavaType(), (Class<? extends Number>)expression2.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.MULTIPLY, expression1, expression2);
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression1, Expression<? extends N> expression2) {
        this.checkExpression(expression1);
        this.checkExpression(expression2);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression1.getJavaType(), (Class<? extends Number>)expression2.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.SUBTRACT, expression1, expression2);
    }

    public <N extends Number> Expression<N> sum(Expression<? extends N> expression, N value) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression.getJavaType(), value.getClass());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.ADD, expression, this.value(value));
    }

    public <N extends Number> Expression<N> prod(Expression<? extends N> expression, N value) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression.getJavaType(), value.getClass());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.MULTIPLY, expression, this.value(value));
    }

    public <N extends Number> Expression<N> diff(Expression<? extends N> expression, N value) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression.getJavaType(), value.getClass());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.SUBTRACT, expression, this.value(value));
    }

    public <N extends Number> Expression<N> sum(N value, Expression<? extends N> expression) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType(value.getClass(), (Class<? extends Number>)expression.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.ADD, this.value(value), expression);
    }

    public <N extends Number> Expression<N> prod(N value, Expression<? extends N> expression) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType(value.getClass(), (Class<? extends Number>)expression.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.MULTIPLY, this.value(value), expression);
    }

    public <N extends Number> Expression<N> diff(N value, Expression<? extends N> expression) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType(value.getClass(), (Class<? extends Number>)expression.getJavaType());
        return new BinaryArithmeticExpression<N>(this, resultType, BinaryArithmeticExpression.Operation.SUBTRACT, this.value(value), expression);
    }

    public Expression<Number> quot(Expression<? extends Number> expression1, Expression<? extends Number> expression2) {
        this.checkExpression(expression1);
        this.checkExpression(expression2);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression1.getJavaType(), (Class<? extends Number>)expression2.getJavaType(), true);
        return new BinaryArithmeticExpression<Number>(this, resultType, BinaryArithmeticExpression.Operation.DIVIDE, expression1, expression2);
    }

    public Expression<Number> quot(Expression<? extends Number> expression, Number value) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType((Class<? extends Number>)expression.getJavaType(), value.getClass(), true);
        return new BinaryArithmeticExpression<Number>(this, resultType, BinaryArithmeticExpression.Operation.DIVIDE, (Expression<Number>)expression, (Expression<Number>)this.value(value));
    }

    public Expression<Number> quot(Number value, Expression<? extends Number> expression) {
        this.checkValue(value);
        this.checkExpression(expression);
        Class<Number> resultType = BinaryArithmeticExpression.determineResultType(value.getClass(), (Class<? extends Number>)expression.getJavaType(), true);
        return new BinaryArithmeticExpression<Number>(this, (Class<? extends Number>)resultType, BinaryArithmeticExpression.Operation.DIVIDE, (Expression<? extends Number>)this.value(value), expression);
    }

    public Expression<Integer> mod(Expression<Integer> expression1, Expression<Integer> expression2) {
        this.checkExpression(expression1);
        this.checkExpression(expression2);
        return new BinaryArithmeticExpression<Integer>(this, Integer.class, BinaryArithmeticExpression.Operation.MOD, expression1, expression2);
    }

    public Expression<Integer> mod(Expression<Integer> expression, Integer value) {
        this.checkValue(value);
        this.checkExpression(expression);
        return new BinaryArithmeticExpression<Integer>(this, Integer.class, BinaryArithmeticExpression.Operation.MOD, expression, (Expression<Integer>)this.value(value));
    }

    public Expression<Integer> mod(Integer value, Expression<Integer> expression) {
        this.checkValue(value);
        this.checkExpression(expression);
        return new BinaryArithmeticExpression<Integer>(this, Integer.class, BinaryArithmeticExpression.Operation.MOD, (Expression<Integer>)this.value(value), expression);
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null value not allowed!");
        }
    }

    private void checkExpression(Expression<?> expression) {
        if (expression == null) {
            throw new IllegalArgumentException("null expression not allowed!");
        }
    }

    public Expression<Long> toLong(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asLong();
    }

    public Expression<Integer> toInteger(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asInteger();
    }

    public Expression<Float> toFloat(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asFloat();
    }

    public Expression<Double> toDouble(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asDouble();
    }

    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asBigDecimal();
    }

    public Expression<BigInteger> toBigInteger(Expression<? extends Number> expression) {
        return ((AbstractExpression)expression).asBigInteger();
    }

    public Expression<String> toString(Expression<Character> characterExpression) {
        return ((AbstractExpression)characterExpression).asString();
    }

    public Predicate exists(Subquery<?> subquery) {
        return new ExistsPredicate(this, subquery);
    }

    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new QuantifiableSubqueryExpression<Y>(this, subquery.getJavaType(), subquery, QuantifiableSubqueryExpression.Quantor.ALL);
    }

    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new QuantifiableSubqueryExpression<Y>(this, subquery.getJavaType(), subquery, QuantifiableSubqueryExpression.Quantor.SOME);
    }

    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new QuantifiableSubqueryExpression<Y>(this, subquery.getJavaType(), subquery, QuantifiableSubqueryExpression.Quantor.ANY);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> exp1, Expression<? extends Y> exp2) {
        return this.coalesce((Class<Y>)null, exp1, (Y)exp2);
    }

    public <Y> Expression<Y> coalesce(Class<Y> type, Expression<? extends Y> exp1, Expression<? extends Y> exp2) {
        return new CoalesceFunction<Y>(this, type).value(exp1).value(exp2);
    }

    public <Y> Expression<Y> coalesce(Expression<? extends Y> exp1, Y value) {
        return this.coalesce((Class)null, exp1, this.value(value));
    }

    public <Y> Expression<Y> coalesce(Class<Y> type, Expression<? extends Y> exp1, Y value) {
        return new CoalesceFunction<Y>(this, type).value(exp1).value(value);
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce() {
        return this.coalesce(null);
    }

    public <T> CriteriaBuilder.Coalesce<T> coalesce(Class<T> type) {
        return new CoalesceFunction<T>(this, type);
    }

    public <Y> Expression<Y> nullif(Expression<Y> exp1, Expression<?> exp2) {
        return this.nullif(null, exp1, (Y)exp2);
    }

    public <Y> Expression<Y> nullif(Class<Y> type, Expression<Y> exp1, Expression<?> exp2) {
        return new NullifFunction<Y>(this, type, exp1, exp2);
    }

    public <Y> Expression<Y> nullif(Expression<Y> exp1, Y value) {
        return this.nullif(null, exp1, this.value(value));
    }

    public <Y> Expression<Y> nullif(Class<Y> type, Expression<Y> exp1, Y value) {
        return new NullifFunction<Y>(this, type, exp1, (Expression<?>)this.value(value));
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return this.selectCase(null, expression);
    }

    public <C, R> CriteriaBuilder.SimpleCase<C, R> selectCase(Class<R> type, Expression<? extends C> expression) {
        return new SimpleCaseExpression<C, R>(this, type, expression);
    }

    public <R> CriteriaBuilder.Case<R> selectCase() {
        return this.selectCase((Class)null);
    }

    public <R> CriteriaBuilder.Case<R> selectCase(Class<R> type) {
        return new GeneralCaseExpression<R>(this, type);
    }

    public <C extends Collection<?>> Expression<Integer> size(C c) {
        int size = c == null ? 0 : c.size();
        return new LiteralExpression<Integer>(this, Integer.class, size);
    }

    public <C extends Map<?, ?>> Expression<Integer> mapSize(C c) {
        int size = c == null ? 0 : c.size();
        return new LiteralExpression<Integer>(this, Integer.class, size);
    }

    public <C extends Collection<?>> Expression<Integer> size(Expression<C> exp) {
        if (LiteralExpression.class.isInstance(exp)) {
            return this.size((Collection)((LiteralExpression)exp).getLiteral());
        }
        if (PluralAttributePath.class.isInstance(exp)) {
            return new SizeFunction(this, (PluralAttributePath)exp);
        }
        throw this.illegalCollection(exp);
    }

    public <C extends Map<?, ?>> Expression<Integer> mapSize(Expression<C> exp) {
        if (LiteralExpression.class.isInstance(exp)) {
            return this.mapSize((Map)((LiteralExpression)exp).getLiteral());
        }
        if (PluralAttributePath.class.isInstance(exp)) {
            return new SizeFunction(this, (PluralAttributePath)exp);
        }
        throw this.illegalCollection(exp);
    }

    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        return new LiteralExpression<Collection<V>>(this, map.values());
    }

    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        return new LiteralExpression<Set<K>>(this, map.keySet());
    }

    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new IsEmptyPredicate(this, false, (PluralAttributePath)collectionExpression);
    }

    public <C extends Map<?, ?>> Predicate isMapEmpty(Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new IsEmptyPredicate(this, false, (PluralAttributePath)collectionExpression);
    }

    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new IsEmptyPredicate(this, true, (PluralAttributePath)collectionExpression);
    }

    public <C extends Map<?, ?>> Predicate isMapNotEmpty(Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new IsEmptyPredicate(this, true, (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isMember(E e, Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new MemberOfPredicate(this, false, this.value(e), (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E e, Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new MemberOfPredicate(this, true, this.value(e), (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elementExpression, Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new MemberOfPredicate(this, false, elementExpression, (PluralAttributePath)collectionExpression);
    }

    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> elementExpression, Expression<C> collectionExpression) {
        if (!(collectionExpression instanceof PluralAttributePath)) {
            throw this.illegalCollection(collectionExpression);
        }
        return new MemberOfPredicate(this, true, elementExpression, (PluralAttributePath)collectionExpression);
    }

    private RuntimeException illegalCollection(Expression<?> expression) {
        return new IllegalArgumentException("Illegal expression type! Expected plural expression but got: " + expression.getClass().getName());
    }

    public <X, T, V extends T> BlazeJoin<X, V> treat(Join<X, T> join, Class<V> type) {
        return ((AbstractJoin)join).treatJoin(type);
    }

    public <X, T, E extends T> BlazeCollectionJoin<X, E> treat(CollectionJoin<X, T> join, Class<E> type) {
        return ((CollectionAttributeJoin)join).treatJoin((Class)type);
    }

    public <X, T, E extends T> BlazeSetJoin<X, E> treat(SetJoin<X, T> join, Class<E> type) {
        return ((SetAttributeJoin)join).treatJoin((Class)type);
    }

    public <X, T, E extends T> BlazeListJoin<X, E> treat(ListJoin<X, T> join, Class<E> type) {
        return ((ListAttributeJoin)join).treatJoin((Class)type);
    }

    public <X, K, T, V extends T> BlazeMapJoin<X, K, V> treat(MapJoin<X, K, T> join, Class<V> type) {
        return ((MapAttributeJoin)join).treatJoin((Class)type);
    }

    public <X, T extends X> BlazePath<T> treat(Path<X> path, Class<T> type) {
        if (path instanceof AbstractJoin) {
            return ((AbstractJoin)path).treatJoin(type);
        }
        return ((AbstractPath)path).treatAs(type);
    }

    public <X, T extends X> BlazeRoot<T> treat(Root<X> root, Class<T> type) {
        return ((RootImpl)root).treatAs((Class)type);
    }

    public <X, T, V extends T> BlazeJoin<X, V> treat(BlazeJoin<X, T> join, Class<V> type) {
        return this.treat((Join<X, T>)join, type);
    }

    public <X, T, E extends T> BlazeCollectionJoin<X, E> treat(BlazeCollectionJoin<X, T> join, Class<E> type) {
        return this.treat((CollectionJoin<X, T>)join, type);
    }

    public <X, T, E extends T> BlazeSetJoin<X, E> treat(BlazeSetJoin<X, T> join, Class<E> type) {
        return this.treat((SetJoin<X, T>)join, type);
    }

    public <X, T, E extends T> BlazeListJoin<X, E> treat(BlazeListJoin<X, T> join, Class<E> type) {
        return this.treat((ListJoin<X, T>)join, type);
    }

    public <X, K, T, V extends T> BlazeMapJoin<X, K, V> treat(BlazeMapJoin<X, K, T> join, Class<V> type) {
        return this.treat((MapJoin<X, K, T>)join, type);
    }

    public <X, T extends X> BlazePath<T> treat(BlazePath<X> path, Class<T> type) {
        return this.treat((Path<X>)path, type);
    }

    public <X, T extends X> BlazeRoot<T> treat(BlazeRoot<X> root, Class<T> type) {
        return this.treat((Root<X>)root, type);
    }

    public BlazeWindow window() {
        return new BlazeWindowImpl();
    }

    public BlazeWindowFunctionExpression<Integer> rowNumber() {
        return new WindowFunctionExpressionImpl<Integer>(this, Integer.class, "ROW_NUMBER", new Expression[0]);
    }

    public BlazeWindowFunctionExpression<Integer> rank(Expression<?> expression) {
        return new WindowFunctionExpressionImpl<Integer>(this, Integer.class, "RANK", expression);
    }

    public BlazeWindowFunctionExpression<Integer> denseRank(Expression<?> expression) {
        return new WindowFunctionExpressionImpl<Integer>(this, Integer.class, "DENSE_RANK", expression);
    }

    public BlazeWindowFunctionExpression<Double> percentRank(Expression<?> expression) {
        return new WindowFunctionExpressionImpl<Double>(this, Double.class, "PERCENT_RANK", expression);
    }

    public BlazeWindowFunctionExpression<Double> cumeDist(Expression<?> expression) {
        return new WindowFunctionExpressionImpl<Double>(this, Double.class, "CUME_DIST", expression);
    }

    public BlazeWindowFunctionExpression<Integer> ntile(Expression<?> expression) {
        return new WindowFunctionExpressionImpl<Integer>(this, Integer.class, "NTILE", expression);
    }

    public <X> BlazeWindowFunctionExpression<X> lead(Expression<X> expression) {
        return new WindowFunctionExpressionImpl(this, expression.getJavaType(), "LEAD", expression);
    }

    public <X> BlazeWindowFunctionExpression<X> lag(Expression<X> expression) {
        return new WindowFunctionExpressionImpl(this, expression.getJavaType(), "LAG", expression);
    }

    public <X> BlazeWindowFunctionExpression<X> firstValue(Expression<X> expression) {
        return new WindowFunctionExpressionImpl(this, expression.getJavaType(), "FIRST_VALUE", expression);
    }

    public <X> BlazeWindowFunctionExpression<X> lastValue(Expression<X> expression) {
        return new WindowFunctionExpressionImpl(this, expression.getJavaType(), "LAST_VALUE", expression);
    }

    public <X> BlazeWindowFunctionExpression<X> nthValue(Expression<X> expression, Expression<Integer> index) {
        return new WindowFunctionExpressionImpl(this, expression.getJavaType(), "NTH_VALUE", expression, index);
    }

    public <X> BlazeOrderedSetAggregateFunctionExpression<X> percentileContWithinGroup(Expression<Double> fraction, Expression<X> group, boolean ascending, boolean nullsFirst) {
        return new OrderedSetAggregationFunction(this, group.getJavaType(), "PERCENTILE_CONT", false, (Expression<?>)fraction).withinGroup(new Order[]{ascending ? this.asc(group, nullsFirst) : this.desc(group, nullsFirst)});
    }

    public <X> BlazeOrderedSetAggregateFunctionExpression<X> percentileDiscWithinGroup(Expression<Double> fraction, Expression<X> group, boolean ascending, boolean nullsFirst) {
        return new OrderedSetAggregationFunction(this, group.getJavaType(), "PERCENTILE_DISC", false, (Expression<?>)fraction).withinGroup(new Order[]{ascending ? this.asc(group, nullsFirst) : this.desc(group, nullsFirst)});
    }

    public <X> BlazeOrderedSetAggregateFunctionExpression<X> modeWithinGroup(Expression<X> group) {
        return new OrderedSetAggregationFunction(this, group.getJavaType(), "MODE", false, new Expression[0]).withinGroup(new Order[]{this.asc(group)});
    }

    public BlazeOrderedSetAggregateFunctionExpression<String> listagg(Expression<String> expression, Expression<String> separator) {
        return new OrderedSetAggregationFunction<String>(this, String.class, "LISTAGG", false, expression, separator);
    }

    public BlazeOrderedSetAggregateFunctionExpression<String> listaggDistinct(Expression<String> expression, Expression<String> separator) {
        return new OrderedSetAggregationFunction<String>(this, String.class, "LISTAGG", true, expression, separator);
    }
}

