/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.BlazeExpression;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.expression.AbstractSelection;
import com.blazebit.persistence.criteria.impl.expression.InPredicate;
import com.blazebit.persistence.criteria.impl.expression.LiteralExpression;
import com.blazebit.persistence.criteria.impl.expression.function.FunctionExpressionImpl;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractExpression<T>
extends AbstractSelection<T>
implements BlazeExpression<T> {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, String> CAST_SUFFIXES;

    public AbstractExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        super(criteriaBuilder, javaType);
    }

    private static String castSuffix(Class<?> t) {
        String suffix = CAST_SUFFIXES.get(t);
        if (suffix == null) {
            return t.getSimpleName().toUpperCase(Locale.ROOT);
        }
        return suffix;
    }

    public <X> BlazeExpression<X> as(Class<X> type) {
        return type.equals(this.getJavaType()) ? this : new FunctionExpressionImpl<X>(this.criteriaBuilder, type, "CAST_" + AbstractExpression.castSuffix(type), new Expression[]{this});
    }

    public Predicate isNull() {
        return this.criteriaBuilder.isNull((Expression<?>)this);
    }

    public Predicate isNotNull() {
        return this.criteriaBuilder.isNotNull((Expression<?>)this);
    }

    public Predicate in(Object ... values) {
        ArrayList valueList = new ArrayList(values.length);
        for (Object value : values) {
            if (value instanceof Expression) {
                valueList.add((Expression)value);
                continue;
            }
            if (value == null) {
                valueList.add(this.criteriaBuilder.nullValue(this.getJavaType()));
                continue;
            }
            valueList.add(this.criteriaBuilder.value(value));
        }
        return new InPredicate(this.criteriaBuilder, this, valueList);
    }

    public Predicate in(Expression<?> ... values) {
        ArrayList valueList = new ArrayList(values.length);
        for (Expression<?> value : values) {
            valueList.add(value);
        }
        return new InPredicate(this.criteriaBuilder, this, valueList);
    }

    public Predicate in(Collection<?> values) {
        ArrayList valueList = new ArrayList(values.size());
        for (Object value : values) {
            if (value instanceof Expression) {
                valueList.add((Expression)value);
                continue;
            }
            if (value == null) {
                valueList.add(this.criteriaBuilder.nullValue(this.getJavaType()));
                continue;
            }
            valueList.add(this.criteriaBuilder.value(value));
        }
        return new InPredicate(this.criteriaBuilder, this, valueList);
    }

    public Predicate in(Expression<Collection<?>> values) {
        if (values instanceof LiteralExpression) {
            Collection collection = (Collection)((LiteralExpression)values).getLiteral();
            ArrayList valueList = new ArrayList(collection.size());
            for (Object value : collection) {
                if (value instanceof Expression) {
                    valueList.add((Expression)value);
                    continue;
                }
                if (value == null) {
                    valueList.add(this.criteriaBuilder.nullLiteral(this.getJavaType()));
                    continue;
                }
                valueList.add(this.criteriaBuilder.literal(value));
            }
            return new InPredicate(this.criteriaBuilder, this, valueList);
        }
        ArrayList valueList = new ArrayList(1);
        valueList.add(values);
        return new InPredicate(this.criteriaBuilder, this, valueList);
    }

    public BlazeExpression<Long> asLong() {
        this.setJavaType(Long.class);
        return this;
    }

    public BlazeExpression<Integer> asInteger() {
        this.setJavaType(Integer.class);
        return this;
    }

    public BlazeExpression<Float> asFloat() {
        this.setJavaType(Float.class);
        return this;
    }

    public BlazeExpression<Double> asDouble() {
        this.setJavaType(Double.class);
        return this;
    }

    public BlazeExpression<BigDecimal> asBigDecimal() {
        this.setJavaType(BigDecimal.class);
        return this;
    }

    public BlazeExpression<BigInteger> asBigInteger() {
        this.setJavaType(BigInteger.class);
        return this;
    }

    public BlazeExpression<String> asString() {
        this.setJavaType(String.class);
        return this;
    }

    static {
        HashMap<Class<Object>, String> s = new HashMap<Class<Object>, String>();
        s.put(Boolean.class, "BOOLEAN");
        s.put(Boolean.TYPE, "BOOLEAN");
        s.put(Byte.class, "BYTE");
        s.put(Byte.TYPE, "BYTE");
        s.put(Short.class, "SHORT");
        s.put(Short.TYPE, "SHORT");
        s.put(Integer.class, "INTEGER");
        s.put(Integer.TYPE, "INTEGER");
        s.put(Long.class, "LONG");
        s.put(Long.TYPE, "LONG");
        s.put(Float.class, "FLOAT");
        s.put(Float.TYPE, "FLOAT");
        s.put(Double.class, "DOUBLE");
        s.put(Double.TYPE, "DOUBLE");
        s.put(Character.class, "CHARACTER");
        s.put(Character.TYPE, "CHARACTER");
        s.put(String.class, "STRING");
        s.put(BigInteger.class, "BIGINTEGER");
        s.put(BigDecimal.class, "BIGDECIMAL");
        s.put(Time.class, "TIME");
        s.put(Date.class, "DATE");
        s.put(Timestamp.class, "TIMESTAMP");
        s.put(java.util.Date.class, "TIMESTAMP");
        s.put(Calendar.class, "CALENDAR");
        CAST_SUFFIXES = Collections.unmodifiableMap(s);
    }
}

