/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;

public class BetweenPredicate<Y>
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final Expression<? extends Y> expression;
    private final Expression<? extends Y> lowerBound;
    private final Expression<? extends Y> upperBound;

    public BetweenPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<? extends Y> expression, Y lowerBound, Y upperBound) {
        this(criteriaBuilder, negated, expression, (Expression<? extends Y>)criteriaBuilder.literal(lowerBound), (Expression<? extends Y>)criteriaBuilder.literal(upperBound));
    }

    public BetweenPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<? extends Y> expression, Expression<? extends Y> lowerBound, Expression<? extends Y> upperBound) {
        super(criteriaBuilder, negated);
        this.expression = expression;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new BetweenPredicate<Y>(this.criteriaBuilder, !this.isNegated(), this.expression, this.lowerBound, this.upperBound);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.expression);
        visitor.visit((Selection<?>)this.lowerBound);
        visitor.visit((Selection<?>)this.upperBound);
    }

    @Override
    public void render(RenderContext context) {
        String operator = this.isNegated() ? " NOT BETWEEN " : " BETWEEN ";
        context.apply((Selection<?>)this.expression);
        context.getBuffer().append(operator);
        context.apply((Selection<?>)this.lowerBound);
        context.getBuffer().append(" AND ");
        context.apply((Selection<?>)this.upperBound);
    }
}

