/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;

public class BooleanExpressionPredicate
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final Expression<Boolean> expression;

    public BooleanExpressionPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<Boolean> expression) {
        super(criteriaBuilder, negated);
        this.expression = expression;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new BooleanExpressionPredicate(this.criteriaBuilder, !this.isNegated(), this.expression);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.expression);
    }

    @Override
    public void render(RenderContext context) {
        if (this.isNegated()) {
            context.getBuffer().append("NOT ");
        }
        context.apply((Selection<?>)this.expression);
    }
}

