/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;

public class LiteralExpression<T>
extends AbstractExpression<T> {
    private static final long serialVersionUID = 1L;
    private Object literal;

    public LiteralExpression(BlazeCriteriaBuilderImpl criteriaBuilder, T literal) {
        this(criteriaBuilder, LiteralExpression.determineClass(literal), literal);
    }

    public LiteralExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> type, T literal) {
        super(criteriaBuilder, type);
        this.literal = literal;
    }

    private static Class<?> determineClass(Object literal) {
        return literal == null ? null : literal.getClass();
    }

    public T getLiteral() {
        return (T)this.literal;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        TypeConverter converter = TypeUtils.getConverter(this.literal.getClass(), this.criteriaBuilder.getEntityMetamodel().getEnumTypes().keySet());
        if (converter != null) {
            converter.appendTo(this.literal, buffer);
        } else {
            String paramName = context.registerLiteralParameterBinding(this.getLiteral(), this.getJavaType());
            buffer.append(':').append(paramName);
        }
    }

    @Override
    protected void setJavaType(Class targetType) {
        super.setJavaType(targetType);
        TypeConverter converter = this.getConverter();
        if (converter == null) {
            converter = TypeUtils.getConverter((Class)targetType, this.criteriaBuilder.getEntityMetamodel().getEnumTypes().keySet());
            this.setConverter(converter);
        }
        if (converter != null) {
            this.literal = converter.convert(this.literal);
        }
    }
}

