/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.function.AbstractFunctionExpression;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Selection;

public class TrimFunction
extends AbstractFunctionExpression<String> {
    public static final String NAME = "TRIM";
    public static final CriteriaBuilder.Trimspec DEFAULT_TRIMSPEC = CriteriaBuilder.Trimspec.BOTH;
    private static final long serialVersionUID = 1L;
    private final CriteriaBuilder.Trimspec trimspec;
    private final Expression<Character> trimCharacter;
    private final Expression<String> trimSource;

    public TrimFunction(BlazeCriteriaBuilderImpl criteriaBuilder, CriteriaBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> trimSource) {
        super(criteriaBuilder, String.class, NAME);
        this.trimspec = trimspec;
        this.trimCharacter = trimCharacter;
        this.trimSource = trimSource;
    }

    public TrimFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<String> trimSource) {
        this(criteriaBuilder, DEFAULT_TRIMSPEC, null, trimSource);
    }

    public TrimFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<Character> trimCharacter, Expression<String> trimSource) {
        this(criteriaBuilder, DEFAULT_TRIMSPEC, trimCharacter, trimSource);
    }

    public TrimFunction(BlazeCriteriaBuilderImpl criteriaBuilder, CriteriaBuilder.Trimspec trimspec, Expression<String> trimSource) {
        this(criteriaBuilder, trimspec, null, trimSource);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        if (this.trimCharacter != null) {
            visitor.visit((Selection<?>)this.trimCharacter);
        }
        visitor.visit((Selection<?>)this.trimSource);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("TRIM(");
        buffer.append(this.trimspec.name());
        if (this.trimCharacter != null) {
            buffer.append(' ');
            context.apply((Selection<?>)this.trimCharacter);
        }
        buffer.append(" FROM ");
        context.apply((Selection<?>)this.trimSource);
        buffer.append(')');
    }
}

