/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeRoot;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import java.io.Serializable;

public class RootImpl<X>
extends AbstractFrom<X, X>
implements BlazeRoot<X>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final EntityType<X> entityType;
    private final boolean joinsAllowed;

    private RootImpl(BlazeCriteriaBuilderImpl criteriaBuilder, EntityType<X> entityType, boolean joinsAllowed) {
        super(criteriaBuilder, entityType.getJavaType());
        this.entityType = entityType;
        this.joinsAllowed = joinsAllowed;
    }

    public RootImpl(BlazeCriteriaBuilderImpl criteriaBuilder, EntityType<X> entityType, String alias, boolean joinsAllowed) {
        super(criteriaBuilder, entityType.getJavaType());
        this.entityType = entityType;
        this.setAlias(alias);
        this.joinsAllowed = joinsAllowed;
    }

    public EntityType<X> getEntityType() {
        return this.entityType;
    }

    public EntityType<X> getModel() {
        return this.getEntityType();
    }

    @Override
    protected AbstractFrom<X, X> createCorrelationDelegate() {
        return new RootImpl<X>(this.criteriaBuilder, this.getEntityType(), this.getAlias(), true);
    }

    public RootImpl<X> correlateTo(SubqueryExpression<?> subquery) {
        return (RootImpl)super.correlateTo(subquery);
    }

    @Override
    protected boolean isJoinAllowed() {
        return this.joinsAllowed;
    }

    @Override
    protected void checkJoinAllowed() {
        if (!this.joinsAllowed) {
            throw new IllegalArgumentException("Update and delete criteria queries cannot have joins");
        }
        super.checkJoinAllowed();
    }

    @Override
    protected void checkFetchAllowed() {
        if (!this.joinsAllowed) {
            throw new IllegalArgumentException("Update and delete criteria queries cannot have join fetches");
        }
        super.checkFetchAllowed();
    }

    @Override
    public <T extends X> RootImpl<T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedRoot<T>(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    @Override
    public String getPathExpression() {
        return this.getAlias();
    }

    @Override
    public void renderPathExpression(RenderContext context) {
        context.getBuffer().append(this.resolveAlias(context));
    }

    @Override
    public void render(RenderContext context) {
        context.getBuffer().append(this.resolveAlias(context));
    }

    public static class TreatedRoot<X>
    extends RootImpl<X>
    implements TreatedPath<X> {
        private static final long serialVersionUID = 1L;
        private final RootImpl<? super X> treatedRoot;
        private final EntityType<X> treatType;

        public TreatedRoot(BlazeCriteriaBuilderImpl criteriaBuilder, RootImpl<? super X> treatedRoot, EntityType<X> treatType) {
            super(criteriaBuilder, treatType, treatedRoot.isJoinAllowed());
            this.treatedRoot = treatedRoot;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<X> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<X> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super X> getTreatedPath() {
            return this.treatedRoot;
        }

        @Override
        public String getAlias() {
            return this.treatedRoot.getAlias();
        }

        @Override
        protected AbstractFrom<X, X> createCorrelationDelegate() {
            return new TreatedRoot<X>(this.criteriaBuilder, this.treatedRoot, this.treatType);
        }

        @Override
        public TreatedRoot<X> correlateTo(SubqueryExpression<?> subquery) {
            return (TreatedRoot)super.correlateTo((SubqueryExpression)subquery);
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

