/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import java.util.Map;
import javax.persistence.criteria.Expression;

public class EntryFunction<K, V>
extends AbstractExpression<Map.Entry<K, V>>
implements Expression<Map.Entry<K, V>> {
    private static final long serialVersionUID = 1L;
    private final AbstractPath<?> origin;

    public EntryFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Class<Map.Entry<K, V>> javaType, AbstractPath<?> origin) {
        super(criteriaBuilder, javaType);
        this.origin = origin instanceof TreatedPath ? ((TreatedPath)((Object)origin)).getTreatedPath() : origin;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
    }

    @Override
    public void render(RenderContext context) {
        if (context.getClauseType() != RenderContext.ClauseType.SELECT) {
            throw new IllegalStateException("Entry is only allowed in select clause");
        }
        StringBuilder buffer = context.getBuffer();
        buffer.append("ENTRY(");
        this.origin.renderPathExpression(context);
        buffer.append(')');
    }
}

