/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.CommonQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaUpdate;
import com.blazebit.persistence.criteria.BlazePath;
import com.blazebit.persistence.criteria.impl.AbstractModificationCriteriaQuery;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ImplicitParameterBinding;
import com.blazebit.persistence.criteria.impl.InternalQuery;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.RenderContextImpl;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.expression.LiteralExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.SingularAttributePath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.SingularAttribute;

public class BlazeCriteriaUpdateImpl<T>
extends AbstractModificationCriteriaQuery<T>
implements BlazeCriteriaUpdate<T> {
    private final List<Assignment> assignments = new ArrayList<Assignment>();

    public BlazeCriteriaUpdateImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> targetEntity, String alias) {
        super(criteriaBuilder);
        this.from(targetEntity, alias);
    }

    public <Y, X extends Y> BlazeCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, X value) {
        BlazePath attributePath = this.getRoot().get(attribute);
        return this.internalSet((Path<?>)attributePath, (Expression<?>)this.valueExpression((Path<?>)attributePath, value));
    }

    public <Y> BlazeCriteriaUpdate<T> set(SingularAttribute<? super T, Y> attribute, Expression<? extends Y> value) {
        BlazePath attributePath = this.getRoot().get(attribute);
        return this.internalSet((Path<?>)attributePath, value);
    }

    public <Y, X extends Y> BlazeCriteriaUpdate<T> set(Path<Y> attribute, X value) {
        return this.internalSet(attribute, (Expression<?>)this.valueExpression(attribute, value));
    }

    public <Y> BlazeCriteriaUpdate<T> set(Path<Y> attribute, Expression<? extends Y> value) {
        return this.internalSet(attribute, value);
    }

    public BlazeCriteriaUpdate<T> set(String attributeName, Object value) {
        BlazePath attributePath = this.getRoot().get(attributeName);
        return this.internalSet((Path<?>)attributePath, (Expression<?>)this.valueExpression((Path<?>)attributePath, value));
    }

    private AbstractExpression<?> valueExpression(Path<?> attributePath, Object value) {
        if (value == null) {
            return this.criteriaBuilder.nullLiteral(attributePath.getJavaType());
        }
        if (value instanceof AbstractExpression) {
            return (AbstractExpression)value;
        }
        return this.criteriaBuilder.literal(value);
    }

    private BlazeCriteriaUpdate<T> internalSet(Path<?> attribute, Expression<?> value) {
        if (!(attribute instanceof AbstractPath)) {
            throw new IllegalArgumentException("Illegal custom attribute path: " + attribute.getClass().getName());
        }
        if (!(attribute instanceof SingularAttributePath)) {
            throw new IllegalArgumentException("Only singular attributes can be updated");
        }
        if (value == null) {
            throw new IllegalArgumentException("Illegal null expression passed. Check your set-call, you probably wanted to pass a literal null");
        }
        if (!(value instanceof AbstractExpression)) {
            throw new IllegalArgumentException("Illegal custom value expression: " + value.getClass().getName());
        }
        this.assignments.add(new Assignment((SingularAttributePath)attribute, (AbstractExpression)value));
        return this;
    }

    public BlazeCriteriaUpdate<T> where(Expression<Boolean> restriction) {
        this.setRestriction(restriction);
        return this;
    }

    public BlazeCriteriaUpdate<T> where(Predicate ... restrictions) {
        this.setRestriction(restrictions);
        return this;
    }

    public UpdateCriteriaBuilder<T> createCriteriaBuilder(EntityManager entityManager) {
        RenderContextImpl context = new RenderContextImpl();
        UpdateCriteriaBuilder updateCriteriaBuilder = this.criteriaBuilder.getCriteriaBuilderFactory().update(entityManager, this.getRoot().getJavaType(), this.getRoot().getAlias());
        context.setClauseType(RenderContext.ClauseType.SET);
        for (Assignment assignment : this.assignments) {
            String attribute = assignment.attributePath.getAttribute().getName();
            if (assignment.valueExpression instanceof LiteralExpression) {
                Object value = ((LiteralExpression)assignment.valueExpression).getLiteral();
                updateCriteriaBuilder.set(attribute, value);
                continue;
            }
            context.getBuffer().setLength(0);
            assignment.valueExpression.render(context);
            String valueExpression = context.takeBuffer();
            Map<String, InternalQuery<?>> aliasToSubqueries = context.takeAliasToSubqueryMap();
            if (aliasToSubqueries.isEmpty()) {
                updateCriteriaBuilder.setExpression(attribute, valueExpression);
                continue;
            }
            MultipleSubqueryInitiator initiator = updateCriteriaBuilder.setSubqueries(attribute, valueExpression);
            for (Map.Entry<String, InternalQuery<?>> subqueryEntry : aliasToSubqueries.entrySet()) {
                context.pushSubqueryInitiator(initiator.with(subqueryEntry.getKey()));
                subqueryEntry.getValue().renderSubquery(context);
                context.popSubqueryInitiator();
            }
            initiator.end();
        }
        this.renderWhere((WhereBuilder<?>)updateCriteriaBuilder, context);
        for (ImplicitParameterBinding implicitParameterBinding : context.getImplicitParameterBindings()) {
            implicitParameterBinding.bind((CommonQueryBuilder<?>)updateCriteriaBuilder);
        }
        for (Map.Entry entry : context.getExplicitParameterMapping().entrySet()) {
            updateCriteriaBuilder.registerCriteriaParameter((String)entry.getValue(), (ParameterExpression)entry.getKey());
        }
        return updateCriteriaBuilder;
    }

    private static final class Assignment {
        private final SingularAttributePath<?> attributePath;
        private final AbstractExpression<?> valueExpression;

        public Assignment(SingularAttributePath<?> attributePath, AbstractExpression<?> valueExpression) {
            this.attributePath = attributePath;
            this.valueExpression = valueExpression;
        }
    }
}

