/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.criteria.BlazeExpression;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeWindow;
import com.blazebit.persistence.criteria.BlazeWindowFrameEndType;
import com.blazebit.persistence.criteria.BlazeWindowFrameExclusion;
import com.blazebit.persistence.criteria.BlazeWindowFrameKind;
import com.blazebit.persistence.criteria.BlazeWindowFrameMode;
import com.blazebit.persistence.criteria.BlazeWindowFrameStartType;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;

public class BlazeWindowImpl
implements BlazeWindow {
    private List<BlazeOrder> orderList = Collections.emptyList();
    private List<BlazeExpression<?>> partitionList = Collections.emptyList();
    private BlazeWindowFrameMode frameMode = BlazeWindowFrameMode.ROWS;
    private WindowFramePositionType frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
    private BlazeExpression<?> frameStartExpression;
    private WindowFramePositionType frameEndType = WindowFramePositionType.CURRENT_ROW;
    private BlazeExpression<?> frameEndExpression;
    private WindowFrameExclusionType frameExclusion = WindowFrameExclusionType.EXCLUDE_NO_OTHERS;

    public List<BlazeOrder> getOrderList() {
        return this.orderList;
    }

    public BlazeWindow orderBy(Order ... orders) {
        this.orderList = orders == null || orders.length == 0 ? Collections.EMPTY_LIST : Arrays.asList(orders);
        return this;
    }

    public BlazeWindow orderBy(List<Order> orderList) {
        this.orderList = orderList;
        return this;
    }

    public List<BlazeExpression<?>> getPartitionList() {
        return this.partitionList;
    }

    public BlazeWindow partitionBy(Expression<?> ... groupings) {
        this.partitionList = groupings == null || groupings.length == 0 ? Collections.EMPTY_LIST : Arrays.asList(groupings);
        return this;
    }

    public BlazeWindow partitionBy(List<Expression<?>> groupings) {
        this.partitionList = groupings;
        return this;
    }

    public BlazeWindow rows(BlazeWindowFrameStartType start) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow rows(Expression<Integer> start, BlazeWindowFrameKind startKind) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start, startKind);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow rowsBetween(BlazeWindowFrameStartType start, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow rowsBetween(BlazeWindowFrameStartType start, Expression<Integer> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindow rowsBetween(Expression<Integer> start, BlazeWindowFrameKind startKind, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start, startKind);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow rowsBetween(Expression<Integer> start, BlazeWindowFrameKind startKind, Expression<Integer> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.ROWS;
        this.setStart(start, startKind);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindow range(BlazeWindowFrameStartType start) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow range(Expression<?> start, BlazeWindowFrameKind startKind) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start, startKind);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow rangeBetween(BlazeWindowFrameStartType start, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow rangeBetween(BlazeWindowFrameStartType start, Expression<?> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindow rangeBetween(Expression<?> start, BlazeWindowFrameKind startKind, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start, startKind);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow rangeBetween(Expression<?> start, BlazeWindowFrameKind startKind, Expression<?> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.RANGE;
        this.setStart(start, startKind);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindow groups(BlazeWindowFrameStartType start) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow groups(Expression<Integer> start, BlazeWindowFrameKind startKind) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start, startKind);
        this.setEnd(BlazeWindowFrameEndType.CURRENT_ROW);
        return this;
    }

    public BlazeWindow groupsBetween(BlazeWindowFrameStartType start, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow groupsBetween(BlazeWindowFrameStartType start, Expression<Integer> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindow groupsBetween(Expression<Integer> start, BlazeWindowFrameKind startKind, BlazeWindowFrameEndType end) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start, startKind);
        this.setEnd(end);
        return this;
    }

    public BlazeWindow groupsBetween(Expression<Integer> start, BlazeWindowFrameKind startKind, Expression<Integer> end, BlazeWindowFrameKind endKind) {
        this.frameMode = BlazeWindowFrameMode.GROUPS;
        this.setStart(start, startKind);
        this.setEnd(end, endKind);
        return this;
    }

    public BlazeWindowFrameMode getFrameMode() {
        return this.frameMode;
    }

    public BlazeExpression<?> getFrameStart() {
        return this.frameStartExpression;
    }

    public BlazeWindowFrameKind getFrameStartKind() {
        return this.mapFrameKind(this.frameStartType);
    }

    public BlazeWindowFrameStartType getFrameStartType() {
        switch (this.frameStartType) {
            case CURRENT_ROW: {
                return BlazeWindowFrameStartType.CURRENT_ROW;
            }
            case BOUNDED_PRECEDING: 
            case BOUNDED_FOLLOWING: 
            case UNBOUNDED_FOLLOWING: {
                return null;
            }
            case UNBOUNDED_PRECEDING: {
                return BlazeWindowFrameStartType.UNBOUNDED_PRECEDING;
            }
        }
        throw new IllegalArgumentException("Unknown frame type: " + this.frameStartType);
    }

    public BlazeExpression<?> getFrameEnd() {
        return this.frameEndExpression;
    }

    public BlazeWindowFrameKind getFrameEndKind() {
        return this.mapFrameKind(this.frameEndType);
    }

    public BlazeWindowFrameEndType getFrameEndType() {
        switch (this.frameEndType) {
            case CURRENT_ROW: {
                return BlazeWindowFrameEndType.CURRENT_ROW;
            }
            case BOUNDED_PRECEDING: 
            case BOUNDED_FOLLOWING: 
            case UNBOUNDED_PRECEDING: {
                return null;
            }
            case UNBOUNDED_FOLLOWING: {
                return BlazeWindowFrameEndType.UNBOUNDED_FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unknown frame type: " + this.frameEndType);
    }

    public BlazeWindowFrameExclusion getFrameExclusion() {
        switch (this.frameExclusion) {
            case EXCLUDE_TIES: {
                return BlazeWindowFrameExclusion.TIES;
            }
            case EXCLUDE_CURRENT_ROW: {
                return BlazeWindowFrameExclusion.CURRENT_ROW;
            }
            case EXCLUDE_GROUP: {
                return BlazeWindowFrameExclusion.GROUP;
            }
            case EXCLUDE_NO_OTHERS: {
                return BlazeWindowFrameExclusion.NO_OTHERS;
            }
        }
        throw new IllegalArgumentException("Unknown frame exclusion: " + this.frameExclusion);
    }

    public BlazeWindow exclude(BlazeWindowFrameExclusion exclusion) {
        this.frameExclusion = this.mapExclusionType(exclusion);
        return this;
    }

    private void setStart(BlazeWindowFrameStartType start) {
        switch (start) {
            case CURRENT_ROW: {
                this.frameStartType = WindowFramePositionType.CURRENT_ROW;
                break;
            }
            case UNBOUNDED_PRECEDING: {
                this.frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frame start type: " + start);
            }
        }
        this.frameStartExpression = null;
    }

    private void setStart(Expression<?> start, BlazeWindowFrameKind startKind) {
        switch (startKind) {
            case FOLLOWING: {
                this.frameStartType = WindowFramePositionType.BOUNDED_FOLLOWING;
                break;
            }
            case PRECEDING: {
                this.frameStartType = WindowFramePositionType.BOUNDED_PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frame kind: " + startKind);
            }
        }
        if (start == null) {
            throw new IllegalArgumentException("Start expression can't be null");
        }
        this.frameStartExpression = (BlazeExpression)start;
    }

    private void setEnd(BlazeWindowFrameEndType end) {
        switch (end) {
            case CURRENT_ROW: {
                this.frameEndType = WindowFramePositionType.CURRENT_ROW;
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                this.frameEndType = WindowFramePositionType.UNBOUNDED_FOLLOWING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frame end type: " + end);
            }
        }
        this.frameEndExpression = null;
    }

    private void setEnd(Expression<?> end, BlazeWindowFrameKind endKind) {
        switch (endKind) {
            case FOLLOWING: {
                this.frameEndType = WindowFramePositionType.BOUNDED_FOLLOWING;
                break;
            }
            case PRECEDING: {
                this.frameEndType = WindowFramePositionType.BOUNDED_PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frame kind: " + endKind);
            }
        }
        if (end == null) {
            throw new IllegalArgumentException("End expression can't be null");
        }
        this.frameEndExpression = (BlazeExpression)end;
    }

    private BlazeWindowFrameKind mapFrameKind(WindowFramePositionType framePositionType) {
        switch (framePositionType) {
            case CURRENT_ROW: 
            case UNBOUNDED_FOLLOWING: 
            case UNBOUNDED_PRECEDING: {
                return null;
            }
            case BOUNDED_PRECEDING: {
                return BlazeWindowFrameKind.PRECEDING;
            }
            case BOUNDED_FOLLOWING: {
                return BlazeWindowFrameKind.FOLLOWING;
            }
        }
        throw new IllegalArgumentException("Unknown frame position: " + framePositionType);
    }

    private WindowFrameExclusionType mapExclusionType(BlazeWindowFrameExclusion exclusion) {
        switch (exclusion) {
            case TIES: {
                return WindowFrameExclusionType.EXCLUDE_TIES;
            }
            case CURRENT_ROW: {
                return WindowFrameExclusionType.EXCLUDE_CURRENT_ROW;
            }
            case GROUP: {
                return WindowFrameExclusionType.EXCLUDE_GROUP;
            }
            case NO_OTHERS: {
                return WindowFrameExclusionType.EXCLUDE_NO_OTHERS;
            }
        }
        throw new IllegalArgumentException("Unknown frame exclusion: " + exclusion);
    }
}

