/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.CommonQueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.criteria.impl.ImplicitParameterBinding;
import com.blazebit.persistence.criteria.impl.InternalQuery;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Selection;

public class RenderContextImpl
implements RenderContext {
    private final Map<ParameterExpression<?>, String> explicitParameterMapping = new HashMap();
    private final List<ImplicitParameterBinding> implicitParameterBindings = new ArrayList<ImplicitParameterBinding>();
    private final StringBuilder buffer;
    private final List<SubqueryInitiator<?>> subqueryInitiatorStack;
    private RenderContext.ClauseType clauseType;
    private int aliasCount = 0;
    private int explicitParameterCount = 0;
    private int subqueryAliasCount = 0;
    private Map<String, InternalQuery<?>> aliasToSubqueries = new HashMap();
    private Map<Object, String> objectAliases = new IdentityHashMap<Object, String>();

    public RenderContextImpl() {
        this.buffer = new StringBuilder();
        this.subqueryInitiatorStack = new ArrayList();
    }

    @Override
    public StringBuilder getBuffer() {
        return this.buffer;
    }

    public String takeBuffer() {
        String s = this.buffer.toString();
        this.buffer.setLength(0);
        return s;
    }

    @Override
    public SubqueryInitiator<?> getSubqueryInitiator() {
        return this.subqueryInitiatorStack.get(this.subqueryInitiatorStack.size() - 1);
    }

    public void pushSubqueryInitiator(SubqueryInitiator<?> subqueryInitiator) {
        this.subqueryInitiatorStack.add(subqueryInitiator);
    }

    public void popSubqueryInitiator() {
        this.subqueryInitiatorStack.remove(this.subqueryInitiatorStack.size() - 1);
    }

    @Override
    public RenderContext.ClauseType getClauseType() {
        return this.clauseType;
    }

    public void setClauseType(RenderContext.ClauseType clauseType) {
        this.clauseType = clauseType;
    }

    @Override
    public void apply(Selection<?> selection) {
        ((AbstractSelection)selection).render(this);
    }

    @Override
    public String resolveAlias(Object aliasedObject, Class<?> entityClass) {
        return this.resolveAlias(aliasedObject, entityClass.getSimpleName());
    }

    @Override
    public String resolveAlias(Object aliasedObject, String name) {
        String alias = this.objectAliases.get(aliasedObject);
        if (alias != null) {
            return alias;
        }
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex != -1) {
            name = name.substring(dotIndex + 1);
        }
        alias = "generated" + name + "_" + this.aliasCount++;
        this.objectAliases.put(aliasedObject, alias);
        return alias;
    }

    @Override
    public String generateSubqueryAlias(InternalQuery<?> subquery) {
        String subqueryAlias = "generatedSubquery_" + this.subqueryAliasCount++;
        this.aliasToSubqueries.put(subqueryAlias, subquery);
        return subqueryAlias;
    }

    public Map<String, InternalQuery<?>> takeAliasToSubqueryMap() {
        if (this.subqueryAliasCount == 0) {
            return Collections.emptyMap();
        }
        Map<String, InternalQuery<?>> map = this.aliasToSubqueries;
        this.aliasToSubqueries = new HashMap();
        this.subqueryAliasCount = 0;
        return map;
    }

    private String generateParameterName() {
        return "generated_param_" + this.explicitParameterCount++;
    }

    @Override
    public String registerExplicitParameter(ParameterExpression<?> criteriaQueryParameter) {
        String jpaqlParameterName;
        if (this.explicitParameterMapping.containsKey(criteriaQueryParameter)) {
            jpaqlParameterName = this.explicitParameterMapping.get(criteriaQueryParameter);
        } else {
            if (criteriaQueryParameter.getName() == null || criteriaQueryParameter.getName().isEmpty()) {
                if (criteriaQueryParameter.getPosition() != null) {
                    throw new IllegalArgumentException("Positional parameters are not supported in criteria queries!");
                }
                jpaqlParameterName = this.generateParameterName();
            } else {
                jpaqlParameterName = criteriaQueryParameter.getName();
            }
            this.explicitParameterMapping.put(criteriaQueryParameter, jpaqlParameterName);
        }
        return jpaqlParameterName;
    }

    @Override
    public String registerLiteralParameterBinding(final Object literal, Class javaType) {
        final String parameterName = this.generateParameterName();
        ImplicitParameterBinding binding = new ImplicitParameterBinding(){

            @Override
            public void bind(CommonQueryBuilder<?> builder) {
                builder.setParameter(parameterName, literal);
            }
        };
        this.implicitParameterBindings.add(binding);
        return parameterName;
    }

    public Map<ParameterExpression<?>, String> getExplicitParameterMapping() {
        return this.explicitParameterMapping;
    }

    public List<ImplicitParameterBinding> getImplicitParameterBindings() {
        return this.implicitParameterBindings;
    }
}

