/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class BinaryArithmeticExpression<N extends Number>
extends AbstractExpression<N> {
    private static final long serialVersionUID = 1L;
    private final Operation operator;
    private final Expression<? extends N> rightHandSide;
    private final Expression<? extends N> leftHandSide;

    public BinaryArithmeticExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<N> resultType, Operation operator, Expression<? extends N> leftHandSide, Expression<? extends N> rightHandSide) {
        super(criteriaBuilder, resultType);
        this.operator = operator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type) {
        return BinaryArithmeticExpression.determineResultType(argument1Type, argument2Type, false);
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> argument1Type, Class<? extends Number> argument2Type, boolean isQuotientOperation) {
        if (isQuotientOperation) {
            return Number.class;
        }
        return BinaryArithmeticExpression.determineResultType(new Class[]{argument1Type, argument2Type});
    }

    public static Class<? extends Number> determineResultType(Class<? extends Number> ... types) {
        Class<Number> result = Number.class;
        for (Class<? extends Number> type : types) {
            if (Double.class.equals(type)) {
                result = Double.class;
                continue;
            }
            if (Float.class.equals(type)) {
                result = Float.class;
                continue;
            }
            if (BigDecimal.class.equals(type)) {
                result = BigDecimal.class;
                continue;
            }
            if (BigInteger.class.equals(type)) {
                result = BigInteger.class;
                continue;
            }
            if (Long.class.equals(type)) {
                result = Long.class;
                continue;
            }
            if (!BinaryArithmeticExpression.isIntegralType(type)) continue;
            result = Integer.class;
        }
        return result;
    }

    private static boolean isIntegralType(Class<? extends Number> type) {
        return Integer.class.equals(type) || Short.class.equals(type);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.leftHandSide);
        visitor.visit((Selection<?>)this.rightHandSide);
    }

    @Override
    public void render(RenderContext context) {
        this.operator.render(context, this.leftHandSide, this.rightHandSide);
    }

    public static enum Operation {
        ADD{

            @Override
            public void render(RenderContext context, Expression<?> leftHandSide, Expression<?> rightHandSide) {
                Operation.simple(context, leftHandSide, '+', rightHandSide);
            }
        }
        ,
        SUBTRACT{

            @Override
            public void render(RenderContext context, Expression<?> leftHandSide, Expression<?> rightHandSide) {
                Operation.simple(context, leftHandSide, '-', rightHandSide);
            }
        }
        ,
        MULTIPLY{

            @Override
            public void render(RenderContext context, Expression<?> leftHandSide, Expression<?> rightHandSide) {
                Operation.simple(context, leftHandSide, '*', rightHandSide);
            }
        }
        ,
        DIVIDE{

            @Override
            public void render(RenderContext context, Expression<?> leftHandSide, Expression<?> rightHandSide) {
                Operation.simple(context, leftHandSide, '/', rightHandSide);
            }
        }
        ,
        MOD{

            @Override
            public void render(RenderContext context, Expression<?> leftHandSide, Expression<?> rightHandSide) {
                context.getBuffer().append("MOD(");
                context.apply((Selection<?>)leftHandSide);
                context.getBuffer().append(',');
                context.apply((Selection<?>)rightHandSide);
                context.getBuffer().append(')');
            }
        };


        public abstract void render(RenderContext var1, Expression<?> var2, Expression<?> var3);

        private static void simple(RenderContext context, Expression<?> leftHandSide, char operator, Expression<?> rightHandSide) {
            context.getBuffer().append('(');
            context.apply((Selection<?>)leftHandSide);
            context.getBuffer().append(operator);
            context.apply((Selection<?>)rightHandSide);
            context.getBuffer().append(')');
        }
    }
}

