/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;

public class BooleanLiteralPredicate
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final Boolean value;

    public BooleanLiteralPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Boolean value) {
        super(criteriaBuilder, false);
        this.value = value;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new BooleanLiteralPredicate(this.criteriaBuilder, (Boolean)(this.value == false ? 1 : 0));
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
    }

    @Override
    public void render(RenderContext context) {
        if (this.value ^ this.isNegated()) {
            context.getBuffer().append("1=1");
        } else {
            context.getBuffer().append("1=0");
        }
    }
}

