/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;

public class CompoundPredicate
extends AbstractPredicate {
    private static final long serialVersionUID = 1L;
    private final Predicate.BooleanOperator operator;
    private final List<Expression<Boolean>> expressions;

    public CompoundPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator) {
        super(criteriaBuilder, false);
        this.operator = operator;
        this.expressions = new ArrayList<Expression<Boolean>>();
    }

    @SafeVarargs
    public CompoundPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, Expression<Boolean> ... expressions) {
        this(criteriaBuilder, operator);
        Collections.addAll(this.expressions, expressions);
    }

    private CompoundPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Predicate.BooleanOperator operator, List<Expression<Boolean>> expressions) {
        super(criteriaBuilder, false);
        this.operator = operator;
        this.expressions = expressions;
    }

    public Predicate.BooleanOperator getOperator() {
        return this.operator;
    }

    public List<Expression<Boolean>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        for (Expression<Boolean> expression : this.expressions) {
            visitor.visit((Selection<?>)expression);
        }
    }

    @Override
    public void render(RenderContext context) {
        List<Expression<Boolean>> exprs = this.expressions;
        int size = exprs.size();
        switch (size) {
            case 0: {
                if (this.operator == Predicate.BooleanOperator.AND ^ this.isNegated()) {
                    context.getBuffer().append("1=1");
                    break;
                }
                context.getBuffer().append("1=0");
                break;
            }
            case 1: {
                context.apply((Selection)exprs.get(0));
                break;
            }
            default: {
                String operatorString = this.operator == Predicate.BooleanOperator.AND ? " AND " : " OR ";
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        context.getBuffer().append(operatorString);
                    }
                    context.getBuffer().append('(');
                    context.apply((Selection)exprs.get(i));
                    context.getBuffer().append(')');
                }
            }
        }
    }

    @Override
    public AbstractPredicate copyNegated() {
        Predicate.BooleanOperator operator = this.getNegatedOperator();
        ArrayList<Expression<Boolean>> list = new ArrayList<Expression<Boolean>>(this.expressions.size());
        for (Expression<Boolean> expr : this.expressions) {
            if (!(expr instanceof Predicate)) continue;
            list.add((Expression<Boolean>)((Predicate)expr).not());
        }
        return new CompoundPredicate(this.criteriaBuilder, operator, list);
    }

    private Predicate.BooleanOperator getNegatedOperator() {
        if (this.operator == Predicate.BooleanOperator.AND) {
            return Predicate.BooleanOperator.OR;
        }
        return Predicate.BooleanOperator.AND;
    }
}

