/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class GeneralCaseExpression<R>
extends AbstractExpression<R>
implements CriteriaBuilder.Case<R> {
    private static final long serialVersionUID = 1L;
    private Class<R> javaType;
    private Expression<? extends R> otherwiseResult;
    private final List<WhenClause> whenClauses = new ArrayList<WhenClause>();

    public GeneralCaseExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<R> javaType) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
    }

    public CriteriaBuilder.Case<R> when(Expression<Boolean> condition, R result) {
        return this.when(condition, (Expression<? extends R>)this.criteriaBuilder.value(result));
    }

    public CriteriaBuilder.Case<R> when(Expression<Boolean> condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(condition, result);
        this.whenClauses.add(whenClause);
        this.adjustJavaType(result);
        return this;
    }

    private void adjustJavaType(Expression<? extends R> exp) {
        if (this.javaType == null) {
            this.javaType = exp.getJavaType();
        }
    }

    public Expression<R> otherwise(R result) {
        return this.otherwise((Expression<? extends R>)this.criteriaBuilder.value(result));
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = result;
        this.adjustJavaType(result);
        return this;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        for (WhenClause whenClause : this.whenClauses) {
            visitor.visit((Selection<?>)whenClause.getCondition());
            visitor.visit((Selection<?>)whenClause.getResult());
        }
        visitor.visit((Selection<?>)this.otherwiseResult);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("CASE");
        for (WhenClause whenClause : this.whenClauses) {
            buffer.append(" WHEN ");
            context.apply((Selection<?>)whenClause.getCondition());
            buffer.append(" THEN ");
            context.apply((Selection<?>)whenClause.getResult());
        }
        buffer.append(" ELSE ");
        context.apply((Selection<?>)this.otherwiseResult);
        buffer.append(" END");
    }

    public class WhenClause {
        private final Expression<Boolean> condition;
        private final Expression<? extends R> result;

        public WhenClause(Expression<Boolean> condition, Expression<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }

        public Expression<Boolean> getCondition() {
            return this.condition;
        }

        public Expression<? extends R> getResult() {
            return this.result;
        }
    }
}

