/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class LikePredicate
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final Expression<String> matchExpression;
    private final Expression<String> pattern;
    private final Expression<Character> escapeCharacter;

    public LikePredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<String> matchExpression, Expression<String> pattern) {
        this(criteriaBuilder, negated, matchExpression, pattern, null);
    }

    public LikePredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        super(criteriaBuilder, negated);
        this.matchExpression = matchExpression;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new LikePredicate(this.criteriaBuilder, !this.isNegated(), this.matchExpression, this.pattern, this.escapeCharacter);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        if (this.escapeCharacter != null) {
            visitor.visit((Selection<?>)this.escapeCharacter);
        }
        visitor.visit((Selection<?>)this.matchExpression);
        visitor.visit((Selection<?>)this.pattern);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        context.apply((Selection<?>)this.matchExpression);
        if (this.isNegated()) {
            buffer.append(" NOT");
        }
        buffer.append(" LIKE ");
        context.apply((Selection<?>)this.pattern);
        Expression<Character> escapeExpr = this.escapeCharacter;
        if (escapeExpr != null) {
            buffer.append(" ESCAPE ");
            context.apply((Selection<?>)escapeExpr);
        }
    }
}

