/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import javax.persistence.Parameter;
import javax.persistence.criteria.ParameterExpression;

public class ParameterExpressionImpl<T>
extends AbstractExpression<T>
implements ParameterExpression<T> {
    private static final long serialVersionUID = 1L;
    private static final Object NULL_VALUE = new Object();
    private final String name;
    private final T value;

    public ParameterExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType) {
        this(criteriaBuilder, (Class<String>)javaType, (String)null);
    }

    public ParameterExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType, String name) {
        super(criteriaBuilder, javaType);
        this.name = name;
        this.value = null;
    }

    public ParameterExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, T value) {
        this(criteriaBuilder, value.getClass(), value);
    }

    public ParameterExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> javaType, T value) {
        super(criteriaBuilder, javaType);
        this.name = null;
        this.value = value == null ? NULL_VALUE : value;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPosition() {
        return null;
    }

    public Class<T> getParameterType() {
        return this.getJavaType();
    }

    public T getValue() {
        return this.value;
    }

    public T getRealValue() {
        return this.value == NULL_VALUE ? null : (T)this.value;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.add(this);
    }

    @Override
    public void render(RenderContext context) {
        String paramName = this.value == null ? context.registerExplicitParameter(this) : (this.value == NULL_VALUE ? context.registerLiteralParameterBinding(null, this.getJavaType()) : context.registerLiteralParameterBinding(this.value, this.getJavaType()));
        context.getBuffer().append(':').append(paramName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)o;
        if (this.name == null) {
            return false;
        }
        return this.name.equals(that.getName());
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result;
        return result;
    }
}

