/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.function.AbstractFunctionExpression;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class LocateFunction
extends AbstractFunctionExpression<Integer> {
    public static final String NAME = "LOCATE";
    private static final long serialVersionUID = 1L;
    private final Expression<String> pattern;
    private final Expression<String> string;
    private final Expression<Integer> start;

    public LocateFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<String> pattern, Expression<String> string, Expression<Integer> start) {
        super(criteriaBuilder, Integer.class, NAME);
        this.pattern = pattern;
        this.string = string;
        this.start = start;
    }

    public LocateFunction(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<String> pattern, Expression<String> string) {
        this(criteriaBuilder, pattern, string, null);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.pattern);
        visitor.visit((Selection<?>)this.start);
        visitor.visit((Selection<?>)this.string);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("LOCATE(");
        context.apply((Selection<?>)this.pattern);
        buffer.append(',');
        context.apply((Selection<?>)this.string);
        if (this.start != null) {
            buffer.append(',');
            context.apply((Selection<?>)this.start);
        }
        buffer.append(')');
    }
}

