/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression.function;

import com.blazebit.persistence.criteria.BlazeExpression;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeWindow;
import com.blazebit.persistence.criteria.BlazeWindowFrameEndType;
import com.blazebit.persistence.criteria.BlazeWindowFrameExclusion;
import com.blazebit.persistence.criteria.BlazeWindowFrameKind;
import com.blazebit.persistence.criteria.BlazeWindowFrameMode;
import com.blazebit.persistence.criteria.BlazeWindowFrameStartType;
import com.blazebit.persistence.criteria.BlazeWindowFunctionExpression;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import com.blazebit.persistence.criteria.impl.expression.AbstractSelection;
import com.blazebit.persistence.criteria.impl.expression.function.FunctionExpressionImpl;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class WindowFunctionExpressionImpl<X>
extends FunctionExpressionImpl<X>
implements BlazeWindowFunctionExpression<X> {
    private static final long serialVersionUID = 1L;
    private BlazeWindow window;

    public WindowFunctionExpressionImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, String functionName, Expression<?> ... argumentExpressions) {
        super(criteriaBuilder, javaType, functionName, argumentExpressions);
    }

    public BlazeWindow getWindow() {
        return this.window;
    }

    public BlazeWindowFunctionExpression<X> window(BlazeWindow window) {
        this.window = window;
        return this;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        super.visitParameters(visitor);
        if (this.window != null) {
            for (BlazeOrder blazeOrder : this.window.getOrderList()) {
                ((AbstractSelection)blazeOrder.getExpression()).visitParameters(visitor);
            }
            for (BlazeExpression blazeExpression : this.window.getPartitionList()) {
                ((AbstractSelection)blazeExpression).visitParameters(visitor);
            }
            if (this.window.getFrameStart() != null) {
                ((AbstractSelection)this.window.getFrameStart()).visitParameters(visitor);
            }
            if (this.window.getFrameEnd() != null) {
                ((AbstractSelection)this.window.getFrameEnd()).visitParameters(visitor);
            }
        }
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        List<Expression<?>> args = this.getArgumentExpressions();
        buffer.append(this.getFunctionName()).append('(');
        for (int i = 0; i < args.size(); ++i) {
            if (i != 0) {
                buffer.append(',');
            }
            context.apply((Selection)args.get(i));
        }
        buffer.append(')');
        this.renderWindow(context);
    }

    protected void renderWindow(RenderContext context) {
        if (this.window != null) {
            boolean hasFrame;
            List partitionList = this.window.getPartitionList();
            List orderList = this.window.getOrderList();
            BlazeWindowFrameMode frameMode = this.window.getFrameMode();
            BlazeWindowFrameStartType frameStartType = this.window.getFrameStartType();
            BlazeWindowFrameEndType frameEndType = this.window.getFrameEndType();
            BlazeWindowFrameExclusion frameExclusion = this.window.getFrameExclusion();
            boolean hasPartition = !partitionList.isEmpty();
            boolean hasOrder = !orderList.isEmpty();
            boolean hasFrameEnd = frameEndType != BlazeWindowFrameEndType.CURRENT_ROW;
            boolean bl = hasFrame = frameMode != BlazeWindowFrameMode.ROWS || frameStartType != BlazeWindowFrameStartType.UNBOUNDED_PRECEDING || hasFrameEnd || frameExclusion != BlazeWindowFrameExclusion.NO_OTHERS;
            if (hasPartition || hasOrder || hasFrame) {
                StringBuilder buffer = context.getBuffer();
                buffer.append(" OVER (");
                boolean needsSpace = false;
                if (hasPartition) {
                    buffer.append("PARTITION BY ");
                    for (BlazeExpression blazeExpression : partitionList) {
                        ((AbstractExpression)blazeExpression).render(context);
                        buffer.append(", ");
                    }
                    buffer.setLength(buffer.length() - 2);
                    needsSpace = true;
                }
                if (hasOrder) {
                    if (needsSpace) {
                        buffer.append(' ');
                    }
                    buffer.append("ORDER BY ");
                    for (BlazeOrder blazeOrder : orderList) {
                        ((AbstractExpression)blazeOrder.getExpression()).render(context);
                        if (blazeOrder.isAscending()) {
                            buffer.append(" ASC");
                        } else {
                            buffer.append(" DESC");
                        }
                        if (blazeOrder.isNullsFirst()) {
                            buffer.append(" NULLS FIRST");
                        } else {
                            buffer.append(" NULLS LAST");
                        }
                        buffer.append(", ");
                    }
                    buffer.setLength(buffer.length() - 2);
                    needsSpace = true;
                }
                if (hasFrame) {
                    if (needsSpace) {
                        buffer.append(' ');
                    }
                    buffer.append(frameMode.name());
                    if (hasFrameEnd) {
                        buffer.append(" BETWEEN ");
                    }
                    if (frameStartType == null) {
                        ((AbstractExpression)this.window.getFrameStart()).render(context);
                        if (this.window.getFrameStartKind() == BlazeWindowFrameKind.PRECEDING) {
                            buffer.append(" PRECEDING");
                        } else {
                            buffer.append(" FOLLOWING");
                        }
                    } else {
                        switch (frameStartType) {
                            case CURRENT_ROW: {
                                buffer.append("CURRENT ROW");
                                break;
                            }
                            case UNBOUNDED_PRECEDING: {
                                buffer.append("UNBOUNDED PRECEDING");
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unsupported frame type: " + frameStartType);
                            }
                        }
                    }
                    if (hasFrameEnd) {
                        buffer.append(" AND ");
                        if (frameEndType == null) {
                            ((AbstractExpression)this.window.getFrameEnd()).render(context);
                            if (this.window.getFrameEndKind() == BlazeWindowFrameKind.PRECEDING) {
                                buffer.append(" PRECEDING");
                            } else {
                                buffer.append(" FOLLOWING");
                            }
                        } else if (frameEndType == BlazeWindowFrameEndType.UNBOUNDED_FOLLOWING) {
                            buffer.append("UNBOUNDED FOLLOWING");
                        }
                    }
                    switch (frameExclusion) {
                        case CURRENT_ROW: {
                            buffer.append(" EXCLUDE CURRENT ROW");
                            break;
                        }
                        case GROUP: {
                            buffer.append(" EXCLUDE GROUP");
                            break;
                        }
                        case TIES: {
                            buffer.append(" EXCLUDE TIES");
                            break;
                        }
                        case NO_OTHERS: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported frame exclusion: " + frameExclusion);
                        }
                    }
                }
                buffer.append(')');
            }
        }
    }
}

