/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeCollectionJoin;
import com.blazebit.persistence.criteria.BlazeFetchParent;
import com.blazebit.persistence.criteria.BlazeFrom;
import com.blazebit.persistence.criteria.BlazeJoin;
import com.blazebit.persistence.criteria.BlazeListJoin;
import com.blazebit.persistence.criteria.BlazeMapJoin;
import com.blazebit.persistence.criteria.BlazeSetJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.FromSelection;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractJoin;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.AbstractPluralAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.CollectionAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.EntityJoin;
import com.blazebit.persistence.criteria.impl.path.ListAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.MapAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.SetAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.SingularAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractFrom<Z, X>
extends AbstractPath<X>
implements BlazeFrom<Z, X> {
    public static final JoinType DEFAULT_JOIN_TYPE = JoinType.INNER;
    private static final long serialVersionUID = 1L;
    private AbstractFrom<Z, X> correlationParent;
    private JoinScope<X> joinScope = new BasicJoinScope();
    private Set<AbstractJoin<X, ?>> joins;
    private Set<AbstractJoin<X, ?>> fetches;
    private Map<EntityType<? extends X>, TreatedPath<? extends X>> treatedPaths;

    public AbstractFrom(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType) {
        this(criteriaBuilder, javaType, null);
    }

    public AbstractFrom(BlazeCriteriaBuilderImpl criteriaBuilder, Class<X> javaType, AbstractPath<?> pathSource) {
        super(criteriaBuilder, javaType, pathSource);
    }

    @Override
    public Selection<X> alias(String alias) {
        return new FromSelection(this.criteriaBuilder, this, alias);
    }

    @Override
    public String getPathExpression() {
        return this.getAlias();
    }

    @Override
    public void renderPathExpression(RenderContext context) {
        context.getBuffer().append(this.resolveAlias(context));
    }

    @Override
    protected boolean isDereferencable() {
        return true;
    }

    public void visit(ParameterVisitor visitor) {
        for (AbstractJoin<X, ?> j : this.joins) {
            j.visit(visitor);
        }
    }

    @Override
    public String resolveAlias(RenderContext context) {
        if (this.getAttribute() != null && this.getAttribute().getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            return this.getBasePath().resolveAlias(context) + "." + this.getAttribute().getName();
        }
        String alias = this.getAlias();
        if (alias == null) {
            alias = this.isCorrelated() ? this.getCorrelationParent().getAlias() : (this.getJavaType() == null ? context.resolveAlias((Object)this, ((EntityType)this.getManagedType()).getName()) : context.resolveAlias((Object)this, this.getJavaType()));
        }
        return alias;
    }

    @Override
    public void render(RenderContext context) {
        context.getBuffer().append(this.resolveAlias(context));
    }

    @Override
    public Attribute<?, ?> getAttribute() {
        return null;
    }

    public BlazeFetchParent<?, Z> getParent() {
        return null;
    }

    @Override
    protected Attribute<X, ?> findAttribute(String name) {
        return this.getManagedType().getAttribute(name);
    }

    protected ManagedType<? super X> getManagedType() {
        return (ManagedType)this.getModel();
    }

    public boolean isCorrelated() {
        return this.correlationParent != null;
    }

    public AbstractFrom<Z, X> getCorrelationParent() {
        if (this.correlationParent == null) {
            throw new IllegalStateException("This from node has no correlation parent!");
        }
        return this.correlationParent;
    }

    public AbstractFrom<Z, X> correlateTo(SubqueryExpression<?> subquery) {
        AbstractFrom<Z, X> correlationDelegate = this.createCorrelationDelegate();
        correlationDelegate.prepareCorrelationDelegate(this);
        return correlationDelegate;
    }

    protected abstract AbstractFrom<Z, X> createCorrelationDelegate();

    public void prepareCorrelationDelegate(AbstractFrom<Z, X> parent) {
        this.joinScope = new CorrelationJoinScope();
        this.correlationParent = parent;
    }

    @Override
    public String getAlias() {
        return this.isCorrelated() ? this.getCorrelationParent().getAlias() : super.getAlias();
    }

    public abstract <T extends X> AbstractFrom<?, T> treatAs(Class<T> var1);

    protected final <N extends X, T extends TreatedPath<N>> T addTreatedPath(T treatedPath) {
        TreatedPath<Object> realJoin;
        if (this.treatedPaths == null) {
            this.treatedPaths = new LinkedHashMap<EntityType<? extends X>, TreatedPath<? extends X>>();
        }
        if ((realJoin = this.treatedPaths.get(treatedPath.getTreatType())) == null) {
            realJoin = treatedPath;
            this.treatedPaths.put(treatedPath.getTreatType(), treatedPath);
        }
        return (T)realJoin;
    }

    public Collection<TreatedPath<? extends X>> getTreatedPaths() {
        if (this.treatedPaths == null) {
            return Collections.emptyList();
        }
        return this.treatedPaths.values();
    }

    protected abstract boolean isJoinAllowed();

    protected JoinScope<X> getJoinScope() {
        return this.joinScope;
    }

    protected void checkJoinAllowed() {
        if (!this.isJoinAllowed()) {
            throw new IllegalArgumentException("Joins on '" + this.getPathExpression() + "' are not allowed");
        }
    }

    private void checkJoin(Attribute<?, ?> attribute, JoinType jt) {
        this.checkJoinAllowed();
        if (jt == JoinType.RIGHT) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        ManagedType<X> t = this.getManagedType();
        if (t == null) {
            throw new IllegalArgumentException("Joins on '" + this.getPathExpression() + "' are not allowed");
        }
        if (t.getAttribute(attribute.getName()) == null) {
            throw new IllegalArgumentException("Could not resolve attribute named: " + attribute.getName());
        }
    }

    public Set<Join<X, ?>> getJoins() {
        return this.joins == null ? Collections.EMPTY_SET : this.joins;
    }

    public Set<BlazeJoin<X, ?>> getBlazeJoins() {
        return this.joins == null ? Collections.EMPTY_SET : this.joins;
    }

    public <Y> BlazeJoin<X, Y> join(SingularAttribute<? super X, Y> singularAttribute, String alias) {
        return this.join(singularAttribute, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> join(SingularAttribute<? super X, Y> attribute, String alias, JoinType jt) {
        AbstractJoin<? super X, Y> join = this.constructJoin(attribute, alias, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> AbstractJoin<X, Y> constructJoin(SingularAttribute<? super X, Y> attribute, String alias, JoinType jt) {
        if (Type.PersistenceType.BASIC.equals((Object)attribute.getType().getPersistenceType())) {
            throw new IllegalArgumentException("Cannot join to attribute of basic type: " + attribute.getJavaType().getName());
        }
        this.checkJoin((Attribute<?, ?>)attribute, jt);
        Class attributeType = attribute.getBindableJavaType();
        SingularAttributeJoin join = new SingularAttributeJoin(this.criteriaBuilder, attributeType, this, attribute, jt);
        join.setAlias(alias);
        return join;
    }

    public <Y> BlazeCollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, String alias) {
        return this.join(collection, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeCollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, String alias, JoinType jt) {
        CollectionAttributeJoin<? super X, Y> join = this.constructJoin(collection, alias, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> CollectionAttributeJoin<X, Y> constructJoin(CollectionAttribute<? super X, Y> collection, String alias, JoinType jt) {
        this.checkJoin((Attribute<?, ?>)collection, jt);
        Class attributeType = collection.getBindableJavaType();
        CollectionAttributeJoin<X, Y> join = new CollectionAttributeJoin<X, Y>(this.criteriaBuilder, attributeType, this, collection, jt);
        join.setAlias(alias);
        return join;
    }

    public <Y> BlazeSetJoin<X, Y> join(SetAttribute<? super X, Y> set, String alias) {
        return this.join(set, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeSetJoin<X, Y> join(SetAttribute<? super X, Y> set, String alias, JoinType jt) {
        SetAttributeJoin<? super X, Y> join = this.constructJoin(set, alias, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> SetAttributeJoin<X, Y> constructJoin(SetAttribute<? super X, Y> set, String alias, JoinType jt) {
        this.checkJoin((Attribute<?, ?>)set, jt);
        Class attributeType = set.getBindableJavaType();
        SetAttributeJoin<X, Y> join = new SetAttributeJoin<X, Y>(this.criteriaBuilder, attributeType, this, set, jt);
        join.setAlias(alias);
        return join;
    }

    public <Y> BlazeListJoin<X, Y> join(ListAttribute<? super X, Y> list, String alias) {
        return this.join(list, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeListJoin<X, Y> join(ListAttribute<? super X, Y> list, String alias, JoinType jt) {
        ListAttributeJoin<? super X, Y> join = this.constructJoin(list, alias, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> ListAttributeJoin<X, Y> constructJoin(ListAttribute<? super X, Y> list, String alias, JoinType jt) {
        this.checkJoin((Attribute<?, ?>)list, jt);
        Class attributeType = list.getBindableJavaType();
        ListAttributeJoin<X, Y> join = new ListAttributeJoin<X, Y>(this.criteriaBuilder, attributeType, this, list, jt);
        join.setAlias(alias);
        return join;
    }

    public <K, V> BlazeMapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, String alias) {
        return this.join(map, alias, DEFAULT_JOIN_TYPE);
    }

    public <K, V> BlazeMapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, String alias, JoinType jt) {
        MapAttributeJoin<? super X, K, V> join = this.constructJoin(map, alias, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <K, V> MapAttributeJoin<X, K, V> constructJoin(MapAttribute<? super X, K, V> map, String alias, JoinType jt) {
        this.checkJoin((Attribute<?, ?>)map, jt);
        Class attributeType = map.getBindableJavaType();
        MapAttributeJoin<X, K, V> join = new MapAttributeJoin<X, K, V>(this.criteriaBuilder, attributeType, this, map, jt);
        join.setAlias(alias);
        return join;
    }

    public <X, Y> BlazeJoin<X, Y> join(String attributeName, String alias) {
        return this.join(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> BlazeJoin<X, Y> join(String attributeName, String alias, JoinType jt) {
        this.checkJoinAllowed();
        if (jt == JoinType.RIGHT) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((CollectionAttribute)attribute, alias, jt);
            }
            if (PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((ListAttribute)attribute, alias, jt);
            }
            if (PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((SetAttribute)attribute, alias, jt);
            }
            return this.join((MapAttribute)attribute, alias, jt);
        }
        return this.join((SingularAttribute)attribute, alias, jt);
    }

    public <X, Y> BlazeCollectionJoin<X, Y> joinCollection(String attributeName, String alias) {
        return this.joinCollection(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> BlazeCollectionJoin<X, Y> joinCollection(String attributeName, String alias, JoinType jt) {
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a collection");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a collection");
        }
        return this.join((CollectionAttribute)attribute, alias, jt);
    }

    public <X, Y> BlazeSetJoin<X, Y> joinSet(String attributeName, String alias) {
        return this.joinSet(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> BlazeSetJoin<X, Y> joinSet(String attributeName, String alias, JoinType jt) {
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a set");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a set");
        }
        return this.join((SetAttribute)attribute, alias, jt);
    }

    public <X, Y> BlazeListJoin<X, Y> joinList(String attributeName, String alias) {
        return this.joinList(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> BlazeListJoin<X, Y> joinList(String attributeName, String alias, JoinType jt) {
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a list");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a list");
        }
        return this.join((ListAttribute)attribute, alias, jt);
    }

    public <X, K, V> BlazeMapJoin<X, K, V> joinMap(String attributeName, String alias) {
        return this.joinMap(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, K, V> BlazeMapJoin<X, K, V> joinMap(String attributeName, String alias, JoinType jt) {
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a map");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.MAP.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a map");
        }
        return this.join((MapAttribute)attribute, alias, jt);
    }

    public <Y> BlazeJoin<X, Y> join(EntityType<Y> entityType, String alias) {
        return this.join(entityType, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> join(Class<Y> entityTypeClass, String alias) {
        return this.join(this.criteriaBuilder.getEntityMetamodel().entity(entityTypeClass), alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> join(EntityType<Y> entityType) {
        return this.join(entityType, null, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> join(Class<Y> entityTypeClass) {
        return this.join(this.criteriaBuilder.getEntityMetamodel().entity(entityTypeClass), null, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> join(EntityType<Y> entityType, JoinType joinType) {
        return this.join(entityType, null, joinType);
    }

    public <Y> BlazeJoin<X, Y> join(Class<Y> entityTypeClass, JoinType joinType) {
        return this.join(this.criteriaBuilder.getEntityMetamodel().entity(entityTypeClass), null, joinType);
    }

    public <Y> BlazeJoin<X, Y> join(Class<Y> entityTypeClass, String alias, JoinType joinType) {
        return this.join(this.criteriaBuilder.getEntityMetamodel().entity(entityTypeClass), alias, joinType);
    }

    public <Y> BlazeJoin<X, Y> join(EntityType<Y> entityType, String alias, JoinType joinType) {
        if (entityType == null) {
            throw new IllegalArgumentException("Null entity type");
        }
        if (joinType == null) {
            throw new IllegalArgumentException("Null join type");
        }
        EntityJoin join = new EntityJoin(this.criteriaBuilder, this, entityType, joinType);
        join.setAlias(alias);
        this.joinScope.addJoin(join);
        return join;
    }

    protected boolean isFetchAllowed() {
        return this.isJoinAllowed();
    }

    protected void checkFetchAllowed() {
        if (!this.isFetchAllowed()) {
            throw new IllegalArgumentException("Join fetches on '" + this.getPathExpression() + "' are not allowed");
        }
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetches == null ? Collections.EMPTY_SET : this.fetches;
    }

    public <Y> BlazeJoin<X, Y> fetch(SingularAttribute<? super X, Y> singularAttribute, String alias) {
        return this.fetch(singularAttribute, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> fetch(SingularAttribute<? super X, Y> attribute, String alias, JoinType jt) {
        this.checkFetchAllowed();
        AbstractJoin<? super X, Y> fetch = this.constructJoin(attribute, alias, jt);
        this.joinScope.addFetch(fetch);
        return fetch;
    }

    public <Y> BlazeJoin<X, Y> fetch(PluralAttribute<? super X, ?, Y> pluralAttribute, String alias) {
        return this.fetch(pluralAttribute, alias, DEFAULT_JOIN_TYPE);
    }

    public <Y> BlazeJoin<X, Y> fetch(PluralAttribute<? super X, ?, Y> pluralAttribute, String alias, JoinType jt) {
        this.checkFetchAllowed();
        AbstractPluralAttributeJoin fetch = PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((CollectionAttribute)pluralAttribute, alias, jt) : (PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((ListAttribute)pluralAttribute, alias, jt) : (PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((SetAttribute)pluralAttribute, alias, jt) : this.constructJoin((MapAttribute)pluralAttribute, alias, jt)));
        this.joinScope.addFetch(fetch);
        return fetch;
    }

    public <X, Y> BlazeJoin<X, Y> fetch(String attributeName, String alias) {
        return this.fetch(attributeName, alias, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> BlazeJoin<X, Y> fetch(String attributeName, String alias, JoinType jt) {
        this.checkFetchAllowed();
        Attribute<?, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            return this.fetch((PluralAttribute)attribute, alias, jt);
        }
        return this.fetch((SingularAttribute)attribute, alias, jt);
    }

    public <Y> BlazeJoin<X, Y> fetch(SingularAttribute<? super X, Y> attribute) {
        return this.fetch(attribute, (String)null);
    }

    public <Y> BlazeJoin<X, Y> fetch(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        return this.fetch(attribute, null, jt);
    }

    public <Y> BlazeJoin<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute) {
        return this.fetch(attribute, (String)null);
    }

    public <Y> BlazeJoin<X, Y> fetch(PluralAttribute<? super X, ?, Y> attribute, JoinType jt) {
        return this.fetch(attribute, null, jt);
    }

    public <X, Y> BlazeJoin<X, Y> fetch(String attributeName) {
        return this.fetch(attributeName, (String)null);
    }

    public <X, Y> BlazeJoin<X, Y> fetch(String attributeName, JoinType jt) {
        return this.fetch(attributeName, (String)null, jt);
    }

    public <Y> BlazeJoin<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join(attribute, (String)null);
    }

    public <Y> BlazeJoin<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        return this.join(attribute, (String)null, jt);
    }

    public <Y> BlazeCollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, (String)null);
    }

    public <Y> BlazeSetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, (String)null);
    }

    public <Y> BlazeListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, (String)null);
    }

    public <K, V> BlazeMapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, (String)null);
    }

    public <Y> BlazeCollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        return this.join(collection, (String)null, jt);
    }

    public <Y> BlazeSetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        return this.join(set, (String)null, jt);
    }

    public <Y> BlazeListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        return this.join(list, (String)null, jt);
    }

    public <K, V> BlazeMapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        return this.join(map, (String)null, jt);
    }

    public <X, Y> BlazeJoin<X, Y> join(String attributeName) {
        return this.join(attributeName, (String)null);
    }

    public <X, Y> BlazeCollectionJoin<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, (String)null);
    }

    public <X, Y> BlazeSetJoin<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, (String)null);
    }

    public <X, Y> BlazeListJoin<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, (String)null);
    }

    public <X, K, V> BlazeMapJoin<X, K, V> joinMap(String attributeName) {
        return this.joinMap(attributeName, (String)null);
    }

    public <X, Y> BlazeJoin<X, Y> join(String attributeName, JoinType jt) {
        return this.join(attributeName, (String)null, jt);
    }

    public <X, Y> BlazeCollectionJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        return this.joinCollection(attributeName, null, jt);
    }

    public <X, Y> BlazeSetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        return this.joinSet(attributeName, null, jt);
    }

    public <X, Y> BlazeListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        return this.joinList(attributeName, null, jt);
    }

    public <X, K, V> BlazeMapJoin<X, K, V> joinMap(String attributeName, JoinType joinType) {
        return this.joinMap(attributeName, null, joinType);
    }

    protected class BasicJoinScope
    implements JoinScope<X> {
        protected BasicJoinScope() {
        }

        @Override
        public void addJoin(AbstractJoin<X, ?> join) {
            if (AbstractFrom.this.joins == null) {
                AbstractFrom.this.joins = new LinkedHashSet();
            }
            AbstractFrom.this.joins.add(join);
        }

        @Override
        public void addFetch(AbstractJoin<X, ?> fetch) {
            fetch.setFetch(true);
            this.addJoin(fetch);
            if (AbstractFrom.this.fetches == null) {
                AbstractFrom.this.fetches = new LinkedHashSet();
            }
            AbstractFrom.this.fetches.add(fetch);
        }
    }

    public static interface JoinScope<X>
    extends Serializable {
        public void addJoin(AbstractJoin<X, ?> var1);

        public void addFetch(AbstractJoin<X, ?> var1);
    }

    protected class CorrelationJoinScope
    implements JoinScope<X> {
        protected CorrelationJoinScope() {
        }

        @Override
        public void addJoin(AbstractJoin<X, ?> join) {
            if (AbstractFrom.this.joins == null) {
                AbstractFrom.this.joins = new LinkedHashSet();
            }
            AbstractFrom.this.joins.add(join);
        }

        @Override
        public void addFetch(AbstractJoin<X, ?> fetch) {
            throw new UnsupportedOperationException("Cannot define fetch from a subquery correlation");
        }
    }
}

