/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeCollectionJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.AbstractPluralAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import com.blazebit.persistence.criteria.impl.support.CollectionJoinSupport;
import java.util.Collection;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;

public class CollectionAttributeJoin<O, E>
extends AbstractPluralAttributeJoin<O, Collection<E>, E>
implements BlazeCollectionJoin<O, E>,
CollectionJoinSupport<O, E> {
    private static final long serialVersionUID = 1L;

    private CollectionAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, CollectionAttributeJoin<O, ? super E> original, EntityType<E> treatType) {
        super(criteriaBuilder, original, treatType);
    }

    public CollectionAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<E> javaType, AbstractPath<O> pathSource, CollectionAttribute<? super O, E> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
    }

    @Override
    public final CollectionAttributeJoin<O, E> correlateTo(SubqueryExpression<?> subquery) {
        return (CollectionAttributeJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    public CollectionAttribute<? super O, E> getAttribute() {
        return (CollectionAttribute)super.getAttribute();
    }

    public CollectionAttribute<? super O, E> getModel() {
        return this.getAttribute();
    }

    @Override
    protected AbstractFrom<O, E> createCorrelationDelegate() {
        return new CollectionAttributeJoin(this.criteriaBuilder, this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
    }

    @Override
    public CollectionAttributeJoin<O, E> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public CollectionAttributeJoin<O, E> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    @Override
    public <T extends E> CollectionAttributeJoin<O, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    @Override
    public <T extends E> CollectionAttributeJoin<O, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedCollectionAttributeJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedCollectionAttributeJoin<O, E>
    extends CollectionAttributeJoin<O, E>
    implements TreatedPath<E> {
        private static final long serialVersionUID = 1L;
        private final CollectionAttributeJoin<?, ? super E> treatedJoin;
        private final EntityType<E> treatType;

        public TreatedCollectionAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, CollectionAttributeJoin<O, ? super E> treatedJoin, EntityType<E> treatType) {
            super(criteriaBuilder, treatedJoin, treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<E> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<E> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super E> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

