/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class ComparisonPredicate
extends AbstractSimplePredicate {
    private static final long serialVersionUID = 1L;
    private final ComparisonOperator comparisonOperator;
    private final Expression<?> leftHandSide;
    private final Expression<?> rightHandSide;

    public ComparisonPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Expression<?> rightHandSide) {
        super(criteriaBuilder, false);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new ComparisonPredicate(this.criteriaBuilder, this.comparisonOperator.getNegated(), this.leftHandSide, this.rightHandSide);
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.leftHandSide);
        visitor.visit((Selection<?>)this.rightHandSide);
    }

    @Override
    public void render(RenderContext context) {
        context.apply((Selection<?>)this.leftHandSide);
        context.getBuffer().append(this.comparisonOperator.getOperator());
        context.apply((Selection<?>)this.rightHandSide);
    }

    public static enum ComparisonOperator {
        EQUAL{

            @Override
            public String getOperator() {
                return "=";
            }

            @Override
            public ComparisonOperator getNegated() {
                return NOT_EQUAL;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public String getOperator() {
                return "<>";
            }

            @Override
            public ComparisonOperator getNegated() {
                return EQUAL;
            }
        }
        ,
        LESS_THAN{

            @Override
            public String getOperator() {
                return "<";
            }

            @Override
            public ComparisonOperator getNegated() {
                return GREATER_THAN_OR_EQUAL;
            }
        }
        ,
        LESS_THAN_OR_EQUAL{

            @Override
            public String getOperator() {
                return "<=";
            }

            @Override
            public ComparisonOperator getNegated() {
                return GREATER_THAN;
            }
        }
        ,
        GREATER_THAN{

            @Override
            public String getOperator() {
                return ">";
            }

            @Override
            public ComparisonOperator getNegated() {
                return LESS_THAN_OR_EQUAL;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL{

            @Override
            public String getOperator() {
                return ">=";
            }

            @Override
            public ComparisonOperator getNegated() {
                return LESS_THAN;
            }
        };


        public abstract String getOperator();

        public abstract ComparisonOperator getNegated();
    }
}

