/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaBuilder;
import com.blazebit.persistence.criteria.BlazeCriteriaQuery;
import com.blazebit.persistence.criteria.BlazeOrder;
import com.blazebit.persistence.criteria.BlazeRoot;
import com.blazebit.persistence.criteria.BlazeSubquery;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.InternalQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;

public class BlazeCriteriaQueryImpl<T>
implements BlazeCriteriaQuery<T> {
    private final BlazeCriteriaBuilderImpl criteriaBuilder;
    private final Class<T> returnType;
    private final InternalQuery<T> query;

    public BlazeCriteriaQueryImpl(BlazeCriteriaBuilderImpl criteriaBuilder, Class<T> returnType) {
        this.criteriaBuilder = criteriaBuilder;
        this.returnType = returnType;
        this.query = new InternalQuery(this, criteriaBuilder);
    }

    public boolean isDistinct() {
        return this.query.isDistinct();
    }

    public BlazeCriteriaQuery<T> distinct(boolean distinct) {
        this.query.setDistinct(distinct);
        return this;
    }

    public BlazeCriteriaQuery<T> select(Selection<? extends T> selection) {
        this.query.setSelection(this.criteriaBuilder.wrapSelection(selection));
        return this;
    }

    public Selection<T> getSelection() {
        return this.query.getSelection();
    }

    public BlazeCriteriaQuery<T> multiselect(Selection<?> ... selections) {
        return this.multiselect(Arrays.asList(selections));
    }

    public BlazeCriteriaQuery<T> multiselect(List<Selection<?>> selections) {
        Object selection;
        if (Tuple.class.isAssignableFrom(this.getResultType())) {
            selection = this.criteriaBuilder.tuple(selections);
        } else if (this.getResultType().isArray()) {
            selection = this.criteriaBuilder.array(this.getResultType(), selections);
        } else if (Object.class.equals(this.getResultType())) {
            switch (selections.size()) {
                case 0: {
                    throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                }
                case 1: {
                    selection = selections.get(0);
                    break;
                }
                default: {
                    selection = this.criteriaBuilder.array(selections);
                    break;
                }
            }
        } else {
            selection = this.criteriaBuilder.construct(this.getResultType(), selections);
        }
        this.query.setSelection((Selection<Tuple>)selection);
        return this;
    }

    public Set<Root<?>> getRoots() {
        return this.query.getRoots();
    }

    public Set<BlazeRoot<?>> getBlazeRoots() {
        return this.query.getBlazeRoots();
    }

    public <X> BlazeRoot<X> from(Class<X> entityClass) {
        return this.query.from(entityClass, null);
    }

    public <X> BlazeRoot<X> from(EntityType<X> entityType) {
        return this.query.from(entityType, null);
    }

    public <X> BlazeRoot<X> from(Class<X> entityClass, String alias) {
        return this.query.from(entityClass, alias);
    }

    public <X> BlazeRoot<X> from(EntityType<X> entityType, String alias) {
        return this.query.from(entityType, alias);
    }

    public Predicate getRestriction() {
        return this.query.getRestriction();
    }

    public BlazeCriteriaQuery<T> where(Expression<Boolean> restriction) {
        this.query.setRestriction(restriction == null ? null : this.criteriaBuilder.wrap(restriction));
        return this;
    }

    public BlazeCriteriaQuery<T> where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.query.setRestriction(null);
        } else {
            this.query.setRestriction(this.criteriaBuilder.and(restrictions));
        }
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.query.getGroupList();
    }

    public BlazeCriteriaQuery<T> groupBy(Expression<?> ... groupings) {
        if (groupings == null || groupings.length == 0) {
            this.query.setGroupList(Collections.EMPTY_LIST);
        } else {
            this.query.setGroupList(Arrays.asList(groupings));
        }
        return this;
    }

    public BlazeCriteriaQuery<T> groupBy(List<Expression<?>> groupings) {
        this.query.setGroupList(groupings);
        return this;
    }

    public Predicate getGroupRestriction() {
        return this.query.getGroupRestriction();
    }

    public BlazeCriteriaQuery<T> having(Expression<Boolean> restriction) {
        if (restriction == null) {
            this.query.setHaving(null);
        } else {
            this.query.setHaving(this.criteriaBuilder.wrap(restriction));
        }
        return this;
    }

    public BlazeCriteriaQuery<T> having(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.query.setHaving(null);
        } else {
            this.query.setHaving(this.criteriaBuilder.and(restrictions));
        }
        return this;
    }

    public List<BlazeOrder> getBlazeOrderList() {
        return this.query.getBlazeOrderList();
    }

    public List<Order> getOrderList() {
        return this.query.getOrderList();
    }

    public BlazeCriteriaQuery<T> orderBy(Order ... orders) {
        if (orders == null || orders.length == 0) {
            this.query.setOrderList(Collections.EMPTY_LIST);
        } else {
            this.query.setOrderList(Arrays.asList(orders));
        }
        return this;
    }

    public BlazeCriteriaQuery<T> orderBy(List<Order> orderList) {
        this.query.setOrderList(orderList);
        return this;
    }

    public Set<ParameterExpression<?>> getParameters() {
        return this.query.getParameters();
    }

    public <U> BlazeSubquery<U> subquery(Class<U> type) {
        return this.query.subquery(type);
    }

    public Class<T> getResultType() {
        return this.returnType;
    }

    public BlazeCriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public CriteriaBuilder<T> createCriteriaBuilder(EntityManager entityManager) {
        CriteriaBuilder cb = this.criteriaBuilder.getCriteriaBuilderFactory().create(entityManager, this.returnType);
        return this.query.render(cb);
    }
}

