/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.Selection;

public abstract class JpaTupleObjectBuilder
implements ObjectBuilder<Tuple> {
    private final Set<String> supportedEnumTypes;
    private final List<Selection<?>> selectionItems;
    private Map<String, Integer> selectAliasToPositionMap;
    private Map<Selection<?>, Integer> selectionToPositionMap;

    public JpaTupleObjectBuilder(BlazeCriteriaBuilderImpl criteriaBuilder, List<Selection<?>> selectionItems) {
        this.supportedEnumTypes = criteriaBuilder.getEntityMetamodel().getEnumTypes().keySet();
        this.selectionItems = selectionItems;
    }

    private Map<String, Integer> getSelectAliasToPositionMap() {
        if (this.selectAliasToPositionMap == null) {
            this.selectAliasToPositionMap = new HashMap<String, Integer>(this.selectionItems.size());
            int index = 0;
            for (Selection<?> s : this.selectionItems) {
                String alias = s.getAlias();
                if (alias != null) {
                    this.selectAliasToPositionMap.put(alias, index);
                }
                ++index;
            }
        }
        return this.selectAliasToPositionMap;
    }

    private Map<Selection<?>, Integer> getSelectionToPositionMap() {
        if (this.selectionToPositionMap == null) {
            this.selectionToPositionMap = new HashMap(this.selectionItems.size());
            int index = 0;
            for (Selection<?> s : this.selectionItems) {
                this.selectionToPositionMap.put(s, index);
                ++index;
            }
        }
        return this.selectionToPositionMap;
    }

    public Tuple build(Object[] tuple) {
        return new TupleImpl(tuple);
    }

    public List<Tuple> buildList(List<Tuple> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
        for (Selection<?> s : this.selectionItems) {
            this.renderSelection(queryBuilder, s);
        }
    }

    protected abstract void renderSelection(SelectBuilder<?> var1, Selection<?> var2);

    private class TupleImpl
    implements Tuple {
        private final Object[] tuple;

        private TupleImpl(Object[] tuple) {
            this.tuple = tuple;
        }

        public <X> X get(TupleElement<X> tupleElement) {
            return this.get((Integer)JpaTupleObjectBuilder.this.getSelectionToPositionMap().get(tupleElement), tupleElement.getJavaType());
        }

        public Object get(String alias) {
            Integer index = null;
            if (alias != null && (alias = alias.trim()).length() > 0) {
                index = (Integer)JpaTupleObjectBuilder.this.getSelectAliasToPositionMap().get(alias);
            }
            if (index == null) {
                throw new IllegalArgumentException("Could not find an element with alias '" + alias + "' in the result tuple");
            }
            return this.tuple[index];
        }

        public <X> X get(String alias, Class<X> type) {
            Object tupleElement = this.get(alias);
            return (X)TypeUtils.convert((Object)tupleElement, type, (Set)JpaTupleObjectBuilder.this.supportedEnumTypes);
        }

        public Object get(int i) {
            if (i >= this.tuple.length || i < 0) {
                throw new IllegalArgumentException("Invalid index " + i + "! The result tuple size is " + this.tuple.length);
            }
            return this.tuple[i];
        }

        public <X> X get(int i, Class<X> type) {
            Object tupleElement = this.get(i);
            return (X)TypeUtils.convert((Object)tupleElement, type, (Set)JpaTupleObjectBuilder.this.supportedEnumTypes);
        }

        public Object[] toArray() {
            return (Object[])this.tuple.clone();
        }

        public List<TupleElement<?>> getElements() {
            return JpaTupleObjectBuilder.this.selectionItems;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Arrays.deepHashCode(this.tuple);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TupleImpl other = (TupleImpl)obj;
            return Arrays.deepEquals(this.tuple, other.tuple);
        }
    }
}

