/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractExpression;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;

public class SimpleCaseExpression<C, R>
extends AbstractExpression<R>
implements CriteriaBuilder.SimpleCase<C, R> {
    private static final long serialVersionUID = 1L;
    private Class<R> javaType;
    private final Expression<? extends C> expression;
    private final List<WhenClause> whenClauses = new ArrayList<WhenClause>();
    private Expression<? extends R> otherwiseResult;

    public SimpleCaseExpression(BlazeCriteriaBuilderImpl criteriaBuilder, Class<R> javaType, Expression<? extends C> expression) {
        super(criteriaBuilder, javaType);
        this.javaType = javaType;
        this.expression = expression;
    }

    public Expression<C> getExpression() {
        return this.expression;
    }

    @Override
    public Class<R> getJavaType() {
        return this.javaType;
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, R result) {
        return this.when(condition, (Expression<? extends R>)this.criteriaBuilder.value(result));
    }

    public CriteriaBuilder.SimpleCase<C, R> when(C condition, Expression<? extends R> result) {
        WhenClause whenClause = new WhenClause(this.criteriaBuilder.value(condition), result);
        this.whenClauses.add(whenClause);
        this.adjustJavaType(result);
        return this;
    }

    private void adjustJavaType(Expression<? extends R> exp) {
        if (this.javaType == null) {
            this.javaType = exp.getJavaType();
        }
    }

    public Expression<R> otherwise(R result) {
        return this.otherwise((Expression<? extends R>)this.criteriaBuilder.value(result));
    }

    public Expression<R> otherwise(Expression<? extends R> result) {
        this.otherwiseResult = result;
        this.adjustJavaType(result);
        return this;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.expression);
        for (WhenClause whenClause : this.whenClauses) {
            visitor.visit((Selection<?>)whenClause.result);
        }
        visitor.visit((Selection<?>)this.otherwiseResult);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("CASE ");
        context.apply((Selection<?>)this.expression);
        for (WhenClause whenClause : this.whenClauses) {
            buffer.append(" WHEN ");
            context.apply((Selection<?>)whenClause.condition);
            buffer.append(" THEN ");
            context.apply((Selection<?>)whenClause.result);
        }
        buffer.append(" ELSE ");
        context.apply((Selection<?>)this.otherwiseResult);
        buffer.append(" END");
    }

    public class WhenClause {
        private final Expression<C> condition;
        private final Expression<? extends R> result;

        public WhenClause(Expression<C> condition, Expression<? extends R> result) {
            this.condition = condition;
            this.result = result;
        }
    }
}

