/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.BlazeMapJoin;
import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.SubqueryExpression;
import com.blazebit.persistence.criteria.impl.expression.function.EntryFunction;
import com.blazebit.persistence.criteria.impl.path.AbstractFrom;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.AbstractPluralAttributeJoin;
import com.blazebit.persistence.criteria.impl.path.MapKeyAttribute;
import com.blazebit.persistence.criteria.impl.path.MapKeyBasePath;
import com.blazebit.persistence.criteria.impl.path.MapKeyPath;
import com.blazebit.persistence.criteria.impl.path.TreatedPath;
import com.blazebit.persistence.criteria.impl.support.MapJoinSupport;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;

public class MapAttributeJoin<O, K, V>
extends AbstractPluralAttributeJoin<O, Map<K, V>, V>
implements BlazeMapJoin<O, K, V>,
MapJoinSupport<O, K, V> {
    private static final long serialVersionUID = 1L;

    private MapAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, MapAttributeJoin<O, K, ? super V> original, EntityType<V> treatType) {
        super(criteriaBuilder, original, treatType);
    }

    public MapAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, Class<V> javaType, AbstractPath<O> pathSource, MapAttribute<? super O, K, V> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
    }

    @Override
    public MapAttribute<? super O, K, V> getAttribute() {
        return (MapAttribute)super.getAttribute();
    }

    @Override
    public MapAttribute<? super O, K, V> getModel() {
        return this.getAttribute();
    }

    public final MapAttributeJoin<O, K, V> correlateTo(SubqueryExpression<?> subquery) {
        return (MapAttributeJoin)super.correlateTo((SubqueryExpression)subquery);
    }

    @Override
    protected AbstractFrom<O, V> createCorrelationDelegate() {
        return new MapAttributeJoin(this.criteriaBuilder, this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
    }

    public Path<V> value() {
        return this;
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new EntryFunction(this.criteriaBuilder, Map.Entry.class, this);
    }

    public Path<K> key() {
        MapKeyBasePath<K, V> mapKeyBasePath = new MapKeyBasePath<K, V>(this.criteriaBuilder, this.getAttribute().getJavaType(), this, this.getAttribute());
        MapKeyAttribute<K> mapKeyAttribute = new MapKeyAttribute<K>(this.criteriaBuilder, this.getAttribute());
        return new MapKeyPath<K>(this.criteriaBuilder, mapKeyBasePath, mapKeyAttribute);
    }

    @Override
    public MapAttributeJoin<O, K, V> on(Expression<Boolean> restriction) {
        super.onExpression(restriction);
        return this;
    }

    @Override
    public MapAttributeJoin<O, K, V> on(Predicate ... restrictions) {
        super.onPredicates(restrictions);
        return this;
    }

    public <T extends V> MapAttributeJoin<O, K, T> treatJoin(Class<T> treatType) {
        this.setTreatType(treatType);
        return this;
    }

    public <T extends V> MapAttributeJoin<O, K, T> treatAs(Class<T> treatAsType) {
        if (treatAsType.isAssignableFrom(this.getJavaType())) {
            return this;
        }
        return this.addTreatedPath(new TreatedMapAttributeJoin(this.criteriaBuilder, this, this.getTreatType(treatAsType)));
    }

    public static class TreatedMapAttributeJoin<O, K, V>
    extends MapAttributeJoin<O, K, V>
    implements TreatedPath<V> {
        private static final long serialVersionUID = 1L;
        private final MapAttributeJoin<O, K, ? super V> treatedJoin;
        private final EntityType<V> treatType;

        public TreatedMapAttributeJoin(BlazeCriteriaBuilderImpl criteriaBuilder, MapAttributeJoin<O, K, ? super V> treatedJoin, EntityType<V> treatType) {
            super(criteriaBuilder, treatedJoin, treatType);
            this.treatedJoin = treatedJoin;
            this.treatType = treatType;
        }

        @Override
        protected ManagedType<V> getManagedType() {
            return this.treatType;
        }

        @Override
        public EntityType<V> getTreatType() {
            return this.treatType;
        }

        @Override
        public AbstractPath<? super V> getTreatedPath() {
            return this.treatedJoin;
        }

        @Override
        public String getAlias() {
            return this.treatedJoin.getAlias();
        }

        @Override
        public String getPathExpression() {
            return this.getAlias();
        }

        @Override
        public void renderPathExpression(RenderContext context) {
            this.render(context);
        }

        @Override
        public void render(RenderContext context) {
            StringBuilder buffer = context.getBuffer();
            buffer.append("TREAT(").append(this.resolveAlias(context)).append(" AS ").append(this.getTreatType().getName()).append(')');
        }
    }
}

