/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.path;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.path.AbstractPath;
import com.blazebit.persistence.criteria.impl.path.MapKeyAttribute;
import com.blazebit.persistence.criteria.impl.path.MapKeyBasePath;
import java.io.Serializable;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;

public class MapKeyPath<K>
extends AbstractPath<K>
implements Path<K>,
Serializable {
    private final MapKeyAttribute<K> mapKeyAttribute;

    public MapKeyPath(BlazeCriteriaBuilderImpl criteriaBuilder, MapKeyBasePath<K, ?> source, MapKeyAttribute<K> mapKeyAttribute) {
        super(criteriaBuilder, mapKeyAttribute.getJavaType(), source);
        this.mapKeyAttribute = mapKeyAttribute;
    }

    public MapKeyBasePath getBasePath() {
        return (MapKeyBasePath)super.getBasePath();
    }

    public MapKeyAttribute<K> getAttribute() {
        return this.mapKeyAttribute;
    }

    private boolean isBasicTypeKey() {
        return Attribute.PersistentAttributeType.BASIC == this.mapKeyAttribute.getPersistentAttributeType();
    }

    @Override
    protected boolean isDereferencable() {
        return !this.isBasicTypeKey();
    }

    @Override
    public String getPathExpression() {
        MapKeyBasePath source = this.getBasePath();
        String name = source != null ? ((AbstractPath)source).getPathExpression() : this.getAttribute().getName();
        return "KEY(" + name + ')';
    }

    @Override
    public void renderPathExpression(RenderContext context) {
        this.render(context);
    }

    @Override
    public void render(RenderContext context) {
        StringBuilder buffer = context.getBuffer();
        buffer.append("KEY(");
        MapKeyBasePath source = this.getBasePath();
        if (source != null) {
            ((AbstractPath)source).renderPathExpression(context);
        } else {
            buffer.append(this.getAttribute().getName());
        }
        buffer.append(')');
    }

    @Override
    protected Attribute<?, ?> findAttribute(String attributeName) {
        if (!this.isDereferencable()) {
            throw new IllegalArgumentException("Map key [" + this.getBasePath().getPathExpression() + "] cannot be dereferenced");
        }
        throw new UnsupportedOperationException("Not yet supported!");
    }

    public Bindable<K> getModel() {
        return this.mapKeyAttribute;
    }

    @Override
    public <T extends K> MapKeyPath<T> treatAs(Class<T> treatAsType) {
        return this;
    }
}

