/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.criteria.impl.expression;

import com.blazebit.persistence.criteria.impl.BlazeCriteriaBuilderImpl;
import com.blazebit.persistence.criteria.impl.ParameterVisitor;
import com.blazebit.persistence.criteria.impl.RenderContext;
import com.blazebit.persistence.criteria.impl.expression.AbstractPredicate;
import com.blazebit.persistence.criteria.impl.expression.AbstractSimplePredicate;
import com.blazebit.persistence.criteria.impl.expression.ParameterExpressionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;

public class InPredicate<T>
extends AbstractSimplePredicate
implements CriteriaBuilder.In<T> {
    private static final long serialVersionUID = 1L;
    private final Expression<? extends T> expression;
    private final List<Expression<? extends T>> values;
    private boolean allValues = true;

    public InPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression) {
        this(criteriaBuilder, expression, new ArrayList<Expression<? extends T>>());
    }

    public InPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, List<Expression<? extends T>> values) {
        super(criteriaBuilder, false);
        if (expression instanceof ParameterExpressionImpl) {
            throw new IllegalArgumentException("A parameter can't be the left hand expression of an in predicate!");
        }
        this.expression = expression;
        this.values = values;
        for (int i = 0; i < values.size(); ++i) {
            Expression<T> expr = values.get(i);
            if (expr == null) {
                throw new IllegalArgumentException("Null expression at index: " + (i + 1));
            }
            this.allValues = this.allValues && expr instanceof ParameterExpressionImpl && ((ParameterExpressionImpl)expr).getValue() != null;
        }
    }

    private InPredicate(BlazeCriteriaBuilderImpl criteriaBuilder, boolean negated, Expression<? extends T> expression, List<Expression<? extends T>> values, boolean allValues) {
        super(criteriaBuilder, negated);
        this.expression = expression;
        this.values = values;
        this.allValues = allValues;
    }

    @Override
    public AbstractPredicate copyNegated() {
        return new InPredicate<T>(this.criteriaBuilder, !this.isNegated(), this.expression, this.values, this.allValues);
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    public InPredicate<T> value(T value) {
        return this.value((Expression)this.criteriaBuilder.value(value));
    }

    public InPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        this.allValues = this.allValues && value instanceof ParameterExpressionImpl && ((ParameterExpressionImpl)value).getValue() != null;
        return this;
    }

    @Override
    public void visitParameters(ParameterVisitor visitor) {
        visitor.visit((Selection<?>)this.expression);
        for (Expression<? extends T> expression : this.values) {
            visitor.visit((Selection<?>)expression);
        }
    }

    @Override
    public void render(RenderContext context) {
        List<Expression<T>> values = this.values;
        StringBuilder buffer = context.getBuffer();
        switch (values.size()) {
            case 0: {
                if (this.isNegated()) {
                    buffer.append("1=1");
                } else {
                    buffer.append("1=0");
                }
                return;
            }
            case 1: {
                Expression<? extends T> first = values.get(0);
                if (!(first instanceof Subquery) && (!(first instanceof ParameterExpressionImpl) || !Collection.class.isAssignableFrom(((ParameterExpressionImpl)first).getParameterType())) && !this.allValues) break;
                context.apply((Selection<?>)this.expression);
                if (this.isNegated()) {
                    buffer.append(" NOT");
                }
                buffer.append(" IN ");
                if (this.allValues) {
                    ArrayList literalValues = new ArrayList(values.size());
                    for (ParameterExpressionImpl parameterExpressionImpl : values) {
                        literalValues.add(parameterExpressionImpl.getRealValue());
                    }
                    String paramName = context.registerLiteralParameterBinding(literalValues, Collection.class);
                    buffer.append(':').append(paramName);
                } else {
                    context.apply((Selection<?>)first);
                }
                return;
            }
        }
        context.apply((Selection<?>)this.expression);
        if (this.isNegated()) {
            buffer.append(" NOT");
        }
        buffer.append(" IN ");
        if (this.allValues) {
            ArrayList literalValues = new ArrayList(values.size());
            for (ParameterExpressionImpl parameterExpressionImpl : values) {
                literalValues.add(parameterExpressionImpl.getRealValue());
            }
            String paramName = context.registerLiteralParameterBinding(literalValues, Collection.class);
            buffer.append(':').append(paramName);
        } else {
            buffer.append('(');
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    buffer.append(',');
                }
                context.apply((Selection)values.get(i));
            }
            buffer.append(')');
        }
    }
}

