/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.cte;

import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.examples.cte.data.CatDataAccess;
import com.blazebit.persistence.examples.cte.data.TestDataGenerator;
import com.blazebit.persistence.examples.cte.view.BasicCatView;
import com.blazebit.persistence.examples.spi.AbstractShowcase;
import com.blazebit.persistence.view.EntityViewSetting;
import javax.inject.Inject;

public class CTEShowcase
extends AbstractShowcase {
    @Inject
    private TestDataGenerator testDataGenerator;
    @Inject
    private CatDataAccess catDataAccess;

    public void run() {
        this.testDataGenerator.generateTestData();
        EntityViewSetting basicCatSetting = EntityViewSetting.create(BasicCatView.class);
        BasicCatView someCat = (BasicCatView)this.catDataAccess.getCatByName("G - Generation 2 - Cat 2/1", basicCatSetting);
        System.out.println(this.heading("Family tree of " + someCat));
        this.print(this.catDataAccess.getCatHierarchy((Integer)someCat.getId(), basicCatSetting));
        EntityViewSetting paginationSetting = EntityViewSetting.create(BasicCatView.class, (int)0, (int)3);
        PagedList pagedResults = this.catDataAccess.getPaginatedCats(paginationSetting);
        System.out.println(this.heading("Page 1"));
        this.print((Iterable)pagedResults);
        this.testDataGenerator.addCat("B - New cat");
        paginationSetting = EntityViewSetting.create(BasicCatView.class, (int)3, (int)3);
        paginationSetting.withKeysetPage(pagedResults.getKeysetPage());
        pagedResults = this.catDataAccess.getPaginatedCats(paginationSetting);
        System.out.println(this.heading("Page 2"));
        this.print((Iterable)pagedResults);
        paginationSetting = EntityViewSetting.create(BasicCatView.class, (int)0, (int)3);
        paginationSetting.withKeysetPage(pagedResults.getKeysetPage());
        pagedResults = this.catDataAccess.getPaginatedCats(paginationSetting);
        System.out.println(this.heading("Back at Page 1"));
        this.print((Iterable)pagedResults);
    }
}

