/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.examples.cte.data;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.PagedList;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.SelectCTECriteriaBuilder;
import com.blazebit.persistence.SelectRecursiveCTECriteriaBuilder;
import com.blazebit.persistence.WhereOrBuilder;
import com.blazebit.persistence.examples.base.bean.EntityManagerHolder;
import com.blazebit.persistence.examples.base.model.Cat;
import com.blazebit.persistence.examples.cte.CatHierarchyCTE;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Tuple;
import javax.transaction.Transactional;

@Transactional
public class CatDataAccess {
    @Inject
    private EntityManagerHolder emHolder;
    @Inject
    private EntityViewManager evm;
    @Inject
    private CriteriaBuilderFactory cbf;

    public <T> T getCatByName(String name, EntityViewSetting<T, CriteriaBuilder<T>> setting) {
        CriteriaBuilder cb = (CriteriaBuilder)this.cbf.create(this.emHolder.getEntityManager(), Cat.class).where("name").eq((Object)name);
        return (T)((CriteriaBuilder)this.evm.applySetting(setting, cb)).getSingleResult();
    }

    public <T> List<T> getCatHierarchy(Integer catId, EntityViewSetting<T, CriteriaBuilder<T>> setting) {
        CriteriaBuilder cb = (CriteriaBuilder)((CriteriaBuilder)((JoinOnBuilder)((CriteriaBuilder)((CriteriaBuilder)((SelectCTECriteriaBuilder)((WhereOrBuilder)((WhereOrBuilder)((SelectCTECriteriaBuilder)((SelectCTECriteriaBuilder)((SelectCTECriteriaBuilder)((SelectCTECriteriaBuilder)((SelectCTECriteriaBuilder)((SelectCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)((SelectRecursiveCTECriteriaBuilder)this.cbf.create(this.emHolder.getEntityManager(), Tuple.class).withRecursive(CatHierarchyCTE.class).from(Cat.class)).bind("id").select("id")).bind("motherId").select("mother.id")).bind("fatherId").select("father.id")).bind("generation").select("0")).where("id").eqExpression(catId.toString())).unionAll().from(Cat.class, "cat")).from(CatHierarchyCTE.class, "cte")).bind("id").select("cat.id")).bind("motherId").select("cat.mother.id")).bind("fatherId").select("cat.father.id")).bind("generation").select("cte.generation + 1")).whereOr().where("cat.id").eqExpression("cte.motherId")).where("cat.id").eqExpression("cte.fatherId")).endOr()).end()).from(Cat.class, "cat")).innerJoinOn(CatHierarchyCTE.class, "cte").on("cte.id").eqExpression("cat.id")).end()).orderByAsc("cte.generation");
        return ((CriteriaBuilder)this.evm.applySetting(setting, cb)).getResultList();
    }

    public <T> PagedList<T> getPaginatedCats(EntityViewSetting<T, PaginatedCriteriaBuilder<T>> setting) {
        CriteriaBuilder cb = (CriteriaBuilder)((CriteriaBuilder)this.cbf.create(this.emHolder.getEntityManager(), Cat.class).orderByAsc("name")).orderByAsc("id");
        return ((PaginatedCriteriaBuilder)this.evm.applySetting(setting, cb)).withKeysetExtraction(true).getResultList();
    }
}

