/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base;

import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.testsuite.base.SaneDB2Dialect;
import com.blazebit.persistence.testsuite.base.SaneMySQLDialect;
import com.blazebit.persistence.testsuite.base.jpa.AbstractJpaPersistenceTest;
import com.blazebit.persistence.testsuite.base.jpa.MutablePersistenceUnitInfo;
import com.blazebit.persistence.testsuite.base.jpa.RelationalModelAccessor;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.DatabaseCleaner;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.ProtectionDomain;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import org.hibernate.Version;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.AbstractEntityPersister;

public abstract class AbstractPersistenceTest
extends AbstractJpaPersistenceTest {
    private static final int HIBERNATE_MAJOR_VERSION;
    private static final int HIBERNATE_MINOR_VERSION;

    protected Connection getConnection(EntityManager em) {
        return ((SessionImplementor)em.unwrap(SessionImplementor.class)).connection();
    }

    protected void addIgnores(DatabaseCleaner applicableCleaner) {
        applicableCleaner.addIgnoredTable("hibernate_sequence");
    }

    protected Properties applyProperties(Properties properties) {
        boolean isMySql = properties.get("javax.persistence.jdbc.url").toString().contains("mysql");
        if (System.getProperty("hibernate.dialect") != null) {
            properties.put("hibernate.dialect", System.getProperty("hibernate.dialect"));
        } else if (isMySql) {
            properties.put("hibernate.dialect", SaneMySQLDialect.class.getName());
            if (this.isHibernate5()) {
                properties.put("hibernate.id.new_generator_mappings", "false");
            }
        } else if (properties.get("javax.persistence.jdbc.url").toString().contains("db2")) {
            properties.put("hibernate.dialect", SaneDB2Dialect.class.getName());
        } else if (properties.get("javax.persistence.jdbc.url").toString().contains("h2")) {
            if (this.isHibernate5()) {
                properties.put("hibernate.id.new_generator_mappings", "false");
            }
        } else if (properties.get("javax.persistence.jdbc.url").toString().contains("sqlserver")) {
            properties.put("hibernate.dialect", SQLServer2012Dialect.class.getName());
            if (this.isHibernate5()) {
                properties.put("hibernate.id.new_generator_mappings", "false");
            }
        } else if (this.isHibernate5() && properties.get("javax.persistence.jdbc.url").toString().contains("oracle")) {
            properties.put("hibernate.dialect", "org.hibernate.dialect.Oracle10gDialect");
        }
        String targetSchema = System.getProperty("hibernate.default_schema", this.getTargetSchema());
        if (targetSchema != null && this.getSchemaMode() == AbstractJpaPersistenceTest.SchemaMode.JPA) {
            properties.put("hibernate.default_schema", targetSchema);
        }
        if (this.useHbm2ddl()) {
            properties.put("hibernate.connection.url", properties.remove("javax.persistence.jdbc.url"));
            properties.put("hibernate.connection.password", properties.remove("javax.persistence.jdbc.password"));
            properties.put("hibernate.connection.username", properties.remove("javax.persistence.jdbc.user"));
            properties.put("hibernate.connection.driver_class", properties.remove("javax.persistence.jdbc.driver"));
            String dbAction = (String)properties.remove("javax.persistence.schema-generation.database.action");
            if ("drop-and-create".equals(dbAction)) {
                properties.put("hibernate.hbm2ddl.auto", "create");
            } else if ("create".equals(dbAction)) {
                properties.put("hibernate.hbm2ddl.auto", "create");
            } else if ("drop".equals(dbAction)) {
                properties.put("hibernate.hbm2ddl.auto", "create-drop");
            } else if ("none".equals(dbAction)) {
                properties.put("hibernate.hbm2ddl.auto", "none");
            } else {
                throw new IllegalArgumentException("Unsupported database action: " + dbAction);
            }
        }
        if (this.isHibernate526OrOlder()) {
            properties.put("hibernate.collection_join_subquery", "false");
        }
        properties.put("hibernate.ejb.metamodel.population", "enabled");
        properties.put("hibernate.jpa.metamodel.population", "enabled");
        if (this.isHibernate53Or54()) {
            properties.put("hibernate.archive.scanner", "org.hibernate.boot.archive.scan.internal.DisabledScanner");
        }
        properties.put("hibernate.id.db_structure_naming_strategy", "legacy");
        return properties;
    }

    protected void configurePersistenceUnitInfo(MutablePersistenceUnitInfo persistenceUnitInfo) {
        if (!this.supportsNestedEmbeddables() && this.containsDocumentEntity(this.getEntityClasses())) {
            persistenceUnitInfo.addMappingFileName("META-INF/override-embeddables-orm.xml");
        }
    }

    protected boolean supportsNestedEmbeddables() {
        return !this.isHibernate4();
    }

    public boolean supportsTableGroupJoins() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        int fix = Integer.parseInt(versionParts[2]);
        return major > 5 || major == 5 && (minor > 2 || minor == 2 && fix >= 8);
    }

    protected boolean doesJpaMergeOfRecentlyPersistedEntityForceUpdate() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        int fix = Integer.parseInt(versionParts[2]);
        return major < 5 || major == 5 && minor < 1 || major == 5 && minor == 1 && fix < 0;
    }

    protected boolean supportsIndexedInplaceUpdate() {
        return this.isHibernate5();
    }

    private boolean containsDocumentEntity(Class<?>[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!"Document".equals(classes[i].getSimpleName())) continue;
            return true;
        }
        return false;
    }

    protected DataSource createDataSource(Map<Object, Object> properties, Consumer<Connection> connectionCustomizer) {
        if (!this.useHbm2ddl()) {
            return super.createDataSource(properties, connectionCustomizer);
        }
        try {
            Class.forName((String)properties.remove("hibernate.connection.driver_class"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.createDataSource((String)properties.remove("hibernate.connection.url"), (String)properties.remove("hibernate.connection.username"), (String)properties.remove("hibernate.connection.password"), connectionCustomizer);
    }

    protected RelationalModelAccessor getRelationalModelAccessor() {
        return new RelationalModelAccessor(){

            public String tableFromEntity(Class<?> entityClass) {
                SessionImplementor session = (SessionImplementor)AbstractPersistenceTest.this.em.unwrap(SessionImplementor.class);
                AbstractEntityPersister persister = (AbstractEntityPersister)session.getFactory().getEntityPersister(entityClass.getName());
                return persister.getTableName().substring(persister.getTableName().lastIndexOf(46) + 1);
            }

            public String tableFromEntityRelation(Class<?> entityClass, String relationName) {
                JoinTable joinTable = jpaProvider.getJoinTable(AbstractPersistenceTest.this.em.getMetamodel().entity(entityClass), relationName);
                if (joinTable != null) {
                    return joinTable.getTableName().substring(joinTable.getTableName().lastIndexOf(46) + 1);
                }
                return null;
            }
        };
    }

    protected boolean supportsMapKeyDeReference() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        int fix = Integer.parseInt(versionParts[2]);
        return major > 5 || major == 5 && minor > 2 || major == 5 && minor == 2 && fix > 7;
    }

    protected boolean supportsInverseSetCorrelationJoinsSubtypesWhenJoined() {
        return this.getJpaProviderMajorVersion() >= 5;
    }

    private boolean isHibernate4() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        return major == 4;
    }

    private boolean useHbm2ddl() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        return major == 4 && minor <= 3;
    }

    private boolean isHibernate5() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        return major >= 5;
    }

    private boolean isHibernate526OrOlder() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        int fix = Integer.parseInt(versionParts[2]);
        return major < 5 || major == 5 && minor < 2 || major == 5 && minor == 2 && fix < 7;
    }

    private boolean isHibernate53Or54() {
        String version = Version.getVersionString();
        String[] versionParts = version.split("[\\.-]");
        int major = Integer.parseInt(versionParts[0]);
        int minor = Integer.parseInt(versionParts[1]);
        return major == 5 && (minor == 3 || minor == 4);
    }

    protected AbstractJpaPersistenceTest.JpaProviderFamily getJpaProviderFamily() {
        return AbstractJpaPersistenceTest.JpaProviderFamily.HIBERNATE;
    }

    protected int getJpaProviderMajorVersion() {
        return HIBERNATE_MAJOR_VERSION;
    }

    protected int getJpaProviderMinorVersion() {
        return HIBERNATE_MINOR_VERSION;
    }

    static {
        block15: {
            String version = Version.getVersionString();
            String[] versionParts = version.split("[\\.-]");
            HIBERNATE_MAJOR_VERSION = Integer.parseInt(versionParts[0]);
            HIBERNATE_MINOR_VERSION = Integer.parseInt(versionParts[1]);
            if (HIBERNATE_MAJOR_VERSION > 5 || HIBERNATE_MINOR_VERSION > 1) {
                try {
                    URL correctClass = null;
                    ClassLoader classLoader = Version.class.getClassLoader();
                    ArrayList<URL> list = Collections.list(classLoader.getResources("org/hibernate/engine/spi/SharedSessionContractImplementor.class"));
                    if (list.size() <= 1) break block15;
                    for (URL url : list) {
                        if (!url.toString().contains(".jar")) continue;
                        correctClass = url;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    try (InputStream inputStream = correctClass.openStream();){
                        int r;
                        while ((r = inputStream.read(buffer)) != -1) {
                            baos.write(buffer, 0, r);
                        }
                    }
                    byte[] bytes = baos.toByteArray();
                    try {
                        Method m = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
                        MethodHandles.Lookup lookup = (MethodHandles.Lookup)m.invoke(null, Status.class, MethodHandles.lookup());
                        MethodHandles.Lookup.class.getMethod("defineClass", byte[].class).invoke((Object)lookup, new Object[]{bytes});
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            Field f = Class.forName("sun.misc.Unsafe").getDeclaredField("theUnsafe");
                            f.setAccessible(true);
                            Object unsafe = f.get(null);
                            Method defineClass = Class.forName("sun.misc.Unsafe").getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                            defineClass.invoke(unsafe, "org.hibernate.engine.spi.SharedSessionContractImplementor", bytes, 0, bytes.length, classLoader, null);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

