/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa;

import com.blazebit.persistence.Criteria;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.impl.CriteriaBuilderConfigurationImpl;
import com.blazebit.persistence.spi.CriteriaBuilderConfiguration;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JoinTable;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.testsuite.base.jpa.DataSourceImpl;
import com.blazebit.persistence.testsuite.base.jpa.MutablePersistenceUnitInfo;
import com.blazebit.persistence.testsuite.base.jpa.RelationalModelAccessor;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatementBuilder;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.DB2DatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.DatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.H2DatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.MSSQLDatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.MySQL5DatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.MySQL8DatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.OracleDatabaseCleaner;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.PostgreSQLDatabaseCleaner;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractJpaPersistenceTest {
    protected static EntityManagerFactory emf;
    protected static CriteriaBuilderFactory cbf;
    protected static JpaProvider jpaProvider;
    protected static DbmsDialect dbmsDialect;
    private static boolean resolvedNoop;
    private static boolean databaseClean;
    private static Class<?> lastTestClass;
    private static String lastTargetSchema;
    private static Class<?> recreateTestClass;
    private static Set<Class<?>> databaseCleanerClasses;
    private static DatabaseCleaner databaseCleaner;
    private static HikariDataSource dataSource;
    private static DataSource bootstrapDataSource;
    private static CriteriaBuilderConfigurationEqualityWrapper lastCriteriaBuilderConfigurationEqualityWrapper;
    private static SchemaMode lastSchemaMode;
    private static CriteriaBuilderConfiguration defaultCbConfiguration;
    private static CriteriaBuilderConfiguration activeCriteriaBuilderConfiguration;
    private static final Map<Class<?>, List<String>> PLURAL_DELETES;
    private static final List<DatabaseCleaner.Factory> DATABASE_CLEANERS;
    protected EntityManager em;

    @BeforeClass
    public static void initLogging() {
        try {
            LogManager.getLogManager().readConfiguration(AbstractJpaPersistenceTest.class.getResourceAsStream("/logging.properties"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private DatabaseCleaner getLastDatabaseCleaner() {
        if (new HashSet(Arrays.asList(this.getEntityClasses())).equals(databaseCleanerClasses)) {
            return databaseCleaner;
        }
        return null;
    }

    private void setLastDatabaseCleaner(DatabaseCleaner cleaner) {
        databaseCleanerClasses = new HashSet(Arrays.asList(this.getEntityClasses()));
        databaseCleaner = cleaner;
    }

    protected void cleanDatabase() {
        this.cleanDatabaseWithCleaner();
    }

    protected final void cleanDatabaseWithCleaner() {
        if (databaseClean) {
            return;
        }
        try (Connection connection = dataSource.getConnection();){
            boolean wasAutoCommit = false;
            try {
                String targetSchema;
                wasAutoCommit = connection.getAutoCommit();
                if (wasAutoCommit) {
                    connection.setAutoCommit(false);
                }
                if ((targetSchema = this.getTargetSchema()) == null) {
                    targetSchema = connection.getSchema();
                }
                if (targetSchema == null) {
                    databaseCleaner.clearAllData(connection);
                } else {
                    databaseCleaner.clearData(connection, targetSchema);
                }
                databaseClean = true;
            }
            catch (Exception ex) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    ex.addSuppressed(e1);
                }
                throw new RuntimeException(ex);
            }
            finally {
                connection.commit();
                if (wasAutoCommit) {
                    try {
                        connection.setAutoCommit(true);
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void clearCollections(EntityManager em, Class<?> ... entityClasses) {
        for (Class<?> c : entityClasses) {
            List<String> deletes = PLURAL_DELETES.get(c);
            if (deletes == null) {
                Metamodel entityMetamodel = (Metamodel)cbf.getService(Metamodel.class);
                EntityType t = entityMetamodel.entity(c);
                deletes = new ArrayList<String>();
                for (PluralAttribute pluralAttribute : t.getPluralAttributes()) {
                    JoinTable joinTable = jpaProvider.getJoinTable(t, pluralAttribute.getName());
                    if (joinTable == null) continue;
                    deletes.add("delete from " + joinTable.getTableName());
                }
                PLURAL_DELETES.put(c, deletes);
            }
            for (String delete : deletes) {
                em.createNativeQuery(delete).executeUpdate();
            }
        }
    }

    private void clearSchema() {
        this.clearSchema(databaseCleaner);
    }

    public void clearSchema(DatabaseCleaner databaseCleaner) {
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            String targetSchema = this.getTargetSchema();
            if (targetSchema == null) {
                databaseCleaner.clearAllSchemas(connection);
            } else {
                databaseCleaner.clearSchema(connection, targetSchema);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public DatabaseCleaner getDefaultDatabaseCleaner() {
        return new DatabaseCleaner(){

            @Override
            public boolean isApplicable(Connection connection) {
                return true;
            }

            @Override
            public boolean supportsClearSchema() {
                return false;
            }

            @Override
            public void clearAllSchemas(Connection connection) {
            }

            @Override
            public void clearSchema(Connection connection, String schemaName) {
            }

            @Override
            public void addIgnoredTable(String tableName) {
            }

            @Override
            public void clearAllData(Connection connection) {
                AbstractJpaPersistenceTest.this.repopulateSchema();
            }

            @Override
            public void clearData(Connection connection, String schemaName) {
                AbstractJpaPersistenceTest.this.repopulateSchema();
            }

            @Override
            public void createDatabaseIfNotExists(Connection connection, String databaseName) {
            }

            @Override
            public void createSchemaIfNotExists(Connection connection, String schemaName) {
            }

            @Override
            public void applyTargetDatabasePropertyModifications(Map<Object, Object> properties, String databaseName) {
            }

            @Override
            public void applyTargetSchemaPropertyModifications(Map<Object, Object> properties, String schemaName) {
            }
        };
    }

    public DatabaseCleaner getDatabaseCleaner(Connection connection) {
        DatabaseCleaner applicableCleaner = null;
        for (DatabaseCleaner.Factory factory : DATABASE_CLEANERS) {
            DatabaseCleaner cleaner = factory.create();
            if (!cleaner.isApplicable(connection)) continue;
            applicableCleaner = cleaner;
            break;
        }
        this.addIgnores(applicableCleaner);
        this.setLastDatabaseCleaner(applicableCleaner);
        return applicableCleaner;
    }

    @Before
    public void init() {
        boolean schemaChanged;
        boolean firstTest = lastTestClass != this.getClass();
        boolean veryFirstTest = lastTestClass == null;
        lastTestClass = this.getClass();
        if (resolvedNoop) {
            databaseCleaner = null;
            schemaChanged = true;
        } else {
            databaseCleaner = this.getLastDatabaseCleaner();
            schemaChanged = databaseCleaner == null || !Objects.equals(lastTargetSchema, this.getTargetSchema());
        }
        lastTargetSchema = this.getTargetSchema();
        SchemaMode schemaMode = this.getSchemaMode();
        if (dataSource != null && lastSchemaMode != schemaMode) {
            dataSource.close();
            dataSource = null;
            AbstractJpaPersistenceTest.closeEmf();
        }
        lastSchemaMode = schemaMode;
        databaseClean = schemaChanged;
        if (dataSource != null && this.recreateDataSource()) {
            recreateTestClass = this.getClass();
            dataSource.close();
            dataSource = null;
            AbstractJpaPersistenceTest.closeEmf();
        } else if (recreateTestClass != null && recreateTestClass != this.getClass()) {
            recreateTestClass = null;
            if (dataSource != null) {
                dataSource.close();
                dataSource = null;
            }
            AbstractJpaPersistenceTest.closeEmf();
        }
        QueryInspectorListener.enabled = false;
        QueryInspectorListener.collectSequences = false;
        if (!resolvedNoop && databaseCleaner == null) {
            if (bootstrapDataSource == null) {
                this.getBootstrapDataSource();
            }
            try (Connection c = bootstrapDataSource.getConnection();){
                DatabaseCleaner applicableCleaner = this.getDatabaseCleaner(c);
                if (applicableCleaner == null) {
                    Logger.getLogger(this.getClass().getName()).warning("Could not resolve database cleaner for the database, falling back to drop-and-create strategy.");
                    resolvedNoop = true;
                }
                String targetDatabase = this.getTargetDatabase();
                String targetSchema = this.getTargetSchema();
                if (targetDatabase != null) {
                    databaseCleaner.createDatabaseIfNotExists(c, targetDatabase);
                }
                if (targetSchema != null) {
                    this.createSchemaIfNotExists(c, targetSchema);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (databaseCleaner == null) {
            this.setLastDatabaseCleaner(this.getDefaultDatabaseCleaner());
        }
        EntityManagerFactory emfBefore = emf;
        if (veryFirstTest || schemaChanged) {
            this.getDataSource(this.createProperties("none"));
            emf = this.repopulateSchema();
            if (emf == null) {
                emf = this.createEntityManagerFactory("TestsuiteBase", this.createProperties("none"));
            }
        } else if (emf == null || !emf.isOpen()) {
            emf = this.createEntityManagerFactory("TestsuiteBase", this.createProperties("none"));
        }
        if (activeCriteriaBuilderConfiguration == null) {
            if (this.requiresCriteriaBuilderConfigurationCustomization()) {
                activeCriteriaBuilderConfiguration = Criteria.getDefault();
                this.configure(activeCriteriaBuilderConfiguration);
            } else {
                if (defaultCbConfiguration == null) {
                    defaultCbConfiguration = Criteria.getDefault();
                }
                activeCriteriaBuilderConfiguration = defaultCbConfiguration;
            }
        }
        CriteriaBuilderConfigurationEqualityWrapper cfgEqualityWrapper = new CriteriaBuilderConfigurationEqualityWrapper((CriteriaBuilderConfigurationImpl)activeCriteriaBuilderConfiguration);
        if (cbf == null || emfBefore != emf || !cfgEqualityWrapper.equals(lastCriteriaBuilderConfigurationEqualityWrapper)) {
            cbf = activeCriteriaBuilderConfiguration.createCriteriaBuilderFactory(emf);
            lastCriteriaBuilderConfigurationEqualityWrapper = cfgEqualityWrapper;
            jpaProvider = (JpaProvider)cbf.getService(JpaProvider.class);
            dbmsDialect = (DbmsDialect)cbf.getService(DbmsDialect.class);
        }
        this.getEm();
        if (firstTest) {
            this.setUpOnce();
        }
        if (this.runTestInTransaction() && !this.getEm().getTransaction().isActive()) {
            this.getEm().getTransaction().begin();
        }
    }

    protected void createSchemaIfNotExists(Connection connection, String schemaName) {
        databaseCleaner.createSchemaIfNotExists(connection, schemaName);
    }

    protected SchemaMode getSchemaMode() {
        return SchemaMode.JPA;
    }

    private EntityManager getEm() {
        if (this.em == null) {
            this.em = emf.createEntityManager();
        }
        return this.em;
    }

    protected boolean runTestInTransaction() {
        return true;
    }

    protected void addIgnores(DatabaseCleaner applicableCleaner) {
    }

    protected boolean needsEntityManagerForDbAction() {
        return false;
    }

    protected static void resetTimeZoneCaches() {
        try {
            Class.forName("org.h2.util.DateTimeUtils").getMethod("resetCalendar", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> helperClass = Class.forName("org.eclipse.persistence.internal.helper.Helper");
            Field f = helperClass.getDeclaredField("defaultTimeZone");
            f.setAccessible(true);
            f.set(null, TimeZone.getDefault());
            f = helperClass.getDeclaredField("calendarCache");
            f.setAccessible(true);
            f.set(null, helperClass.getMethod("initCalendarCache", new Class[0]).invoke(null, new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected EntityManagerFactory populateSchema() {
        EntityManagerFactory entityManagerFactory = this.createEntityManagerFactory("TestsuiteBase", this.createProperties("create"));
        if (this.needsEntityManagerForDbAction()) {
            entityManagerFactory.createEntityManager().close();
            entityManagerFactory = null;
        }
        return entityManagerFactory;
    }

    protected void clearSchemaUsingJpa() {
        EntityManagerFactory entityManagerFactory = this.createEntityManagerFactory("TestsuiteBase", this.createProperties("drop"));
        if (this.needsEntityManagerForDbAction()) {
            try {
                entityManagerFactory.createEntityManager().close();
            }
            finally {
                entityManagerFactory.close();
            }
        }
    }

    private EntityManagerFactory repopulateSchemaUsingJpa() {
        EntityManagerFactory entityManagerFactory = this.createEntityManagerFactory("TestsuiteBase", this.createProperties("drop-and-create"));
        if (this.needsEntityManagerForDbAction()) {
            entityManagerFactory.createEntityManager().close();
            entityManagerFactory = null;
        }
        return entityManagerFactory;
    }

    protected EntityManagerFactory repopulateSchema() {
        if (databaseCleaner.supportsClearSchema()) {
            this.clearSchema();
            return this.populateSchema();
        }
        return this.repopulateSchemaUsingJpa();
    }

    protected void setUpOnce() {
    }

    protected abstract boolean supportsMapKeyDeReference();

    protected abstract boolean supportsInverseSetCorrelationJoinsSubtypesWhenJoined();

    protected boolean supportsSingleStatementNaturalIdCollectionFetching() {
        return false;
    }

    protected boolean supportsLazyCollectionElementJoin() {
        return false;
    }

    protected boolean supportsProxyRemoveWithoutLoading() {
        return false;
    }

    protected boolean supportsIndexedInplaceUpdate() {
        return false;
    }

    public boolean supportsTableGroupJoins() {
        return false;
    }

    protected boolean supportsAdvancedSql() {
        ExtendedQuerySupport extendedQuerySupport = (ExtendedQuerySupport)cbf.getService(ExtendedQuerySupport.class);
        return extendedQuerySupport != null && extendedQuerySupport.supportsAdvancedSql();
    }

    protected boolean doesJpaMergeOfRecentlyPersistedEntityForceUpdate() {
        return true;
    }

    @After
    public void destruct() {
        if (this.em != null && this.em.isOpen()) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            this.em.close();
            this.em = null;
        }
        if (databaseCleaner != null && !databaseCleaner.supportsClearSchema()) {
            this.clearSchemaUsingJpa();
        }
        if (dataSource != null && this.recreateDataSource()) {
            dataSource.close();
            dataSource = null;
            AbstractJpaPersistenceTest.closeEmf();
        }
    }

    public static void closeEmf() {
        if (emf != null && emf.isOpen()) {
            emf.close();
            emf = null;
        }
    }

    @AfterClass
    public static void tearDownClass() {
        AbstractJpaPersistenceTest.closeEmf();
        activeCriteriaBuilderConfiguration = null;
    }

    protected String getTargetSchema() {
        return System.getProperty("jdbc.schema");
    }

    protected String getTargetDatabase() {
        return System.getProperty("jdbc.database");
    }

    protected Properties createProperties(String dbAction) {
        Properties properties = AbstractJpaPersistenceTest.createDefaultProperties();
        properties.put("javax.persistence.schema-generation.database.action", dbAction);
        String targetDatabase = this.getTargetDatabase();
        String targetSchema = this.getTargetSchema();
        if (targetDatabase != null) {
            databaseCleaner.applyTargetDatabasePropertyModifications(properties, targetDatabase);
        }
        if (targetSchema != null && this.getSchemaMode() == SchemaMode.JDBC) {
            databaseCleaner.applyTargetSchemaPropertyModifications(properties, targetSchema);
        }
        return this.applyProperties(properties);
    }

    protected Properties createBootstrapProperties() {
        Properties properties = AbstractJpaPersistenceTest.createDefaultProperties();
        return this.applyProperties(properties);
    }

    private static Properties createDefaultProperties() {
        Properties properties = new Properties();
        properties.put("javax.persistence.jdbc.url", System.getProperty("jdbc.url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1"));
        properties.put("javax.persistence.jdbc.user", System.getProperty("jdbc.user", "user"));
        properties.put("javax.persistence.jdbc.password", System.getProperty("jdbc.password", "password"));
        properties.put("javax.persistence.jdbc.driver", System.getProperty("jdbc.driver", "org.h2.Driver"));
        properties.put("javax.persistence.sharedCache.mode", "NONE");
        properties.put("javax.persistence.schema-generation.database.action", "none");
        return properties;
    }

    protected abstract Class<?>[] getEntityClasses();

    protected Connection getConnection(EntityManager em) {
        return (Connection)em.unwrap(Connection.class);
    }

    protected boolean requiresCriteriaBuilderConfigurationCustomization() {
        return false;
    }

    protected void configure(CriteriaBuilderConfiguration config) {
    }

    protected Properties applyProperties(Properties properties) {
        return properties;
    }

    protected EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map<Object, Object> properties) {
        MutablePersistenceUnitInfo persistenceUnitInfo = new MutablePersistenceUnitInfo();
        persistenceUnitInfo.setPersistenceUnitName(persistenceUnitName);
        persistenceUnitInfo.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        persistenceUnitInfo.setNonJtaDataSource(this.getDataSource(properties));
        persistenceUnitInfo.setExcludeUnlistedClasses(true);
        try {
            URL url = AbstractJpaPersistenceTest.class.getClassLoader().getResource("");
            persistenceUnitInfo.setPersistenceUnitRootUrl(url);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (Class<?> clazz : this.getEntityClasses()) {
            persistenceUnitInfo.addManagedClassName(clazz.getName());
        }
        this.configurePersistenceUnitInfo(persistenceUnitInfo);
        return AbstractJpaPersistenceTest.createEntityManagerFactory(persistenceUnitInfo, properties);
    }

    protected void configurePersistenceUnitInfo(MutablePersistenceUnitInfo persistenceUnitInfo) {
    }

    protected boolean supportsNestedEmbeddables() {
        return true;
    }

    protected boolean optimizesUnnecessaryCasts() {
        return false;
    }

    protected boolean recreateDataSource() {
        return false;
    }

    private DataSource getDataSource(Map<Object, Object> properties) {
        if (dataSource != null) {
            properties.remove("javax.persistence.jdbc.driver");
            properties.remove("javax.persistence.jdbc.url");
            properties.remove("javax.persistence.jdbc.user");
            properties.remove("javax.persistence.jdbc.password");
            properties.remove("hibernate.connection.driver_class");
            properties.remove("hibernate.connection.url");
            properties.remove("hibernate.connection.username");
            properties.remove("hibernate.connection.password");
            return dataSource;
        }
        dataSource = this.createPooledDataSource(this.proxyDataSource(this.createDataSource(properties, null)));
        return dataSource;
    }

    private DataSource getBootstrapDataSource() {
        if (bootstrapDataSource == null) {
            bootstrapDataSource = this.createDataSource(this.createBootstrapProperties(), null);
            return bootstrapDataSource;
        }
        return bootstrapDataSource;
    }

    protected DataSource createDataSource(Map<Object, Object> properties, Consumer<Connection> connectionCustomizer) {
        try {
            Class.forName((String)properties.remove("javax.persistence.jdbc.driver"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.createDataSource((String)properties.remove("javax.persistence.jdbc.url"), (String)properties.remove("javax.persistence.jdbc.user"), (String)properties.remove("javax.persistence.jdbc.password"), connectionCustomizer);
    }

    protected DataSource createDataSource(String url, String username, String password, Consumer<Connection> connectionCustomizer) {
        return new DataSourceImpl(url, username, password, connectionCustomizer);
    }

    private HikariDataSource createPooledDataSource(DataSource dataSource) {
        HikariConfig config = new HikariConfig();
        config.setMaximumPoolSize(3);
        config.setDataSource(dataSource);
        config.setTransactionIsolation("TRANSACTION_READ_COMMITTED");
        return new HikariDataSource(config);
    }

    private DataSource proxyDataSource(DataSource dataSource) {
        AbstractJpaPersistenceTest.clearQueries();
        return ProxyDataSourceBuilder.create((DataSource)dataSource).listener((QueryExecutionListener)QueryInspectorListener.INSTANCE).build();
    }

    public static void clearQueries() {
        QueryInspectorListener.EXECUTED_QUERIES.clear();
    }

    public static void enableQueryCollecting() {
        QueryInspectorListener.enabled = true;
    }

    public static void disableQueryCollecting() {
        QueryInspectorListener.enabled = false;
        QueryInspectorListener.EXECUTED_QUERIES.clear();
    }

    public static void assertUnorderedEquals(List<?> list1, List<?> list2) {
        Assert.assertEquals((long)list1.size(), (long)list2.size());
        Assert.assertTrue((boolean)list1.containsAll(list2));
    }

    public static void assertQueryCount(int count) {
        List queries = QueryInspectorListener.EXECUTED_QUERIES;
        if (count != queries.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected query count for queries:");
            for (String q : queries) {
                sb.append("\n").append(q);
            }
            Assert.assertEquals((String)sb.toString(), (long)count, (long)queries.size());
        }
    }

    public AssertStatementBuilder assertOrderedQuerySequence() {
        return new AssertStatementBuilder(this.getRelationalModelAccessor(), QueryInspectorListener.EXECUTED_QUERIES);
    }

    public AssertStatementBuilder assertUnorderedQuerySequence() {
        return this.assertOrderedQuerySequence().unordered();
    }

    protected static <T, E extends Throwable> E verifyException(T object, Consumer<T> action) {
        return (E)AbstractJpaPersistenceTest.verifyException(object, Throwable.class, action);
    }

    protected static <T, E extends Throwable> E verifyException(T object, Class<E> throwableClass, Consumer<T> action) {
        try {
            action.accept(object);
            throw new AssertionError((Object)("Neither an exception of type " + throwableClass.getName() + " nor another exception was thrown"));
        }
        catch (Throwable ex) {
            if (!throwableClass.isInstance(ex)) {
                throw new AssertionError("Exception of type " + throwableClass.getName() + " expected but was not thrown. Instead an exception of type " + ex.getClass() + " with message '" + ex.getMessage() + "' was thrown.", ex);
            }
            return (E)ex;
        }
    }

    protected RelationalModelAccessor getRelationalModelAccessor() {
        return null;
    }

    private static EntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo persistenceUnitInfo, Map<Object, Object> properties) {
        EntityManagerFactory factory = null;
        Map<Object, Object> props = properties;
        if (props == null) {
            props = Collections.emptyMap();
        }
        PersistenceProviderResolver resolver = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List providers = resolver.getPersistenceProviders();
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>();
        StringBuffer foundProviders = null;
        for (PersistenceProvider provider : providers) {
            String providerName = provider.getClass().getName();
            try {
                factory = provider.createContainerEntityManagerFactory(persistenceUnitInfo, props);
            }
            catch (Exception e) {
                exceptions.put(providerName, e);
            }
            if (factory != null) {
                return factory;
            }
            if (foundProviders == null) {
                foundProviders = new StringBuffer(providerName);
                continue;
            }
            foundProviders.append(", ");
            foundProviders.append(providerName);
        }
        if (foundProviders == null) {
            foundProviders = new StringBuffer("NONE");
        }
        if (exceptions.isEmpty()) {
            throw new PersistenceException("No persistence providers available for \"" + persistenceUnitInfo.getPersistenceUnitName() + "\" after trying the following discovered implementations: " + foundProviders);
        }
        throw AbstractJpaPersistenceTest.createPersistenceException("Explicit persistence provider error(s) occurred for \"" + persistenceUnitInfo.getPersistenceUnitName() + "\" after trying the following discovered implementations: " + foundProviders, exceptions);
    }

    private static PersistenceException createPersistenceException(String msg, Map<String, Throwable> failures) {
        String newline = System.getProperty("line.separator");
        StringWriter strWriter = new StringWriter();
        strWriter.append(msg);
        if (failures.size() <= 1 || failures.size() == 2 && failures.containsKey("org.hibernate.ejb.HibernatePersistence") && failures.containsKey("org.hibernate.jpa.HibernatePersistenceProvider")) {
            Throwable t = null;
            Iterator<String> iterator = failures.keySet().iterator();
            if (iterator.hasNext()) {
                String providerName = iterator.next();
                t = failures.get(providerName);
                strWriter.append(" from provider: ");
                strWriter.append(providerName);
            }
            return new PersistenceException(strWriter.toString(), t);
        }
        strWriter.append(" with the following failures:");
        strWriter.append(newline);
        for (String providerName : failures.keySet()) {
            strWriter.append(providerName);
            strWriter.append(" returned: ");
            failures.get(providerName).printStackTrace(new PrintWriter(strWriter));
        }
        strWriter.append(newline);
        return new PersistenceException(strWriter.toString());
    }

    protected abstract JpaProviderFamily getJpaProviderFamily();

    protected abstract int getJpaProviderMajorVersion();

    protected abstract int getJpaProviderMinorVersion();

    static {
        resolvedNoop = false;
        databaseClean = false;
        PLURAL_DELETES = new HashMap();
        DATABASE_CLEANERS = Arrays.asList(new H2DatabaseCleaner.Factory(), new PostgreSQLDatabaseCleaner.Factory(), new DB2DatabaseCleaner.Factory(), new MySQL5DatabaseCleaner.Factory(), new MySQL8DatabaseCleaner.Factory(), new MSSQLDatabaseCleaner.Factory(), new OracleDatabaseCleaner.Factory());
        System.setProperty("org.jboss.logging.provider", "jdk");
        Locale.setDefault(new Locale(System.getProperty("user.language", "en"), System.getProperty("user.country", "US")));
    }

    protected static enum SchemaMode {
        JPA,
        JDBC;

    }

    private static final class QueryInspectorListener
    implements QueryExecutionListener {
        public static final QueryInspectorListener INSTANCE = new QueryInspectorListener();
        private static final List<String> EXECUTED_QUERIES = new ArrayList<String>();
        private static boolean enabled = false;
        private static boolean collectSequences = false;

        private QueryInspectorListener() {
        }

        public void beforeQuery(ExecutionInfo executionInfo, List<QueryInfo> list) {
        }

        public void afterQuery(ExecutionInfo executionInfo, List<QueryInfo> list) {
            if (enabled) {
                for (QueryInfo q : list) {
                    String query = q.getQuery();
                    if (!collectSequences && (query.contains("next_val") || query.contains("nextval") || query.contains("next value for"))) continue;
                    EXECUTED_QUERIES.add(query);
                }
            }
        }
    }

    private static class CriteriaBuilderConfigurationEqualityWrapper {
        private final Properties properties;
        private final Map<String, Class<?>> macros;
        private final Map<String, Class<?>> functions;

        private CriteriaBuilderConfigurationEqualityWrapper(CriteriaBuilderConfigurationImpl cfg) {
            this.properties = cfg.getProperties();
            this.macros = cfg.getMacros().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JpqlMacro)entry.getValue()).getClass()));
            this.functions = cfg.getFunctions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JpqlFunctionGroup)entry.getValue()).getClass()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CriteriaBuilderConfigurationEqualityWrapper that = (CriteriaBuilderConfigurationEqualityWrapper)o;
            return this.properties.equals(that.properties) && this.macros.equals(that.macros) && this.functions.equals(that.functions);
        }

        public int hashCode() {
            return Objects.hash(this.properties, this.macros, this.functions);
        }
    }

    protected static enum JpaProviderFamily {
        HIBERNATE,
        DATANUCLEUS,
        ECLIPSELINK,
        OPENJPA;

    }
}

