/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa;

import com.blazebit.persistence.testsuite.base.jpa.BlazePersistenceTestsuite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.experimental.categories.Categories;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public abstract class BlazePersistenceForkedTestsuite
extends BlazePersistenceTestsuite {
    private static final Logger LOG = Logger.getLogger(BlazePersistenceForkedTestsuite.class.getName());
    private static final float GROUP_SPLIT_THRESHOLD = 0.6f;

    protected static TestSuite suite0(int testsuiteNumber) {
        int forkCount = Integer.parseInt(System.getProperty("forkCount", "1"));
        int fork = Integer.parseInt(System.getProperty("fork", "1"));
        TestSuite suite = new TestSuite();
        if (testsuiteNumber <= forkCount) {
            Class[] excludedGroups = BlazePersistenceForkedTestsuite.loadExcludedGroups();
            BlazePersistenceTestsuite.TestClasses testClasses = BlazePersistenceForkedTestsuite.loadAndGroupTestClasses();
            List jpaPersistenceTestInstanceGroups = testClasses.groupedJpaPersistenceTests.values().stream().map(jpaPersistenceTestGroup -> jpaPersistenceTestGroup.stream().map(testClass -> {
                JUnit4TestAdapter jUnit4TestAdapter = new JUnit4TestAdapter(testClass);
                try {
                    jUnit4TestAdapter.filter((Filter)Categories.CategoryFilter.exclude((Class[])excludedGroups));
                }
                catch (NoTestsRemainException e) {
                    jUnit4TestAdapter = null;
                }
                return jUnit4TestAdapter;
            }).filter(Objects::nonNull).collect(Collectors.toList())).filter(collection -> !collection.isEmpty()).sorted(Comparator.comparingInt(List::size).reversed()).collect(Collectors.toList());
            int jpaTestCases = jpaPersistenceTestInstanceGroups.stream().mapToInt(group -> group.stream().mapToInt(JUnit4TestAdapter::countTestCases).sum()).sum();
            int jpaTestCasesPerFork = jpaTestCases / forkCount;
            int processedTestCases = 0;
            for (List group2 : jpaPersistenceTestInstanceGroups) {
                boolean partOfFork = processedTestCases / jpaTestCasesPerFork + 1 == fork;
                for (JUnit4TestAdapter jUnit4TestAdapter : group2) {
                    processedTestCases += jUnit4TestAdapter.countTestCases();
                    if (!partOfFork) continue;
                    suite.addTest((Test)jUnit4TestAdapter);
                }
            }
            List nonJpaPersistenceTestInstances = testClasses.nonJpaPersistenceTests.stream().sorted(Comparator.comparing(Class::getCanonicalName)).map(testClass -> {
                JUnit4TestAdapter jUnit4TestAdapter = new JUnit4TestAdapter(testClass);
                try {
                    jUnit4TestAdapter.filter((Filter)Categories.CategoryFilter.exclude((Class[])excludedGroups));
                    return jUnit4TestAdapter;
                }
                catch (NoTestsRemainException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            int nonJpaTestCasesPerFork = nonJpaPersistenceTestInstances.stream().mapToInt(JUnit4TestAdapter::countTestCases).sum() / forkCount;
            processedTestCases = 0;
            for (JUnit4TestAdapter jUnit4TestAdapter : nonJpaPersistenceTestInstances) {
                if (processedTestCases / nonJpaTestCasesPerFork + 1 == fork) {
                    suite.addTest((Test)jUnit4TestAdapter);
                }
                processedTestCases += jUnit4TestAdapter.countTestCases();
            }
            LOG.info("Fork " + fork + "/" + forkCount + " is running " + suite.countTestCases() + " test cases");
        }
        return suite;
    }

    private static List<List<JUnit4TestAdapter>> splitGroup(List<JUnit4TestAdapter> group, int splitFactor) {
        ArrayList<List<JUnit4TestAdapter>> splitGroup = new ArrayList<List<JUnit4TestAdapter>>(splitFactor);
        for (int i = 0; i < splitFactor; ++i) {
            splitGroup.add(new ArrayList());
        }
        group = group.stream().sorted(Comparator.comparing(JUnit4TestAdapter::countTestCases).reversed()).collect(Collectors.toList());
        for (int testClassIdx = 0; testClassIdx < group.size(); ++testClassIdx) {
            ((List)splitGroup.get(testClassIdx % splitFactor)).add((JUnit4TestAdapter)group.get(testClassIdx));
        }
        return splitGroup;
    }
}

