/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa;

import com.blazebit.persistence.testsuite.base.jpa.AbstractJpaPersistenceTest;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class BlazePersistenceTestsuite {
    protected static Class<?>[] loadExcludedGroups() {
        String excludedGroupsProperty = System.getProperty("excludedGroups");
        Class[] excludedGroups = excludedGroupsProperty == null ? new Class[]{} : (Class[])Arrays.stream(excludedGroupsProperty.split(",")).map(groupName -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(groupName.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Class[]::new);
        return excludedGroups;
    }

    protected static TestClasses loadAndGroupTestClasses() {
        Map groupedJpaPersistenceTests;
        String testsuitePackage = System.getProperty("testBasePackage");
        HashSet nonJpaPersistenceTests = new HashSet();
        try (ScanResult scanResult = new ClassGraph().enableAnnotationInfo().enableMethodInfo().enableClassInfo().enableExternalClasses().acceptPackages(new String[]{testsuitePackage}).scan();){
            ClassInfoList allTests = scanResult.getClassesWithMethodAnnotation(Test.class.getName());
            ClassInfoList potentialJpaPersistenceTests = scanResult.getSubclasses(AbstractJpaPersistenceTest.class.getName());
            HashSet<ClassInfo> jpaPersistenceTests = new HashSet<ClassInfo>();
            for (ClassInfo testClass : allTests) {
                if (potentialJpaPersistenceTests.contains((Object)testClass)) {
                    jpaPersistenceTests.add(testClass);
                    continue;
                }
                try {
                    nonJpaPersistenceTests.add(Thread.currentThread().getContextClassLoader().loadClass(testClass.getName()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            groupedJpaPersistenceTests = jpaPersistenceTests.stream().collect(Collectors.groupingBy(jpaPersistenceTestInfo -> {
                AbstractJpaPersistenceTest jpaPersistenceTest = BlazePersistenceTestsuite.instantiateAbstractJpaPersistenceTest(jpaPersistenceTestInfo);
                return BlazePersistenceTestsuite.getEntityClasses(jpaPersistenceTest);
            }, Collectors.mapping(jpaPersistenceTestInfo -> {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass(jpaPersistenceTestInfo.getName());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }, Collectors.toList())));
        }
        return new TestClasses(groupedJpaPersistenceTests, nonJpaPersistenceTests);
    }

    private static Set<Class<?>> getEntityClasses(AbstractJpaPersistenceTest jpaPersistenceTest) {
        try {
            Method m = AbstractJpaPersistenceTest.class.getDeclaredMethod("getEntityClasses", new Class[0]);
            m.setAccessible(true);
            return new HashSet(Arrays.asList((Class[])m.invoke((Object)jpaPersistenceTest, new Object[0])));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static AbstractJpaPersistenceTest instantiateAbstractJpaPersistenceTest(ClassInfo testClassInfo) {
        AbstractJpaPersistenceTest testInstance;
        Class<?> testClass;
        try {
            testClass = Thread.currentThread().getContextClassLoader().loadClass(testClassInfo.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        MethodInfoList parametersMethods = testClassInfo.getMethodInfo().filter(methodInfo -> methodInfo.getAnnotationInfo(Parameterized.Parameters.class.getName()) != null);
        if (parametersMethods.isEmpty()) {
            try {
                testInstance = (AbstractJpaPersistenceTest)testClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else if (parametersMethods.size() == 1) {
            try {
                Method parametersMethod = testClass.getMethod(((MethodInfo)parametersMethods.get(0)).getName(), new Class[0]);
                Object parameters = parametersMethod.invoke(null, new Object[0]);
                Object[] firstParameterSet = parameters instanceof Collection ? (Object[])((Collection)parameters).iterator().next() : (Object[])((Object[])parameters)[0];
                Constructor targetConstructor = Arrays.stream(testClass.getConstructors()).filter(constructor -> constructor.getParameterCount() == firstParameterSet.length).findFirst().get();
                testInstance = (AbstractJpaPersistenceTest)targetConstructor.newInstance(firstParameterSet);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Found more than 1 method annotated with " + Parameterized.Parameters.class.getName() + " in test class " + testClassInfo.getName());
        }
        return testInstance;
    }

    static final class TestClasses {
        final Map<Set<Class<?>>, List<Class<? extends AbstractJpaPersistenceTest>>> groupedJpaPersistenceTests;
        final Set<Class<?>> nonJpaPersistenceTests;

        private TestClasses(Map<Set<Class<?>>, List<Class<? extends AbstractJpaPersistenceTest>>> groupedJpaPersistenceTests, Set<Class<?>> nonJpaPersistenceTests) {
            this.groupedJpaPersistenceTests = groupedJpaPersistenceTests;
            this.nonJpaPersistenceTests = nonJpaPersistenceTests;
        }
    }
}

