/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.assertion;

import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.FromItemVisitorAdapter;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.update.Update;
import org.junit.Assert;

public abstract class AbstractAssertStatement
implements AssertStatement {
    private static final Pattern ORACLE_SCHEMA_PREFIX = Pattern.compile("c##\\w+\\.");
    protected final List<String> tables;

    public AbstractAssertStatement(List<String> tables) {
        this.tables = tables;
    }

    protected void validateTables(String query) {
        query = query.toLowerCase();
        if (!this.tables.isEmpty()) {
            List<String> fromElements = this.getFromElements(query);
            ArrayList<String> missingFromElements = new ArrayList<String>(this.tables);
            missingFromElements.removeAll(fromElements);
            fromElements.removeAll(this.tables);
            Assert.assertTrue((String)("Expected from elements don't match. Missing " + missingFromElements + ", Unexpected " + fromElements + "\nQuery: " + query), (fromElements.isEmpty() && missingFromElements.isEmpty() ? 1 : 0) != 0);
        }
    }

    protected static String stripReturningClause(String query) {
        String newTableStateQualifier;
        String oldTableStateQualifier;
        int tableStateIndex;
        int outputIndex;
        int returningIndex = query.lastIndexOf(" returning ");
        if (returningIndex != -1) {
            query = query.substring(0, returningIndex);
        }
        if ((outputIndex = query.lastIndexOf(" output ")) != -1) {
            int targetIndex = query.indexOf(" from ");
            if (targetIndex == -1 || targetIndex == query.lastIndexOf("delete from ") + "delete".length()) {
                targetIndex = query.indexOf(" where ");
            }
            query = query.substring(0, outputIndex) + query.substring(targetIndex);
        }
        if ((tableStateIndex = query.lastIndexOf(oldTableStateQualifier = " from old table (")) != -1) {
            query = query.substring(tableStateIndex + oldTableStateQualifier.length(), query.length() - 1);
        }
        if ((tableStateIndex = query.lastIndexOf(newTableStateQualifier = " from final table (")) != -1) {
            query = query.substring(tableStateIndex + newTableStateQualifier.length(), query.length() - 1);
        }
        return query;
    }

    protected List<String> getFromElements(String query) {
        try {
            query = ORACLE_SCHEMA_PREFIX.matcher(query).replaceAll("");
            Statement statement = CCJSqlParserUtil.parse((String)query);
            List<Table> tables = this.getTables(statement);
            return this.tableNames(tables);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> tableNames(Collection<Table> tables) {
        ArrayList<String> tableNames = new ArrayList<String>(tables.size());
        for (Table t : tables) {
            tableNames.add(t.getName());
        }
        return tableNames;
    }

    protected List<String> getFetchedFromElements(String query) {
        try {
            Select select;
            query = ORACLE_SCHEMA_PREFIX.matcher(query).replaceAll("");
            Statement statement = CCJSqlParserUtil.parse((String)query);
            final List<Table> tables = this.getTables(statement);
            final HashSet<Table> fetchedTables = new HashSet<Table>();
            if (statement instanceof Select && (select = (Select)statement).getSelectBody() instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
                for (SelectItem item : plainSelect.getSelectItems()) {
                    if (!(item instanceof SelectExpressionItem)) continue;
                    ((SelectExpressionItem)item).getExpression().accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                        public void visit(Column column) {
                            Table t = column.getTable();
                            Table realTable = AbstractAssertStatement.this.findTable(tables, t.getName());
                            if (realTable == null) {
                                throw new IllegalStateException("Table '" + t + "' not found in determined tables: " + tables);
                            }
                            fetchedTables.add(realTable);
                        }
                    });
                }
            }
            return this.tableNames(fetchedTables);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }

    private Table findTable(List<Table> tables, String alias) {
        for (Table t : tables) {
            if (!alias.equals(t.getAlias().getName())) continue;
            return t;
        }
        return null;
    }

    private List<Table> getTables(Statement statement) {
        if (statement instanceof Select) {
            Select select = (Select)statement;
            if (select.getSelectBody() instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)select.getSelectBody();
                final ArrayList<Table> tables = new ArrayList<Table>();
                FromItemVisitorAdapter visitor = new FromItemVisitorAdapter(){

                    public void visit(Table table) {
                        tables.add(table);
                    }

                    public void visit(SubJoin subjoin) {
                        subjoin.getLeft().accept((FromItemVisitor)this);
                        for (Join join : subjoin.getJoinList()) {
                            join.getRightItem().accept((FromItemVisitor)this);
                        }
                    }
                };
                plainSelect.getFromItem().accept((FromItemVisitor)visitor);
                if (plainSelect.getJoins() != null) {
                    for (Join j : plainSelect.getJoins()) {
                        j.getRightItem().accept((FromItemVisitor)visitor);
                    }
                }
                return tables;
            }
        } else {
            if (statement instanceof Insert) {
                Insert insert = (Insert)statement;
                return Collections.singletonList(insert.getTable());
            }
            if (statement instanceof Update) {
                Update update = (Update)statement;
                if (update.getJoins() != null && !update.getJoins().isEmpty()) {
                    for (Join join : update.getJoins()) {
                        if (!join.getRightItem().getAlias().getName().equals(update.getTable().getName())) continue;
                        return Collections.singletonList((Table)join.getRightItem());
                    }
                }
                return Collections.singletonList(update.getTable());
            }
            if (statement instanceof Delete) {
                Delete delete = (Delete)statement;
                if (delete.getTables().size() == 1) {
                    Table t = (Table)delete.getTables().get(0);
                    for (Join join : delete.getJoins()) {
                        if (!join.getRightItem().getAlias().getName().equals(t.getName())) continue;
                        return Collections.singletonList((Table)join.getRightItem());
                    }
                    return Collections.singletonList(t);
                }
                return Collections.singletonList(delete.getTable());
            }
            if (statement instanceof Merge) {
                Merge merge = (Merge)statement;
                return Collections.singletonList(merge.getTable());
            }
        }
        return Collections.emptyList();
    }
}

