/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.assertion;

import com.blazebit.persistence.testsuite.base.jpa.RelationalModelAccessor;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatement;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatementBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAssertStatementBuilder<T extends AbstractAssertStatementBuilder<T>> {
    protected final List<String> tables = new ArrayList<String>();
    private final AssertStatementBuilder parentBuilder;
    private final RelationalModelAccessor relationalModelAccessor;

    public AbstractAssertStatementBuilder(AssertStatementBuilder parentBuilder, RelationalModelAccessor relationalModelAccessor) {
        this.parentBuilder = parentBuilder;
        this.relationalModelAccessor = relationalModelAccessor;
        parentBuilder.setCurrentBuilder(this);
    }

    protected abstract AssertStatement build();

    public T forEntity(Class<?> entityClass) {
        String table = this.tableFromEntity(entityClass);
        if (table != null) {
            this.tables.add(table);
        }
        return (T)this;
    }

    public T forRelation(Class<?> entityClass, String relationName) {
        String table = this.tableFromEntityRelation(entityClass, relationName);
        if (table != null) {
            this.tables.add(table);
        }
        return (T)this;
    }

    public AssertStatementBuilder and() {
        this.parentBuilder.unsetCurrentBuilder(this);
        this.parentBuilder.addStatement(this.build());
        return this.parentBuilder;
    }

    public void validate() {
        this.and().validate();
    }

    protected String tableFromEntity(Class<?> entityClass) {
        if (this.relationalModelAccessor == null) {
            return null;
        }
        return this.relationalModelAccessor.tableFromEntity(entityClass).toLowerCase();
    }

    protected String tableFromEntityRelation(Class<?> entityClass, String relationName) {
        if (this.relationalModelAccessor == null) {
            return null;
        }
        return this.relationalModelAccessor.tableFromEntityRelation(entityClass, relationName).toLowerCase();
    }
}

