/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.assertion;

import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatement;
import java.util.ArrayList;
import java.util.List;
import org.opentest4j.MultipleFailuresError;

public class AssertMultiStatement
implements AssertStatement {
    private final List<AssertStatement> statements;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private int validations;

    public AssertMultiStatement(List<AssertStatement> statements) {
        this.statements = statements;
        this.validations = statements.size();
    }

    @Override
    public void validate(String query) {
        --this.validations;
        ArrayList<Throwable> tryFailures = new ArrayList<Throwable>();
        boolean failed = true;
        for (int i = 0; i < this.statements.size(); ++i) {
            try {
                this.statements.get(i).validate(query);
                this.statements.remove(i);
                failed = false;
                break;
            }
            catch (Throwable t) {
                tryFailures.add(t);
                continue;
            }
        }
        if (failed) {
            this.failures.addAll(tryFailures);
        }
        if (this.validations == 0 && !this.failures.isEmpty()) {
            throw new MultipleFailuresError("Multiple query validations failed", this.failures);
        }
    }
}

