/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.assertion;

import com.blazebit.persistence.testsuite.base.jpa.assertion.AbstractAssertStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.junit.Assert;

public class AssertSelectStatement
extends AbstractAssertStatement {
    private final List<String> fetchedTables;

    public AssertSelectStatement(List<String> tables, List<String> fetchedTables) {
        super(tables);
        this.fetchedTables = fetchedTables;
    }

    @Override
    public void validate(String query) {
        if (!(query = query.toLowerCase()).startsWith("select ")) {
            int selectIndex;
            if (!query.startsWith("with ") || (selectIndex = query.indexOf(") select ")) == -1) {
                Assert.fail((String)("Query is not a select statement: " + query));
                return;
            }
            query = query.substring(selectIndex + 2);
        }
        this.validateTables(query);
        if (!this.fetchedTables.isEmpty()) {
            List<String> fromElements = this.getFetchedFromElements(query);
            ArrayList<String> missingFromElements = new ArrayList<String>(this.fetchedTables);
            ListIterator<String> iter = fromElements.listIterator();
            while (iter.hasNext()) {
                String element = iter.next();
                if (!missingFromElements.remove(element)) continue;
                iter.remove();
            }
            Assert.assertTrue((String)("Expected fetched from elements don't match. Missing " + missingFromElements + ", Unexpected " + fromElements + "\nQuery: " + query), (fromElements.isEmpty() && missingFromElements.isEmpty() ? 1 : 0) != 0);
        }
    }
}

