/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.assertion;

import com.blazebit.persistence.testsuite.base.jpa.RelationalModelAccessor;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertDeleteStatementBuilder;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertInsertStatementBuilder;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertMultiStatementBuilder;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertSelectStatementBuilder;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertStatement;
import com.blazebit.persistence.testsuite.base.jpa.assertion.AssertUpdateStatementBuilder;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.opentest4j.MultipleFailuresError;

public class AssertStatementBuilder {
    protected final RelationalModelAccessor relationalModelAccessor;
    protected final List<String> queries;
    protected final List<AssertStatement> statements = new ArrayList<AssertStatement>();
    protected Object currentBuilder;
    protected boolean validated;

    public AssertStatementBuilder(RelationalModelAccessor relationalModelAccessor, List<String> queries) {
        this.relationalModelAccessor = relationalModelAccessor;
        this.queries = queries;
    }

    void setCurrentBuilder(Object currentBuilder) {
        if (this.currentBuilder != null) {
            throw new IllegalStateException("Unfinished builder: " + this.currentBuilder);
        }
        this.currentBuilder = currentBuilder;
    }

    void unsetCurrentBuilder(Object currentBuilder) {
        if (this.currentBuilder == null) {
            throw new IllegalStateException("Unregistered builder: " + currentBuilder);
        }
        if (this.currentBuilder != currentBuilder) {
            throw new IllegalStateException("Wrong builder unset: " + currentBuilder);
        }
        this.currentBuilder = null;
    }

    void validateBuilderEnded() {
        if (this.currentBuilder != null) {
            throw new IllegalStateException("Unfinished builder: " + this.currentBuilder);
        }
    }

    public AssertMultiStatementBuilder unordered() {
        this.failIfValidated();
        return new AssertMultiStatementBuilder(this, this.relationalModelAccessor);
    }

    public AssertStatementBuilder select() {
        return this.assertSelect().and();
    }

    public AssertStatementBuilder select(Class<?> entityClass) {
        return ((AssertSelectStatementBuilder)this.assertSelect().forEntity(entityClass)).and();
    }

    public AssertStatementBuilder select(Class<?> entityClass, String relationName) {
        return ((AssertSelectStatementBuilder)this.assertSelect().forRelation(entityClass, relationName)).and();
    }

    public AssertSelectStatementBuilder assertSelect() {
        this.failIfValidated();
        return new AssertSelectStatementBuilder(this, this.relationalModelAccessor);
    }

    public AssertStatementBuilder insert() {
        return this.assertInsert().and();
    }

    public AssertStatementBuilder insert(Class<?> entityClass) {
        return ((AssertInsertStatementBuilder)this.assertInsert().forEntity(entityClass)).and();
    }

    public AssertStatementBuilder insert(Class<?> entityClass, String relationName) {
        return ((AssertInsertStatementBuilder)this.assertInsert().forRelation(entityClass, relationName)).and();
    }

    public AssertInsertStatementBuilder assertInsert() {
        this.failIfValidated();
        return new AssertInsertStatementBuilder(this, this.relationalModelAccessor);
    }

    public AssertStatementBuilder update() {
        return this.assertUpdate().and();
    }

    public AssertStatementBuilder update(Class<?> entityClass) {
        return ((AssertUpdateStatementBuilder)this.assertUpdate().forEntity(entityClass)).and();
    }

    public AssertStatementBuilder update(Class<?> entityClass, String relationName) {
        return ((AssertUpdateStatementBuilder)this.assertUpdate().forRelation(entityClass, relationName)).and();
    }

    public AssertUpdateStatementBuilder assertUpdate() {
        this.failIfValidated();
        return new AssertUpdateStatementBuilder(this, this.relationalModelAccessor);
    }

    public AssertStatementBuilder delete() {
        return this.assertDelete().and();
    }

    public AssertStatementBuilder delete(Class<?> entityClass) {
        return ((AssertDeleteStatementBuilder)this.assertDelete().forEntity(entityClass)).and();
    }

    public AssertStatementBuilder delete(Class<?> entityClass, String relationName) {
        return ((AssertDeleteStatementBuilder)this.assertDelete().forRelation(entityClass, relationName)).and();
    }

    public AssertDeleteStatementBuilder assertDelete() {
        this.failIfValidated();
        return new AssertDeleteStatementBuilder(this, this.relationalModelAccessor);
    }

    protected void failIfValidated() {
        if (this.validated) {
            throw new AssertionError((Object)"Already validated!");
        }
    }

    public AssertStatementBuilder addStatement(AssertStatement statement) {
        this.statements.add(statement);
        return this;
    }

    public void validate() {
        this.failIfValidated();
        this.validated = true;
        if (this.statements.size() != this.queries.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unexpected query count for queries:");
            for (String q : this.queries) {
                sb.append("\n").append(q);
            }
            Assert.assertEquals((String)sb.toString(), (long)this.statements.size(), (long)this.queries.size());
        }
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (int i = 0; i < this.statements.size(); ++i) {
            try {
                this.statements.get(i).validate(this.queries.get(i));
                continue;
            }
            catch (Throwable t) {
                if (t instanceof MultipleFailuresError) {
                    failures.addAll(((MultipleFailuresError)t).getFailures());
                    continue;
                }
                failures.add(t);
            }
        }
        if (!failures.isEmpty()) {
            throw new MultipleFailuresError("Multiple query validations failed", failures);
        }
    }
}

