/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.cleaner;

import com.blazebit.persistence.testsuite.base.jpa.UncheckedSqlException;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.DatabaseCleaner;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hc.core5.net.URIBuilder;

public abstract class AbstractMySQLDatabaseCleaner
implements DatabaseCleaner {
    private static final Logger LOG = Logger.getLogger(AbstractMySQLDatabaseCleaner.class.getName());
    private static final String SYSTEM_SCHEMAS = "'information_schema','mysql','sys','performance_schema'";
    private final List<String> ignoredTables = new ArrayList<String>();
    private final Map<String, List<String>> clearingSqlsPerSchema = new HashMap<String, List<String>>();

    @Override
    public boolean supportsClearSchema() {
        return true;
    }

    @Override
    public void addIgnoredTable(String tableName) {
        this.ignoredTables.add(tableName);
    }

    @Override
    public void clearAllSchemas(Connection connection) {
        try {
            this.clearSchema(connection, connection.getSchema());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearSchema(Connection connection, String schemaName) {
        this.clearSchema0(connection, schemaName);
    }

    private void clearSchema0(Connection c, String schemaName) {
        try (Statement s = c.createStatement();){
            LOG.log(Level.FINEST, "Collect table names: START");
            ResultSet rs = s.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA " + (schemaName == null ? "NOT IN ('information_schema', 'performance_schema', 'mysql', 'sys')" : "= '" + schemaName + "'"));
            StringBuilder sb = new StringBuilder("DROP TABLE ");
            if (rs.next()) {
                do {
                    String tableSchema = rs.getString(1);
                    String tableName = rs.getString(2);
                    sb.append(tableSchema);
                    sb.append('.');
                    sb.append(tableName);
                    sb.append(',');
                } while (rs.next());
            } else {
                return;
            }
            sb.setCharAt(sb.length() - 1, ' ');
            LOG.log(Level.FINEST, "Collect table names: END");
            LOG.log(Level.FINEST, "Disable foreign keys: START");
            s.execute("SET FOREIGN_KEY_CHECKS = 0");
            LOG.log(Level.FINEST, "Disable foreign keys: END");
            LOG.log(Level.FINEST, "Dropping tables: START");
            String sql = sb.toString();
            s.execute(sql);
            LOG.log(Level.FINEST, "Dropping tables: END");
            LOG.log(Level.FINEST, "Enabling foreign keys: START");
            s.execute("SET FOREIGN_KEY_CHECKS = 1");
            LOG.log(Level.FINEST, "Enabling foreign keys: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearAllData(Connection connection) {
        this.clearData0(connection, null, s -> {
            try {
                return s.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA NOT IN ('information_schema','mysql','sys','performance_schema')");
            }
            catch (SQLException e) {
                throw new UncheckedSqlException(e);
            }
        });
    }

    @Override
    public void clearData(Connection connection, String schemaName) {
        this.clearData0(connection, schemaName, s -> {
            try {
                return s.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + schemaName + "'");
            }
            catch (SQLException e) {
                throw new UncheckedSqlException(e);
            }
        });
    }

    private void clearData0(Connection connection, String schemaName, Function<Statement, ResultSet> tablesProvider) {
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Disable foreign keys: START");
            s.execute("SET FOREIGN_KEY_CHECKS = 0");
            LOG.log(Level.FINEST, "Disable foreign keys: END");
            LOG.log(Level.FINEST, "Deleting data: START");
            List<String> clearingSqls = this.clearingSqlsPerSchema.get(schemaName);
            if (clearingSqls == null) {
                clearingSqls = new ArrayList<String>();
                ResultSet rs = tablesProvider.apply(s);
                while (rs.next()) {
                    String tableSchema = rs.getString(1);
                    String tableName = rs.getString(2);
                    if (this.ignoredTables.contains(tableName)) continue;
                    clearingSqls.add(this.createClearingStatementForTable(tableSchema, tableName));
                }
                this.clearingSqlsPerSchema.put(schemaName, clearingSqls);
            }
            for (String clearingSql : clearingSqls) {
                s.execute(clearingSql);
            }
            LOG.log(Level.FINEST, "Deleting data: END");
            LOG.log(Level.FINEST, "Enabling foreign keys: START");
            s.execute("SET FOREIGN_KEY_CHECKS = 1");
            LOG.log(Level.FINEST, "Enabling foreign keys: END");
            LOG.log(Level.FINEST, "Committing: START");
            connection.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (UncheckedSqlException | SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract String createClearingStatementForTable(String var1, String var2);

    @Override
    public void createDatabaseIfNotExists(Connection connection, String databaseName) {
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Create schema: START");
            s.execute("CREATE DATABASE IF NOT EXISTS " + databaseName);
            LOG.log(Level.FINEST, "Create schema: END");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createSchemaIfNotExists(Connection connection, String schemaName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTargetDatabasePropertyModifications(Map<Object, Object> properties, String databaseName) {
        String jdbcUrl = (String)properties.get("javax.persistence.jdbc.url");
        try {
            jdbcUrl = "jdbc:" + new URIBuilder(jdbcUrl.substring(jdbcUrl.indexOf(58) + 1)).setPath(databaseName).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException();
        }
        properties.put("javax.persistence.jdbc.url", jdbcUrl);
    }

    @Override
    public void applyTargetSchemaPropertyModifications(Map<Object, Object> properties, String schemaName) {
        throw new UnsupportedOperationException();
    }
}

