/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.cleaner;

import com.blazebit.persistence.testsuite.base.jpa.cleaner.DatabaseCleaner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DB2DatabaseCleaner
implements DatabaseCleaner {
    private static final Logger LOG = Logger.getLogger(DB2DatabaseCleaner.class.getName());
    private static final String SYSTEM_SCHEMAS = "'SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS'";
    private final List<String> ignoredTables = new ArrayList<String>();
    private final Map<String, Map<String, List<String>>> cachedForeignKeysPerSchema = new HashMap<String, Map<String, List<String>>>();

    @Override
    public boolean isApplicable(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName().startsWith("DB2");
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not resolve the database metadata!", e);
        }
    }

    @Override
    public boolean supportsClearSchema() {
        return true;
    }

    @Override
    public void addIgnoredTable(String tableName) {
        this.ignoredTables.add(tableName);
    }

    @Override
    public void clearAllSchemas(Connection c) {
        try (Statement s = c.createStatement();){
            ArrayList<String> sqls = new ArrayList<String>();
            LOG.log(Level.FINEST, "Collect schema objects: START");
            ResultSet rs = s.executeQuery("SELECT 'DROP INDEX \"' || TRIM(INDSCHEMA) || '\".\"' || TRIM(INDNAME) || '\"' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'D' AND INDSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP FOREIGN KEY \"' || TRIM(CONSTNAME) || '\"' FROM SYSCAT.TABCONST WHERE TYPE = 'F' AND TABSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP UNIQUE \"' || TRIM(INDNAME) || '\"' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'U' AND INDSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP PRIMARY KEY' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'P' AND INDSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP VIEW \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\"' FROM SYSCAT.TABLES WHERE TYPE = 'V' AND TABSCHEMA  NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\"' FROM SYSCAT.TABLES WHERE TYPE = 'T' AND TABSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP SEQUENCE \"' || TRIM(SEQSCHEMA) || '\".\"' || TRIM(SEQNAME) || '\"' FROM SYSCAT.SEQUENCES WHERE SEQSCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            LOG.log(Level.FINEST, "Collect schema objects: END");
            LOG.log(Level.FINEST, "Dropping schema objects: START");
            for (String sql : sqls) {
                try {
                    s.execute(sql);
                }
                catch (SQLException e) {
                    if (-204 == e.getErrorCode()) continue;
                    throw e;
                }
            }
            LOG.log(Level.FINEST, "Dropping schema objects: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearSchema(Connection c, String schemaName) {
        schemaName = schemaName.toUpperCase();
        try (Statement s = c.createStatement();){
            ArrayList<String> sqls = new ArrayList<String>();
            LOG.log(Level.FINEST, "Collect schema objects: START");
            ResultSet rs = s.executeQuery("SELECT 'DROP INDEX \"' || TRIM(INDSCHEMA) || '\".\"' || TRIM(INDNAME) || '\"' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'D' AND INDSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP FOREIGN KEY \"' || TRIM(CONSTNAME) || '\"' FROM SYSCAT.TABCONST WHERE TYPE = 'F' AND TABSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP UNIQUE \"' || TRIM(INDNAME) || '\"' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'U' AND INDSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'ALTER TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\" DROP PRIMARY KEY' FROM SYSCAT.INDEXES WHERE UNIQUERULE = 'P' AND INDSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP VIEW \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\"' FROM SYSCAT.TABLES WHERE TYPE = 'V' AND TABSCHEMA  = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP TABLE \"' || TRIM(TABSCHEMA) || '\".\"' || TRIM(TABNAME) || '\"' FROM SYSCAT.TABLES WHERE TYPE = 'T' AND TABSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            rs = s.executeQuery("SELECT 'DROP SEQUENCE \"' || TRIM(SEQSCHEMA) || '\".\"' || TRIM(SEQNAME) || '\"' FROM SYSCAT.SEQUENCES WHERE SEQSCHEMA = '" + schemaName + "'");
            while (rs.next()) {
                sqls.add(rs.getString(1));
            }
            LOG.log(Level.FINEST, "Collect schema objects: END");
            LOG.log(Level.FINEST, "Dropping schema objects: START");
            for (String sql : sqls) {
                try {
                    s.execute(sql);
                }
                catch (SQLException e) {
                    if (-204 == e.getErrorCode()) continue;
                    throw e;
                }
            }
            LOG.log(Level.FINEST, "Dropping schema objects: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearAllData(Connection connection) {
        Map<String, List<String>> cachedForeignKeys = this.cachedForeignKeysPerSchema.get(null);
        if (cachedForeignKeys == null) {
            cachedForeignKeys = this.collectAllForeignKeys(connection);
            this.cachedForeignKeysPerSchema.put(null, cachedForeignKeys);
        }
        this.deleteAllData(connection, cachedForeignKeys);
    }

    @Override
    public void clearData(Connection connection, String schemaName) {
        Map<String, List<String>> cachedForeignKeys = this.cachedForeignKeysPerSchema.get(schemaName);
        if (cachedForeignKeys == null) {
            cachedForeignKeys = this.collectForeignKeys(connection, schemaName.toUpperCase());
            this.cachedForeignKeysPerSchema.put(schemaName, cachedForeignKeys);
        }
        this.deleteAllData(connection, cachedForeignKeys);
    }

    private Map<String, List<String>> collectAllForeignKeys(Connection c) {
        HashMap<String, List<String>> hashMap;
        block12: {
            Statement s = c.createStatement();
            try {
                LOG.log(Level.FINEST, "Collect table names: START");
                ResultSet rs = s.executeQuery("SELECT TABLE_SCHEMA || '.' || TABLE_NAME FROM SYSIBM.TABLES WHERE TABLE_SCHEMA NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
                HashMap<String, List<String>> foreignKeys = new HashMap<String, List<String>>();
                while (rs.next()) {
                    foreignKeys.put(rs.getString(1), new ArrayList());
                }
                LOG.log(Level.FINEST, "Collect table names: END");
                LOG.log(Level.FINEST, "Collect foreign keys: START");
                ResultSet rs2 = s.executeQuery("SELECT FKTABLE_SCHEM || '.' || FKTABLE_NAME, FK_NAME FROM SYSIBM.SQLFOREIGNKEYS WHERE FKTABLE_SCHEM NOT IN ('SYSCAT','SYSIBM','SYSIBMADM','SYSPUBLIC','SYSSTAT','SYSTOOLS')");
                while (rs2.next()) {
                    ((List)foreignKeys.get(rs2.getString(1))).add(rs2.getString(2));
                }
                LOG.log(Level.FINEST, "Collect foreign keys: END");
                hashMap = foreignKeys;
                if (s == null) break block12;
            }
            catch (Throwable rs) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            rs.addSuppressed(throwable);
                        }
                    }
                    throw rs;
                }
                catch (SQLException e) {
                    try {
                        c.rollback();
                    }
                    catch (SQLException e1) {
                        e.addSuppressed(e1);
                    }
                    throw new RuntimeException(e);
                }
            }
            s.close();
        }
        return hashMap;
    }

    private Map<String, List<String>> collectForeignKeys(Connection c, String schemaName) {
        HashMap<String, List<String>> hashMap;
        block12: {
            Statement s = c.createStatement();
            try {
                LOG.log(Level.FINEST, "Collect table names: START");
                ResultSet rs = s.executeQuery("SELECT TRIM(TABLE_SCHEMA) || '.' || TABLE_NAME FROM SYSIBM.TABLES WHERE TABLE_SCHEMA = '" + schemaName + "'");
                HashMap<String, List<String>> foreignKeys = new HashMap<String, List<String>>();
                while (rs.next()) {
                    foreignKeys.put(rs.getString(1), new ArrayList());
                }
                LOG.log(Level.FINEST, "Collect table names: END");
                LOG.log(Level.FINEST, "Collect foreign keys: START");
                ResultSet rs2 = s.executeQuery("SELECT FKTABLE_SCHEM || '.' || FKTABLE_NAME, FK_NAME FROM SYSIBM.SQLFOREIGNKEYS WHERE FKTABLE_SCHEM = '" + schemaName + "'");
                while (rs2.next()) {
                    ((List)foreignKeys.get(rs2.getString(1))).add(rs2.getString(2));
                }
                LOG.log(Level.FINEST, "Collect foreign keys: END");
                hashMap = foreignKeys;
                if (s == null) break block12;
            }
            catch (Throwable rs) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable) {
                            rs.addSuppressed(throwable);
                        }
                    }
                    throw rs;
                }
                catch (SQLException e) {
                    try {
                        c.rollback();
                    }
                    catch (SQLException e1) {
                        e.addSuppressed(e1);
                    }
                    throw new RuntimeException(e);
                }
            }
            s.close();
        }
        return hashMap;
    }

    private void deleteAllData(Connection c, Map<String, List<String>> foreignKeys) {
        try (Statement s = c.createStatement();){
            LOG.log(Level.FINEST, "Disable foreign keys: START");
            for (Map.Entry<String, List<String>> entry : foreignKeys.entrySet()) {
                for (String fk : entry.getValue()) {
                    s.execute("ALTER TABLE " + entry.getKey() + " ALTER FOREIGN KEY " + fk + " NOT ENFORCED");
                }
            }
            c.commit();
            LOG.log(Level.FINEST, "Disable foreign keys: END");
            LOG.log(Level.FINEST, "Deleting data: START");
            for (String string : foreignKeys.keySet()) {
                if (this.ignoredTables.contains(string)) continue;
                s.execute("TRUNCATE TABLE " + string + " IMMEDIATE");
                c.commit();
            }
            LOG.log(Level.FINEST, "Deleting data: END");
            LOG.log(Level.FINEST, "Enabling foreign keys: START");
            for (Map.Entry entry : foreignKeys.entrySet()) {
                for (String fk : (List)entry.getValue()) {
                    s.execute("ALTER TABLE " + (String)entry.getKey() + " ALTER FOREIGN KEY " + fk + " ENFORCED");
                }
            }
            LOG.log(Level.FINEST, "Enabling foreign keys: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createDatabaseIfNotExists(Connection connection, String databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSchemaIfNotExists(Connection connection, String schemaName) {
        schemaName = schemaName.toUpperCase();
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Check if schema exists: START");
            ResultSet schemas = s.executeQuery("SELECT 1 FROM syscat.SCHEMATA WHERE SCHEMANAME = '" + schemaName + "'");
            LOG.log(Level.FINEST, "Check if schema exists: END");
            if (!schemas.next()) {
                LOG.log(Level.FINEST, "Create schema: START");
                s.execute("CREATE SCHEMA " + schemaName);
                LOG.log(Level.FINEST, "Create schema: END");
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyTargetDatabasePropertyModifications(Map<Object, Object> properties, String databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTargetSchemaPropertyModifications(Map<Object, Object> properties, String schemaName) {
        String jdbcUrl = (String)properties.get("javax.persistence.jdbc.url");
        if (!jdbcUrl.endsWith(";")) {
            jdbcUrl = jdbcUrl + ":";
        }
        properties.put("javax.persistence.jdbc.url", jdbcUrl + "currentSchema=" + schemaName.toUpperCase() + ";");
    }

    public static class Factory
    implements DatabaseCleaner.Factory {
        @Override
        public DatabaseCleaner create() {
            return new DB2DatabaseCleaner();
        }
    }
}

