/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.base.jpa.cleaner;

import com.blazebit.persistence.testsuite.base.jpa.UncheckedSqlException;
import com.blazebit.persistence.testsuite.base.jpa.cleaner.DatabaseCleaner;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2DatabaseCleaner
implements DatabaseCleaner {
    private static final Logger LOG = Logger.getLogger(H2DatabaseCleaner.class.getName());
    private static final String SYSTEM_SCHEMAS = "'INFORMATION_SCHEMA'";
    private final List<String> ignoredTables = new ArrayList<String>();
    private final Map<String, List<String>> cachedTableNamesPerSchema = new HashMap<String, List<String>>();

    @Override
    public boolean isApplicable(Connection connection) {
        try {
            return connection.getMetaData().getDatabaseProductName().startsWith("H2");
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not resolve the database metadata!", e);
        }
    }

    @Override
    public boolean supportsClearSchema() {
        return true;
    }

    @Override
    public void addIgnoredTable(String tableName) {
        this.ignoredTables.add(tableName);
    }

    @Override
    public void clearAllSchemas(Connection c) {
        try (Statement s = c.createStatement();){
            LOG.log(Level.FINEST, "Dropping schema objects: START");
            s.execute("DROP ALL OBJECTS");
            LOG.log(Level.FINEST, "Dropping schema objects: END");
            LOG.log(Level.FINEST, "Committing: START");
            c.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (SQLException e) {
            try {
                c.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearSchema(Connection c, String schemaName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearAllData(Connection connection) {
        this.clearData0(connection, null, s -> {
            try {
                return s.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA NOT IN ('INFORMATION_SCHEMA')");
            }
            catch (SQLException sqlException) {
                throw new UncheckedSqlException(sqlException);
            }
        });
    }

    @Override
    public void clearData(Connection connection, String schemaName) {
        this.clearData0(connection, schemaName, s -> {
            try {
                return s.executeQuery("SELECT TABLE_SCHEMA, TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '" + schemaName + "'");
            }
            catch (SQLException sqlException) {
                throw new UncheckedSqlException(sqlException);
            }
        });
    }

    private void clearData0(Connection connection, String schemaName, Function<Statement, ResultSet> tablesProvider) {
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Disable foreign keys: START");
            s.execute("SET REFERENTIAL_INTEGRITY FALSE");
            LOG.log(Level.FINEST, "Disable foreign keys: END");
            LOG.log(Level.FINEST, "Deleting data: START");
            List<String> cachedTableNames = this.cachedTableNamesPerSchema.get(schemaName);
            if (cachedTableNames == null) {
                cachedTableNames = new ArrayList<String>();
                ResultSet rs = tablesProvider.apply(s);
                while (rs.next()) {
                    String tableSchema = rs.getString(1);
                    String tableName = rs.getString(2);
                    if (this.ignoredTables.contains(tableName)) continue;
                    cachedTableNames.add(tableSchema + "." + tableName);
                }
                this.cachedTableNamesPerSchema.put(schemaName, cachedTableNames);
            }
            for (String table : cachedTableNames) {
                s.execute("TRUNCATE TABLE " + table);
            }
            LOG.log(Level.FINEST, "Deleting data: END");
            LOG.log(Level.FINEST, "Enabling foreign keys: START");
            s.execute("SET REFERENTIAL_INTEGRITY TRUE");
            LOG.log(Level.FINEST, "Enabling foreign keys: END");
            LOG.log(Level.FINEST, "Committing: START");
            connection.commit();
            LOG.log(Level.FINEST, "Committing: END");
        }
        catch (UncheckedSqlException | SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createDatabaseIfNotExists(Connection connection, String databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createSchemaIfNotExists(Connection connection, String schemaName) {
        try (Statement s = connection.createStatement();){
            LOG.log(Level.FINEST, "Create schema: START");
            s.execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            LOG.log(Level.FINEST, "Create schema: END");
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e.addSuppressed(e1);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyTargetDatabasePropertyModifications(Map<Object, Object> properties, String databaseName) {
    }

    @Override
    public void applyTargetSchemaPropertyModifications(Map<Object, Object> properties, String schemaName) {
    }

    public static class Factory
    implements DatabaseCleaner.Factory {
        @Override
        public DatabaseCleaner create() {
            return new H2DatabaseCleaner();
        }
    }
}

