/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo;

import com.orientechnologies.orient.core.Orient;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jbake.app.ConfigUtil;
import org.jbake.app.Oven;

@Mojo(name="build", requiresProject=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class BuildMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="jbake.outputDirectory", defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    protected File outputDirectory;
    @Parameter(property="jbake.inputDirectory", defaultValue="${project.basedir}/src/main/jbake", required=true)
    protected File inputDirectory;
    @Parameter(property="jbake.clearCache", defaultValue="false", required=true)
    protected boolean clearCache;
    @Parameter
    protected Map<String, String> properties;
    private Oven oven;

    public void execute() throws MojoExecutionException {
        this.setup();
        this.bake();
    }

    protected void bake() throws MojoExecutionException {
        this.setup();
        try {
            this.oven.bake();
        }
        catch (Throwable ex) {
            this.destroy();
            throw new MojoExecutionException("Failure when running: ", ex);
        }
    }

    protected void setup() throws MojoExecutionException {
        if (this.oven != null) {
            return;
        }
        try {
            Orient.instance().startup();
            this.oven = new Oven(this.inputDirectory, this.outputDirectory, this.createConfiguration(), this.clearCache);
            this.oven.setupPaths();
        }
        catch (Throwable ex) {
            this.destroy();
            throw new MojoExecutionException("Failure when running: ", ex);
        }
    }

    protected void rebuild() throws MojoExecutionException {
        this.oven = null;
        this.setup();
    }

    protected void destroy() {
        this.oven = null;
        try {
            Orient.instance().shutdown();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Error on shutdown", (Throwable)e);
        }
    }

    protected CompositeConfiguration createConfiguration() throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        if (this.properties != null) {
            config.addConfiguration((Configuration)new MapConfiguration(this.properties));
        }
        config.addConfiguration((Configuration)new MapConfiguration(this.project.getProperties()));
        config.addConfiguration((Configuration)ConfigUtil.load((File)this.inputDirectory));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Configuration:");
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                this.getLog().debug((CharSequence)(key + ": " + config.getString(key)));
            }
        }
        return config;
    }
}

