/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo;

import com.blazebit.jbake.mojo.WatchMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

@Mojo(name="serve", requiresDirectInvocation=true, requiresProject=false)
public class ServeMojo
extends WatchMojo {
    @Parameter(property="jbake.listenAddress", defaultValue="0.0.0.0")
    private String listenAddress;
    @Parameter(property="jbake.port", defaultValue="8820")
    private Integer port;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(this.listenAddress);
        connector.setPort(this.port.intValue());
        server.setConnectors(new Connector[]{connector});
        ResourceHandler externalResourceHandler = new ResourceHandler();
        externalResourceHandler.setResourceBase(this.outputDirectory.getPath());
        externalResourceHandler.setWelcomeFiles(new String[]{"index.html"});
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{externalResourceHandler});
        server.setHandler((Handler)handlers);
        this.outputDirectory.mkdirs();
        try {
            server.start();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not start server!", ex);
        }
        try {
            super.execute();
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)"Error on stopping server", (Throwable)ex);
            }
        }
    }
}

