/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.jbake.mojo;

import com.blazebit.jbake.mojo.BuildMojo;
import com.blazebit.jbake.mojo.watcher.WatcherListener;
import com.blazebit.jbake.mojo.watcher.WatcherService;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="watch", requiresDirectInvocation=true, requiresProject=false)
public class WatchMojo
extends BuildMojo {
    private static final long DEFAULT_SLEEP = 1000L;
    private Status status = Status.OK;
    private final WatcherService watcherService = new WatcherService();
    private final Set<String> configFiles = new HashSet<String>(Arrays.asList("custom.properties", "jbake.properties", "default.properties"));

    private void onChange(Path path) {
        this.status = path == null || this.configFiles.contains(path.toString()) ? Status.CONFIG_CHANGED : Status.CHANGED;
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.setup();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WatchMojo.this.watcherService.shutdown();
            }
        });
        this.watcherService.addListener(this.inputDirectory.toPath(), new WatcherListener(){

            @Override
            public void refreshQueued() {
            }

            @Override
            public void refresh() {
                WatchMojo.this.onChange(null);
            }

            @Override
            public void created(Path path) {
                WatchMojo.this.onChange(path);
            }

            @Override
            public void deleted(Path path) {
                WatchMojo.this.onChange(path);
            }

            @Override
            public void modified(Path path) {
                WatchMojo.this.onChange(path);
            }
        });
        this.bake();
        this.getLog().info((CharSequence)("Watching for changes in: " + this.inputDirectory.getPath()));
        this.getLog().info((CharSequence)"Stop with Ctrl + C");
        try {
            try {
                while (true) {
                    Thread.sleep(1000L);
                    this.watcherService.processEvents();
                    if (this.status == Status.OK) continue;
                    this.getLog().info((CharSequence)"Refreshing");
                    if (this.status == Status.CONFIG_CHANGED) {
                        this.rebuild();
                    }
                    this.bake();
                    this.status = Status.OK;
                }
            }
            catch (InterruptedException e) {
                this.getLog().info((CharSequence)"Shutting down...");
                this.watcherService.shutdown();
                return;
            }
        }
        catch (Throwable ex) {
            try {
                throw new MojoExecutionException("Error while baking", ex);
            }
            catch (Throwable throwable) {
                this.getLog().info((CharSequence)"Shutting down...");
                this.watcherService.shutdown();
                throw throwable;
            }
        }
    }

    private static enum Status {
        OK,
        CHANGED,
        CONFIG_CHANGED;

    }
}

